/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.DesignMode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.jxmapviewer.painter.AbstractPainter;
import org.jxmapviewer.painter.Painter;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.Tile;
import org.jxmapviewer.viewer.TileFactory;
import org.jxmapviewer.viewer.TileFactoryInfo;
import org.jxmapviewer.viewer.TileListener;
import org.jxmapviewer.viewer.empty.EmptyTileFactory;

public class JXMapViewer
extends JPanel
implements DesignMode {
    private static final long serialVersionUID = -3530746298586937321L;
    private int zoomLevel = 1;
    private Point2D center = new Point2D.Double(0.0, 0.0);
    private boolean drawTileBorders = false;
    private TileFactory factory;
    private GeoPosition addressLocation;
    private Painter<? super JXMapViewer> overlay;
    private boolean designTime;
    private Image loadingImage;
    private boolean restrictOutsidePanning = true;
    private boolean horizontalWrapped = true;
    private boolean infiniteMapRendering = true;
    private boolean panningEnabled = true;
    private TileListener tileLoadListener = new TileListener(){

        @Override
        public void tileLoaded(Tile tile) {
            if (tile.getZoom() == JXMapViewer.this.getZoom()) {
                JXMapViewer.this.repaint();
            }
        }
    };

    public JXMapViewer() {
        this.factory = new EmptyTileFactory();
        try {
            URL url = JXMapViewer.class.getResource("/images/loading.png");
            this.setLoadingImage(ImageIO.read(url));
        }
        catch (Exception ex) {
            System.out.println("could not load 'loading.png'");
            BufferedImage img = new BufferedImage(16, 16, 2);
            Graphics2D g2 = img.createGraphics();
            g2.setColor(Color.black);
            g2.fillRect(0, 0, 16, 16);
            g2.dispose();
            this.setLoadingImage(img);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.doPaintComponent(g);
    }

    private void doPaintComponent(Graphics g) {
        if (!this.isDesignTime()) {
            int z = this.getZoom();
            Rectangle viewportBounds = this.getViewportBounds();
            this.drawMapTiles(g, z, viewportBounds);
            this.drawOverlays(z, g, viewportBounds);
        }
        super.paintBorder(g);
    }

    @Override
    public void setDesignTime(boolean b) {
        this.designTime = b;
    }

    @Override
    public boolean isDesignTime() {
        return this.designTime;
    }

    protected void drawMapTiles(Graphics g, int zoom, Rectangle viewportBounds) {
        int size = this.getTileFactory().getTileSize(zoom);
        Dimension mapSize = this.getTileFactory().getMapSize(zoom);
        int numWide = viewportBounds.width / size + 2;
        int numHigh = viewportBounds.height / size + 2;
        TileFactoryInfo info = this.getTileFactory().getInfo();
        int tpx = (int)Math.floor(viewportBounds.getX() / (double)info.getTileSize(0));
        int tpy = (int)Math.floor(viewportBounds.getY() / (double)info.getTileSize(0));
        for (int x = 0; x <= numWide; ++x) {
            for (int y = 0; y <= numHigh; ++y) {
                int itpx = x + tpx;
                int itpy = y + tpy;
                if (!g.getClipBounds().intersects(new Rectangle(itpx * size - viewportBounds.x, itpy * size - viewportBounds.y, size, size))) continue;
                Tile tile = this.getTileFactory().getTile(itpx, itpy, zoom);
                int ox = itpx * this.getTileFactory().getTileSize(zoom) - viewportBounds.x;
                int oy = itpy * this.getTileFactory().getTileSize(zoom) - viewportBounds.y;
                if (!this.isTileOnMap(itpx, itpy, mapSize)) {
                    if (this.isOpaque()) {
                        g.setColor(this.getBackground());
                        g.fillRect(ox, oy, size, size);
                    }
                } else if (tile.isLoaded()) {
                    g.drawImage(tile.getImage(), ox, oy, null);
                } else {
                    Tile superTile = null;
                    if (zoom < info.getMaximumZoomLevel()) {
                        superTile = this.getTileFactory().getTile(itpx / 2, itpy / 2, zoom + 1);
                    }
                    if (superTile != null && superTile.isLoaded()) {
                        int offX = itpx % 2 * size / 2;
                        int offY = itpy % 2 * size / 2;
                        g.drawImage(superTile.getImage(), ox, oy, ox + size, oy + size, offX, offY, offX + size / 2, offY + size / 2, null);
                    } else {
                        int imageX = (this.getTileFactory().getTileSize(zoom) - this.getLoadingImage().getWidth(null)) / 2;
                        int imageY = (this.getTileFactory().getTileSize(zoom) - this.getLoadingImage().getHeight(null)) / 2;
                        g.setColor(Color.GRAY);
                        g.fillRect(ox, oy, size, size);
                        g.drawImage(this.getLoadingImage(), ox + imageX, oy + imageY, null);
                    }
                }
                if (!this.isDrawTileBorders()) continue;
                g.setColor(Color.black);
                g.drawRect(ox, oy, size, size);
                g.drawRect(ox + size / 2 - 5, oy + size / 2 - 5, 10, 10);
                g.setColor(Color.white);
                g.drawRect(ox + 1, oy + 1, size, size);
                String text = itpx + ", " + itpy + ", " + this.getZoom();
                g.setColor(Color.BLACK);
                g.drawString(text, ox + 10, oy + 30);
                g.drawString(text, ox + 10 + 2, oy + 30 + 2);
                g.setColor(Color.WHITE);
                g.drawString(text, ox + 10 + 1, oy + 30 + 1);
            }
        }
    }

    private void drawOverlays(int zoom, Graphics g, Rectangle viewportBounds) {
        if (this.overlay != null) {
            this.overlay.paint((Graphics2D)g, this, this.getWidth(), this.getHeight());
        }
    }

    private boolean isTileOnMap(int x, int y, Dimension mapSize) {
        return y >= 0 && (double)y < mapSize.getHeight() && (this.isInfiniteMapRendering() || x >= 0 && (double)x < mapSize.getWidth());
    }

    public void setOverlayPainter(Painter<? super JXMapViewer> overlay) {
        AbstractPainter ap;
        Painter<? super JXMapViewer> old = this.getOverlayPainter();
        this.overlay = overlay;
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue().equals(Boolean.TRUE)) {
                    JXMapViewer.this.repaint();
                }
            }
        };
        if (old instanceof AbstractPainter) {
            ap = (AbstractPainter)old;
            ap.removePropertyChangeListener("dirty", listener);
        }
        if (overlay instanceof AbstractPainter) {
            ap = (AbstractPainter)overlay;
            ap.addPropertyChangeListener("dirty", listener);
        }
        this.firePropertyChange("mapOverlay", old, this.getOverlayPainter());
        this.repaint();
    }

    public Painter<? super JXMapViewer> getOverlayPainter() {
        return this.overlay;
    }

    public Rectangle getViewportBounds() {
        return this.calculateViewportBounds(this.getCenter());
    }

    private Rectangle calculateViewportBounds(Point2D centr) {
        Insets insets = this.getInsets();
        int viewportWidth = this.getWidth() - insets.left - insets.right;
        int viewportHeight = this.getHeight() - insets.top - insets.bottom;
        double viewportX = centr.getX() - (double)(viewportWidth / 2);
        double viewportY = centr.getY() - (double)(viewportHeight / 2);
        return new Rectangle((int)viewportX, (int)viewportY, viewportWidth, viewportHeight);
    }

    public void setZoom(int zoom) {
        if (zoom == this.zoomLevel) {
            return;
        }
        TileFactoryInfo info = this.getTileFactory().getInfo();
        if (info != null && (zoom < info.getMinimumZoomLevel() || zoom > info.getMaximumZoomLevel())) {
            return;
        }
        int oldzoom = this.zoomLevel;
        Point2D oldCenter = this.getCenter();
        Dimension oldMapSize = this.getTileFactory().getMapSize(oldzoom);
        this.zoomLevel = zoom;
        this.firePropertyChange("zoom", oldzoom, zoom);
        Dimension mapSize = this.getTileFactory().getMapSize(zoom);
        this.setCenter(new Point2D.Double(oldCenter.getX() * (mapSize.getWidth() / oldMapSize.getWidth()), oldCenter.getY() * (mapSize.getHeight() / oldMapSize.getHeight())));
        this.repaint();
    }

    public int getZoom() {
        return this.zoomLevel;
    }

    public GeoPosition getAddressLocation() {
        return this.addressLocation;
    }

    public void setAddressLocation(GeoPosition addressLocation) {
        GeoPosition old = this.getAddressLocation();
        this.addressLocation = addressLocation;
        this.setCenter(this.getTileFactory().geoToPixel(addressLocation, this.getZoom()));
        this.firePropertyChange("addressLocation", old, this.getAddressLocation());
        this.repaint();
    }

    public void recenterToAddressLocation() {
        this.setCenter(this.getTileFactory().geoToPixel(this.getAddressLocation(), this.getZoom()));
        this.repaint();
    }

    public boolean isDrawTileBorders() {
        return this.drawTileBorders;
    }

    public void setDrawTileBorders(boolean drawTileBorders) {
        boolean old = this.isDrawTileBorders();
        this.drawTileBorders = drawTileBorders;
        this.firePropertyChange("drawTileBorders", old, this.isDrawTileBorders());
        this.repaint();
    }

    public void setCenterPosition(GeoPosition geoPosition) {
        GeoPosition oldVal = this.getCenterPosition();
        this.setCenter(this.getTileFactory().geoToPixel(geoPosition, this.zoomLevel));
        this.repaint();
        GeoPosition newVal = this.getCenterPosition();
        this.firePropertyChange("centerPosition", oldVal, newVal);
    }

    public GeoPosition getCenterPosition() {
        return this.getTileFactory().pixelToGeo(this.getCenter(), this.zoomLevel);
    }

    public TileFactory getTileFactory() {
        return this.factory;
    }

    public void setTileFactory(TileFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory must not be null");
        }
        this.factory.removeTileListener(this.tileLoadListener);
        this.factory.dispose();
        this.factory = factory;
        this.setZoom(factory.getInfo().getDefaultZoomLevel());
        factory.addTileListener(this.tileLoadListener);
        this.repaint();
    }

    public Image getLoadingImage() {
        return this.loadingImage;
    }

    public void setLoadingImage(Image loadingImage) {
        this.loadingImage = loadingImage;
    }

    public Point2D getCenter() {
        return this.center;
    }

    public void setCenter(Point2D center) {
        Point2D old = this.getCenter();
        double centerX = center.getX();
        double centerY = center.getY();
        Dimension mapSize = this.getTileFactory().getMapSize(this.getZoom());
        int mapHeight = (int)mapSize.getHeight() * this.getTileFactory().getTileSize(this.getZoom());
        int mapWidth = (int)mapSize.getWidth() * this.getTileFactory().getTileSize(this.getZoom());
        if (this.isRestrictOutsidePanning()) {
            Insets insets = this.getInsets();
            int viewportHeight = this.getHeight() - insets.top - insets.bottom;
            int viewportWidth = this.getWidth() - insets.left - insets.right;
            Rectangle newVP = this.calculateViewportBounds(center);
            if (newVP.getY() < 0.0) {
                centerY = viewportHeight / 2;
            }
            if (!this.isHorizontalWrapped() && newVP.getX() < 0.0) {
                centerX = viewportWidth / 2;
            }
            if (newVP.getY() + newVP.getHeight() > (double)mapHeight) {
                centerY = mapHeight - viewportHeight / 2;
            }
            if (!this.isHorizontalWrapped() && newVP.getX() + newVP.getWidth() > (double)mapWidth) {
                centerX = mapWidth - viewportWidth / 2;
            }
            if ((double)mapHeight < newVP.getHeight()) {
                centerY = mapHeight / 2;
            }
            if (!this.isHorizontalWrapped() && (double)mapWidth < newVP.getWidth()) {
                centerX = mapWidth / 2;
            }
        }
        centerX %= (double)mapWidth;
        centerY %= (double)mapHeight;
        if (centerX < 0.0) {
            centerX += (double)mapWidth;
        }
        if (centerY < 0.0) {
            centerY += (double)mapHeight;
        }
        GeoPosition oldGP = this.getCenterPosition();
        this.center = new Point2D.Double(centerX, centerY);
        this.firePropertyChange("center", old, this.center);
        this.firePropertyChange("centerPosition", oldGP, this.getCenterPosition());
        this.repaint();
    }

    public void calculateZoomFrom(Set<GeoPosition> positions) {
        if (positions.size() < 2) {
            return;
        }
        int zoom = this.getZoom();
        Rectangle2D rect = this.generateBoundingRect(positions, zoom);
        int count = 0;
        while (!this.getViewportBounds().contains(rect)) {
            Point2D.Double centr = new Point2D.Double(rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0);
            GeoPosition px = this.getTileFactory().pixelToGeo(centr, zoom);
            this.setCenterPosition(px);
            if (++count > 30 || this.getViewportBounds().contains(rect) || ++zoom > 15) break;
            this.setZoom(zoom);
            rect = this.generateBoundingRect(positions, zoom);
        }
    }

    public void zoomToBestFit(Set<GeoPosition> positions, double maxFraction) {
        if (positions.isEmpty()) {
            return;
        }
        if (maxFraction <= 0.0 || maxFraction > 1.0) {
            throw new IllegalArgumentException("maxFraction must be between 0 and 1");
        }
        TileFactory tileFactory = this.getTileFactory();
        TileFactoryInfo info = tileFactory.getInfo();
        if (info == null) {
            return;
        }
        GeoPosition centre = this.computeGeoCenter(positions);
        this.setCenterPosition(centre);
        if (positions.size() == 1) {
            return;
        }
        int bestZoom = info.getMaximumZoomLevel();
        Rectangle viewport = this.getViewportBounds();
        Rectangle2D bounds = this.generateBoundingRect(positions, bestZoom);
        while (bestZoom >= info.getMinimumZoomLevel() && bounds.getWidth() < ((RectangularShape)viewport).getWidth() * maxFraction && bounds.getHeight() < ((RectangularShape)viewport).getHeight() * maxFraction) {
            bounds = this.generateBoundingRect(positions, --bestZoom);
        }
        this.setZoom(bestZoom + 1);
    }

    private Rectangle2D generateBoundingRect(Set<GeoPosition> positions, int zoom) {
        Point2D point1 = this.getTileFactory().geoToPixel(positions.iterator().next(), zoom);
        Rectangle2D.Double rect = new Rectangle2D.Double(point1.getX(), point1.getY(), 0.0, 0.0);
        for (GeoPosition pos : positions) {
            Point2D point = this.getTileFactory().geoToPixel(pos, zoom);
            rect.add(point);
        }
        return rect;
    }

    private GeoPosition computeGeoCenter(Set<GeoPosition> positions) {
        double sumLat = 0.0;
        double sumLon = 0.0;
        for (GeoPosition pos : positions) {
            sumLat += pos.getLatitude();
            sumLon += pos.getLongitude();
        }
        double avgLat = sumLat / (double)positions.size();
        double avgLon = sumLon / (double)positions.size();
        return new GeoPosition(avgLat, avgLon);
    }

    public boolean isRestrictOutsidePanning() {
        return this.restrictOutsidePanning;
    }

    public void setRestrictOutsidePanning(boolean restrictOutsidePanning) {
        this.restrictOutsidePanning = restrictOutsidePanning;
    }

    public boolean isHorizontalWrapped() {
        return this.horizontalWrapped;
    }

    public void setInfiniteMapRendering(boolean infiniteMapRendering) {
        this.infiniteMapRendering = infiniteMapRendering;
    }

    public boolean isInfiniteMapRendering() {
        return this.horizontalWrapped || this.infiniteMapRendering;
    }

    public void setHorizontalWrapped(boolean horizontalWrapped) {
        this.horizontalWrapped = horizontalWrapped;
    }

    public Point2D convertGeoPositionToPoint(GeoPosition pos) {
        Point2D pt = this.getTileFactory().geoToPixel(pos, this.getZoom());
        Rectangle bounds = this.getViewportBounds();
        return new Point2D.Double(pt.getX() - bounds.getX(), pt.getY() - bounds.getY());
    }

    public GeoPosition convertPointToGeoPosition(Point2D pt) {
        Rectangle bounds = this.getViewportBounds();
        Point2D.Double pt2 = new Point2D.Double(pt.getX() + bounds.getX(), pt.getY() + bounds.getY());
        GeoPosition pos = this.getTileFactory().pixelToGeo(pt2, this.getZoom());
        return pos;
    }

    @Deprecated
    public boolean isNegativeYAllowed() {
        return true;
    }

    public void setPanEnabled(boolean enabled) {
        this.panningEnabled = enabled;
    }

    public boolean isPanningEnabled() {
        return this.panningEnabled;
    }
}

