/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.iban;

import fr.marcwrobel.jbanking.IsoCountry;
import fr.marcwrobel.jbanking.iban.BbanStructure;
import fr.marcwrobel.jbanking.iban.IbanCheckDigit;
import fr.marcwrobel.jbanking.iban.IbanFormatException;
import java.util.regex.Pattern;

public final class Iban {
    private static final String BASIC_REGEX = "[A-Za-z]{2}[0-9]{2}[A-Za-z0-9]+";
    private static final Pattern BASIC_PATTERN = Pattern.compile("[A-Za-z]{2}[0-9]{2}[A-Za-z0-9]+");
    private static final int COUNTRY_CODE_INDEX = 0;
    private static final int COUNTRY_CODE_LENGTH = 2;
    private static final int CHECK_DIGITS_INDEX = 2;
    private static final int CHECK_DIGITS_LENGTH = 2;
    private static final int BBAN_INDEX = 4;
    private static final int GROUP_SIZE_FOR_PRINTABLE_IBAN = 4;
    private final String iban;

    public Iban(IsoCountry country, String bban) {
        if (country == null) {
            throw new IllegalArgumentException("the country argument cannot be null");
        }
        if (bban == null) {
            throw new IllegalArgumentException("the bban argument cannot be null");
        }
        String normalizedBban = Iban.normalize(bban);
        String normalizedIban = country.getCode() + "00" + normalizedBban;
        BbanStructure bbanStructure = BbanStructure.forCountry(country);
        if (bbanStructure == null) {
            throw IbanFormatException.forNotSupportedCountry(bban, country);
        }
        if (!bbanStructure.isBbanValid(normalizedBban)) {
            throw IbanFormatException.forInvalidBbanStructure(bban, bbanStructure);
        }
        String checkDigits = IbanCheckDigit.INSTANCE.calculate(normalizedIban);
        this.iban = country.getCode() + checkDigits + normalizedBban;
    }

    public Iban(String iban) {
        if (iban == null) {
            throw new IllegalArgumentException("the iban argument cannot be null");
        }
        String normalizedIban = Iban.normalize(iban);
        if (!Iban.isWellFormatted(normalizedIban)) {
            throw IbanFormatException.forNotProperlyFormattedInput(normalizedIban);
        }
        IsoCountry country = Iban.findCountryFor(normalizedIban);
        if (country == null) {
            throw IbanFormatException.forUnknownCountry(iban);
        }
        BbanStructure bbanStructure = BbanStructure.forCountry(country);
        if (bbanStructure == null) {
            throw IbanFormatException.forNotSupportedCountry(iban, country);
        }
        if (!bbanStructure.isBbanValid(normalizedIban.substring(4))) {
            throw IbanFormatException.forInvalidBbanStructure(iban, bbanStructure);
        }
        if (!IbanCheckDigit.INSTANCE.validate(normalizedIban)) {
            throw IbanFormatException.forIncorrectCheckDigits(iban);
        }
        this.iban = normalizedIban;
    }

    public static boolean isValid(String iban) {
        if (iban == null) {
            return false;
        }
        String normalizedIban = Iban.normalize(iban);
        if (!Iban.isWellFormatted(normalizedIban)) {
            return false;
        }
        IsoCountry country = Iban.findCountryFor(normalizedIban);
        if (country == null) {
            return false;
        }
        BbanStructure bbanStructure = BbanStructure.forCountry(country);
        if (bbanStructure == null) {
            return false;
        }
        if (!bbanStructure.isBbanValid(normalizedIban.substring(4))) {
            return false;
        }
        return IbanCheckDigit.INSTANCE.validate(normalizedIban);
    }

    private static String normalize(String iban) {
        return iban.replaceAll("\\s+", "").toUpperCase();
    }

    private static boolean isWellFormatted(String s) {
        return BASIC_PATTERN.matcher(s).matches();
    }

    private static IsoCountry findCountryFor(String s) {
        return IsoCountry.fromCode(s.substring(0, 2));
    }

    public String getCountryCode() {
        return this.iban.substring(0, 2);
    }

    public String getCheckDigit() {
        return this.iban.substring(2, 4);
    }

    public String getBban() {
        return this.iban.substring(4);
    }

    public String toPrintableString() {
        StringBuilder printableIban = new StringBuilder(this.iban);
        int length = this.iban.length();
        for (int i = 0; i < length / 4; ++i) {
            printableIban.insert((i + 1) * 4 + i, ' ');
        }
        return printableIban.toString();
    }

    public String toString() {
        return this.iban;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Iban other = (Iban)o;
        return this.iban.equals(other.iban);
    }

    public int hashCode() {
        return 29 * this.iban.hashCode();
    }
}

