/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.PluginsCollector;
import org.java.plugin.standard.StandardPluginLocation;
import org.java.plugin.util.ExtendedProperties;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginsCollector
implements PluginsCollector {
    protected static final String PARAM_PLUGINS_REPOSITORIES = "org.java.plugin.boot.pluginsRepositories";
    protected static final String PARAM_PLUGINS_LOCATIONS_DESCRIPTORS = "org.java.plugin.boot.pluginsLocationsDescriptors";
    protected Log log = LogFactory.getLog(this.getClass());
    private List<File> repositories;
    private List<URL> descriptors;

    @Override
    public void configure(ExtendedProperties config) throws Exception {
        String token;
        this.repositories = new LinkedList<File>();
        StringTokenizer st = new StringTokenizer(config.getProperty(PARAM_PLUGINS_REPOSITORIES, '.' + File.separator + "plugins"), ",", false);
        while (st.hasMoreTokens()) {
            token = st.nextToken().trim();
            if (token.length() == 0) continue;
            this.repositories.add(new File(token).getCanonicalFile());
        }
        this.log.debug((Object)("found " + this.repositories.size() + " local plug-ins repositories"));
        this.descriptors = new LinkedList<URL>();
        st = new StringTokenizer(config.getProperty(PARAM_PLUGINS_LOCATIONS_DESCRIPTORS, ""), ",", false);
        while (st.hasMoreTokens()) {
            token = st.nextToken().trim();
            if (token.length() == 0) continue;
            this.descriptors.add(new URL(token));
        }
        this.log.debug((Object)("found " + this.descriptors.size() + " plug-ins locations descriptors"));
    }

    @Override
    public Collection<PluginManager.PluginLocation> collectPluginLocations() {
        LinkedList<PluginManager.PluginLocation> result = new LinkedList<PluginManager.PluginLocation>();
        for (File file : this.repositories) {
            if (file.isDirectory()) {
                this.processFolder(file, result);
                continue;
            }
            if (file.isFile()) {
                this.processFile(file, result);
                continue;
            }
            this.log.warn((Object)("unknown repository location " + file));
        }
        for (URL url : this.descriptors) {
            this.processDescriptor(url, result);
        }
        return result;
    }

    protected void processFolder(File folder, List<PluginManager.PluginLocation> result) {
        this.log.debug((Object)("processing folder - " + folder));
        try {
            PluginManager.PluginLocation pluginLocation = StandardPluginLocation.create((File)folder);
            if (pluginLocation != null) {
                result.add(pluginLocation);
                return;
            }
        }
        catch (MalformedURLException mue) {
            this.log.warn((Object)("failed collecting plug-in folder " + folder + ", ignoring it"), (Throwable)mue);
            return;
        }
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                this.processFolder(file, result);
                continue;
            }
            if (!file.isFile()) continue;
            this.processFile(file, result);
        }
    }

    protected void processFile(File file, List<PluginManager.PluginLocation> result) {
        this.log.debug((Object)("processing file - " + file));
        try {
            PluginManager.PluginLocation pluginLocation = StandardPluginLocation.create((File)file);
            if (pluginLocation != null) {
                result.add(pluginLocation);
            }
        }
        catch (MalformedURLException mue) {
            this.log.warn((Object)("failed collecting plug-in file " + file + ", ignoring it"), (Throwable)mue);
        }
    }

    private void processDescriptor(URL url, List<PluginManager.PluginLocation> result) {
        this.log.debug((Object)("processing plug-ins locations descriptor, URL=" + url));
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(url.toExternalForm(), (DefaultHandler)new LocationsDescriptorHandler(result));
        }
        catch (Exception e) {
            this.log.warn((Object)("failed processing plug-ins locations descriptor, URL=" + url), (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LocationsDescriptorHandler
    extends DefaultHandler {
        private final List<PluginManager.PluginLocation> resultData;

        LocationsDescriptorHandler(List<PluginManager.PluginLocation> result) {
            this.resultData = result;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            URL contextUrl;
            URL manifestUrl;
            if (!"plugin".equals(qName)) {
                return;
            }
            String manifest = attributes.getValue("manifest");
            if (manifest == null) {
                DefaultPluginsCollector.this.log.warn((Object)"manifest attribute missing");
                return;
            }
            try {
                manifestUrl = new URL(manifest);
            }
            catch (MalformedURLException mue) {
                DefaultPluginsCollector.this.log.warn((Object)("invalid manifest URL - " + manifest), (Throwable)mue);
                return;
            }
            String context = attributes.getValue("context");
            if (context == null) {
                DefaultPluginsCollector.this.log.warn((Object)"context attribute missing");
                return;
            }
            try {
                contextUrl = new URL(context);
            }
            catch (MalformedURLException mue) {
                DefaultPluginsCollector.this.log.warn((Object)("invalid context URL - " + context), (Throwable)mue);
                return;
            }
            this.resultData.add((PluginManager.PluginLocation)new StandardPluginLocation(contextUrl, manifestUrl));
            DefaultPluginsCollector.this.log.debug((Object)("got plug-in location from descriptor, manifestUrl=" + manifestUrl + ", contextURL=" + contextUrl));
        }
    }
}

