/*
 * Decompiled with CFR 0.152.
 */
package bizcal.demo;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.common.DayViewConfig;
import bizcal.common.Event;
import bizcal.swing.DayView;
import bizcal.swing.PopupMenuCallback;
import bizcal.util.DateInterval;
import bizcal.util.DateUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BizcalDemo {
    private static final Logger LOGGER = LoggerFactory.getLogger(BizcalDemo.class);
    private static int DAYS_TO_SHOW = 7;

    public static void main(String[] stringArray) throws Exception {
        DayViewConfig dayViewConfig = new DayViewConfig();
        DayView dayView = new DayView(dayViewConfig);
        BizcalDemo.addPopupMenuCallback(dayView);
        MyEventModel myEventModel = new MyEventModel();
        dayView.setModel(myEventModel);
        dayView.setActiveCalendars(myEventModel.getSelectedCalendars());
        JFrame jFrame = new JFrame("Bizcal Demo");
        dayView.refresh();
        jFrame.setLayout(new BorderLayout());
        jFrame.add((Component)BizcalDemo.createButtonPanel(dayView), "First");
        jFrame.add((Component)dayView.getComponent(), "Center");
        jFrame.setSize(800, 600);
        jFrame.setVisible(true);
    }

    private static JPanel createButtonPanel(final DayView dayView) {
        final MyEventModel myEventModel = (MyEventModel)dayView.getModel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JButton jButton = new JButton("Previous week");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Date date = myEventModel.interval.getStartDate();
                Date date2 = DateUtil.getDiffDay(date, -DAYS_TO_SHOW);
                myEventModel.interval.setStartDate(date2);
                myEventModel.interval.setEndDate(date);
                try {
                    dayView.refresh();
                }
                catch (Exception exception) {
                    LOGGER.error("Can't select previous week.");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        });
        jPanel.add((Component)jButton, "Before");
        JButton jButton2 = new JButton("Next week");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Date date = myEventModel.interval.getEndDate();
                Date date2 = DateUtil.getDiffDay(date, DAYS_TO_SHOW);
                myEventModel.interval.setStartDate(date);
                myEventModel.interval.setEndDate(date2);
                try {
                    dayView.refresh();
                }
                catch (Exception exception) {
                    LOGGER.error("Can't select next week.");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        });
        jPanel.add((Component)jButton2, "After");
        return jPanel;
    }

    private static void addPopupMenuCallback(DayView dayView) {
        dayView.setPopupMenuCallback(new PopupMenuCallback.BaseImpl(){

            @Override
            public JPopupMenu getEventPopupMenu(Object object, Event event) throws Exception {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem("Schnitzel");
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        LOGGER.debug(actionEvent.paramString());
                    }
                });
                JMenuItem jMenuItem2 = new JMenuItem("Invitatio ad offerendum");
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        LOGGER.debug(actionEvent.paramString());
                    }
                });
                jPopupMenu.add(jMenuItem);
                jPopupMenu.add(jMenuItem2);
                return jPopupMenu;
            }
        });
    }

    private static class MyEventModel
    extends CalendarModel.BaseImpl {
        private List<Event> events = new ArrayList<Event>();
        private DateInterval interval;
        private Calendar cal;

        public MyEventModel() throws Exception {
            Comparable comparable;
            Date date = DateUtil.round2Week(new Date());
            date = new Date(date.getTime() + 28800000L);
            for (int i = 0; i < 10; ++i) {
                comparable = new Event();
                ((Event)comparable).setStart(date);
                ((Event)comparable).setEnd(new Date(date.getTime() + 5400000L));
                ((Event)comparable).setSummary("Summary " + i);
                ((Event)comparable).setDescription("Description " + i);
                ((Event)comparable).setToolTip("Tooltip " + i);
                this.events.add((Event)comparable);
                if (i % 2 == 0) {
                    this.events.add(((Event)comparable).copy());
                }
                date = DateUtil.getDiffDay(date, 1);
                date = new Date(date.getTime() + 3600000L);
            }
            Date date2 = DateUtil.round2Week(new Date());
            comparable = DateUtil.getDiffDay(date2, 7);
            this.interval = new DateInterval(date2, (Date)comparable);
            this.cal = new Calendar();
            this.cal.setId(1);
            this.cal.setSummary("Peter");
        }

        @Override
        public List<Event> getEvents(Object object) throws Exception {
            return this.events;
        }

        @Override
        public List getSelectedCalendars() throws Exception {
            return Collections.nCopies(1, this.cal);
        }

        @Override
        public DateInterval getInterval() {
            return this.interval;
        }
    }
}

