/*
 * Decompiled with CFR 0.152.
 */
package bizcal.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimeOfDay
implements Comparable {
    private long _time;

    public TimeOfDay(long l) {
        this._time = l;
    }

    public TimeOfDay(int n, int n2) {
        this._time = n * 3600 * 1000 + n2 * 60 * 1000;
    }

    public TimeOfDay(Date date) {
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        calendar.setTimeZone(TimeZone.getDefault());
        calendar.setTime(date);
        this._time = calendar.get(11) * 60;
        this._time += (long)calendar.get(12);
        this._time *= 60000L;
    }

    public String toString() {
        return "" + this._time;
    }

    public long getValue() {
        return this._time;
    }

    public int getHour() {
        return this.getCalendar().get(11);
    }

    public int getMinute() {
        return this.getCalendar().get(12);
    }

    private Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.setTime(new Date(this._time));
        return calendar;
    }

    public Date getDate(Date date) {
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        calendar.setTimeZone(TimeZone.getDefault());
        calendar.setTime(date);
        calendar.set(11, this.getHour());
        calendar.set(12, this.getMinute());
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        TimeOfDay timeOfDay = (TimeOfDay)object;
        return (int)(this._time - timeOfDay.getValue());
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        int n = 17;
        n = (int)((long)(37 * n) + this.getValue());
        return n;
    }
}

