/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.views;

import bizcal.common.DayViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarListener;
import bizcal.swing.CalendarView;
import bizcal.swing.util.GradientArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.JToggleButton;
import lu.tudor.santec.bizcal.AbstractCalendarView;
import lu.tudor.santec.bizcal.CalendarIcons;
import lu.tudor.santec.bizcal.EventModel;
import lu.tudor.santec.bizcal.NamedCalendar;
import lu.tudor.santec.bizcal.print.PrintUtilities;
import lu.tudor.santec.bizcal.views.list.ListView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ListViewPanel
extends AbstractCalendarView {
    private static final I18n I18N = I18nFactory.getI18n(ListViewPanel.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ListViewPanel.class);
    private DateFormat df = new SimpleDateFormat("dd.MM.yyyy", Locale.getDefault());
    private static final long serialVersionUID = 1L;
    private JToggleButton button;
    private EventModel eventModel;
    public static final String VIEW_NAME = "LIST_VIEW";
    public ListView listView;
    Color primaryColor = new Color(230, 230, 230);
    Color secondaryColor = Color.WHITE;
    private GradientArea gp;

    public ListViewPanel(EventModel eventModel) {
        this.eventModel = eventModel;
        this.button = new JToggleButton(CalendarIcons.getMediumIcon("cal_list.png"));
        this.button.setToolTipText(I18N.tr("list view"));
        this.setLayout(new BorderLayout());
        this.gp = new GradientArea("TOP_BOTTOM", this.secondaryColor, this.primaryColor);
        this.gp.setPreferredSize(new Dimension(30, 30));
        this.add((Component)this.gp, "North");
        try {
            this.listView = new ListView(new DayViewConfig(), this);
            this.listView.setModel(this.eventModel);
            this.eventModel.addCalendarView(this.listView);
            this.listView.refresh();
            this.listView.refresh0();
            this.add((Component)this.listView.getComponent(), "Center");
        }
        catch (Exception exception) {
            LOGGER.warn("listView creation failed", (Throwable)exception);
        }
    }

    @Override
    public JToggleButton getButton() {
        return this.button;
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    @Override
    public void dateChanged(Date date) {
        this.eventModel.setDate(date);
        this.listView.setDate(date);
        try {
            this.eventModel.refresh();
        }
        catch (Exception exception) {
            LOGGER.warn("updating listView failed", (Throwable)exception);
        }
    }

    public void setTitle(Date date, Date date2) {
        try {
            this.gp.setText("<html><center>" + I18N.tr("list view") + "<br>" + this.df.format(date) + " - " + this.df.format(date2), true);
        }
        catch (Exception exception) {
            LOGGER.warn("setTitle failed", (Throwable)exception);
        }
    }

    @Override
    public void activeCalendarsChanged(Collection<NamedCalendar> collection) {
    }

    @Override
    public void selectedCalendarChanged(NamedCalendar namedCalendar) {
    }

    public void addCalendarListener(CalendarListener calendarListener) {
        this.listView.addListener(calendarListener);
    }

    public void setShowDays(int n) {
        this.listView.setShowDays(n);
    }

    @Override
    public List<Event> getEvents() {
        try {
            return this.listView.getEvents();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void print(boolean bl) {
        PrintUtilities.printComponent(this, bl, false);
    }

    @Override
    public CalendarView getView() {
        return this.listView;
    }
}

