/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.views.list;

import bizcal.common.Event;
import bizcal.util.DateUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import lu.tudor.santec.bizcal.views.list.ListModel;

public class ListRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private ListModel model;
    private Border newDayBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK);
    private Border border;

    public ListRenderer(ListModel listModel) {
        this.model = listModel;
        this.setFont(new Font("Arial", 0, 12));
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Event event = this.model.getEvent(n);
        Color color = Color.WHITE;
        try {
            color = event.getColor();
            color = new Date().before(event.getEnd()) ? new Color(color.getRed(), color.getGreen(), color.getBlue(), 120) : new Color(color.getRed(), color.getGreen(), color.getBlue(), 20);
            this.border = !DateUtil.isSameDay(event.getStart(), this.model.getEvent(n - 1).getStart()) ? this.newDayBorder : null;
        }
        catch (Exception exception) {
            this.border = null;
        }
        switch (n2) {
            case 0: {
                this.setVerticalAlignment(1);
                this.setHorizontalAlignment(2);
                this.setText((String)object);
                this.setIcon(null);
                break;
            }
            case 1: {
                this.setVerticalAlignment(0);
                this.setHorizontalAlignment(0);
                this.setText(null);
                this.setIcon((ImageIcon)object);
                break;
            }
            default: {
                this.setVerticalAlignment(1);
                this.setHorizontalAlignment(2);
                this.setText((String)object);
                this.setIcon(null);
                if (jTable.getRowHeight(n) >= this.getPreferredSize().height) break;
                jTable.setRowHeight(n, this.getPreferredSize().height + 4);
            }
        }
        if (bl) {
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setBackground(color);
        }
        this.setBorder(this.border);
        return this;
    }
}

