/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.java.plugin.util.ResourceManager;

public class ErrorDialog
extends JDialog {
    private static final long serialVersionUID = 7142861251076530780L;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JLabel messageLabel = null;
    private JLabel errorLabel = null;
    private JPanel jPanel1 = null;
    private JButton closeButton = null;
    private JScrollPane jScrollPane = null;
    JTextArea jTextArea = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanelInfo = null;
    private JScrollPane jScrollPane2 = null;
    private JList jList = null;
    private JLabel dataLabel = null;
    boolean yesBtnPressed = false;
    private JButton yesButton = null;

    public static void showError(Component parentComponent, String title, String message) {
        ErrorDialog.showError(parentComponent, title, message, null, null);
    }

    public static void showError(Component parentComponent, String title, String message, Object data) {
        ErrorDialog.showError(parentComponent, title, message, data, null);
    }

    public static void showError(Component parentComponent, String title, Object data, Throwable error) {
        String message = error.getMessage();
        if (message == null || message.trim().length() == 0) {
            message = error.toString();
        }
        ErrorDialog.showError(parentComponent, title, message, data, error);
    }

    public static void showError(Component parentComponent, String title, Throwable error) {
        String message = error.getMessage();
        if (message == null || message.trim().length() == 0) {
            message = error.toString();
        }
        ErrorDialog.showError(parentComponent, title, message, error);
    }

    public static void showError(Component parentComponent, String title, String message, Throwable error) {
        ErrorDialog.showError(parentComponent, title, message, null, error);
    }

    public static void showError(Component parentComponent, String title, String message, Object data, Throwable error) {
        Frame frame = parentComponent != null ? JOptionPane.getFrameForComponent(parentComponent) : JOptionPane.getRootFrame();
        new ErrorDialog(frame, title, message, data, error, false).setVisible(true);
    }

    public static boolean showWarning(Component parentComponent, String title, String message) {
        return ErrorDialog.showWarning(parentComponent, title, message, null, null);
    }

    public static boolean showWarning(Component parentComponent, String title, String message, Object data) {
        return ErrorDialog.showWarning(parentComponent, title, message, data, null);
    }

    public static boolean showWarning(Component parentComponent, String title, String message, Throwable error) {
        return ErrorDialog.showWarning(parentComponent, title, message, null, error);
    }

    public static boolean showWarning(Component parentComponent, String title, String message, Object data, Throwable error) {
        Frame frame = parentComponent != null ? JOptionPane.getFrameForComponent(parentComponent) : JOptionPane.getRootFrame();
        ErrorDialog dialog = new ErrorDialog(frame, title, message, data, error, true);
        dialog.setVisible(true);
        return dialog.yesBtnPressed;
    }

    public static String getErrorDetails(Throwable t) {
        StringBuilder sb = new StringBuilder();
        String nl = System.getProperty("line.separator");
        sb.append(new Date()).append(nl);
        if (t != null) {
            sb.append(nl).append("-----------------------------------------------").append(nl);
            sb.append("Exception details.").append(nl).append(nl);
            sb.append("Class: ").append(t.getClass().getName()).append(nl);
            sb.append("Message: ").append(t.getMessage()).append(nl);
            ErrorDialog.printError(t, "Stack trace:", sb);
        }
        sb.append(nl).append("-----------------------------------------------").append(nl);
        sb.append("System properties:").append(nl).append(nl);
        for (Map.Entry<Object, Object> entry : new TreeMap<Object, Object>(System.getProperties()).entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(nl);
        }
        sb.append(nl).append("-----------------------------------------------").append(nl);
        sb.append("Runtime info:").append(nl).append(nl);
        Runtime rt = Runtime.getRuntime();
        sb.append("Memory TOTAL / FREE / MAX: ").append(rt.totalMemory()).append(" / ").append(rt.freeMemory()).append(" / ").append(rt.maxMemory()).append(nl);
        sb.append("Available processors: ").append(rt.availableProcessors()).append(nl);
        sb.append("System class loader: ").append("" + ClassLoader.getSystemClassLoader()).append(nl);
        sb.append("Thread context class loader: ").append("" + Thread.currentThread().getContextClassLoader()).append(nl);
        sb.append("Security manager: ").append("" + System.getSecurityManager()).append(nl);
        return sb.toString();
    }

    public static void printError(Throwable t, String header, StringBuilder sb) {
        if (t == null) {
            return;
        }
        String nl = System.getProperty("line.separator");
        sb.append(nl).append(header).append(nl).append(nl);
        StackTraceElement[] stackTrace = t.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            sb.append(stackTrace[i].toString()).append(nl);
        }
        Throwable next = t.getCause();
        ErrorDialog.printError(next, "Caused by " + next, sb);
        if (t instanceof SQLException) {
            next = ((SQLException)t).getNextException();
            ErrorDialog.printError(next, "Next exception: " + next, sb);
        } else if (t instanceof InvocationTargetException) {
            next = ((InvocationTargetException)t).getTargetException();
            ErrorDialog.printError(next, "Target exception: " + next, sb);
        }
    }

    private ErrorDialog(Frame owner, String title, String message, Object data, Throwable t, boolean yesNo) {
        super(owner != null ? owner : JOptionPane.getRootFrame());
        this.initialize();
        this.setLocationRelativeTo(this.getOwner());
        this.jTabbedPane.setTitleAt(0, ResourceManager.getMessage((String)"org.java.plugin.boot", (String)"infoTabLabel"));
        this.jTabbedPane.setTitleAt(1, ResourceManager.getMessage((String)"org.java.plugin.boot", (String)"detailsTabLabel"));
        this.setTitle(title);
        this.messageLabel.setText(message);
        if (t != null) {
            this.errorLabel.setText(ResourceManager.getMessage((String)"org.java.plugin.boot", (String)"errorLabel", (Object)t));
        } else {
            this.getJPanel().remove(this.errorLabel);
        }
        if (data instanceof Collection) {
            DefaultListModel model = new DefaultListModel();
            for (Object object : (Collection)data) {
                model.addElement(object);
            }
            this.jList.setModel(model);
            this.getJPanel().remove(this.dataLabel);
        } else if (data instanceof Object[]) {
            DefaultListModel<Object> model = new DefaultListModel<Object>();
            for (Object object : (Object[])data) {
                model.addElement(object);
            }
            this.jList.setModel(model);
            this.getJPanel().remove(this.dataLabel);
        } else if (data != null) {
            this.dataLabel.setText(data.toString());
            this.getJPanelInfo().remove(this.getJScrollPane());
        } else {
            this.getJPanel().remove(this.dataLabel);
            this.getJPanelInfo().remove(this.getJScrollPane());
        }
        this.jTextArea.setText(ErrorDialog.getErrorDetails(t));
        this.jTextArea.setCaretPosition(0);
        if (yesNo) {
            this.closeButton.setText(ResourceManager.getMessage((String)"org.java.plugin.boot", (String)"noLabel"));
            this.yesButton.setText(ResourceManager.getMessage((String)"org.java.plugin.boot", (String)"yesLabel"));
        } else {
            this.getJPanel1().remove(this.yesButton);
            this.closeButton.setText(ResourceManager.getMessage((String)"org.java.plugin.boot", (String)"closeLabel"));
        }
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setTitle("An error has occurred");
        this.setSize(460, 280);
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setWindowDecorationStyle(4);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "doCloseDefault");
        this.getRootPane().getActionMap().put("doCloseDefault", new AbstractAction(){
            private static final long serialVersionUID = -9167454634726502084L;

            public void actionPerformed(ActionEvent evt) {
                ErrorDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(this.getCloseButton());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            BorderLayout borderLayout2 = new BorderLayout();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(borderLayout2);
            borderLayout2.setVgap(2);
            this.jContentPane.add((Component)this.getJPanel1(), "South");
            this.jContentPane.add((Component)this.getJTabbedPane(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.dataLabel = new JLabel();
            this.dataLabel.setText("JLabel");
            this.errorLabel = new JLabel();
            this.messageLabel = new JLabel();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BoxLayout(this.getJPanel(), 1));
            this.messageLabel.setText("JLabel");
            this.errorLabel.setText("JLabel");
            this.jPanel.add((Component)this.messageLabel, null);
            this.jPanel.add((Component)this.errorLabel, null);
            this.jPanel.add((Component)this.dataLabel, null);
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(flowLayout);
            this.jPanel1.add((Component)this.getYesButton(), null);
            this.jPanel1.add((Component)this.getCloseButton(), null);
        }
        return this.jPanel1;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.setSelected(true);
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ErrorDialog.this.dispose();
                }
            });
        }
        return this.closeButton;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJList());
        }
        return this.jScrollPane;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setBackground(SystemColor.control);
            this.jTextArea.setEditable(false);
            this.jTextArea.setOpaque(false);
            this.jTextArea.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent evt) {
                    if (!evt.isPopupTrigger()) {
                        return;
                    }
                    this.copyText();
                }

                public void mouseReleased(MouseEvent evt) {
                    if (!evt.isPopupTrigger()) {
                        return;
                    }
                    this.copyText();
                }

                private void copyText() {
                    if (ErrorDialog.this.jTextArea.getSelectedText() != null) {
                        ErrorDialog.this.jTextArea.copy();
                        return;
                    }
                    ErrorDialog.this.jTextArea.setSelectionStart(0);
                    ErrorDialog.this.jTextArea.setSelectionEnd(ErrorDialog.this.jTextArea.getText().length());
                    ErrorDialog.this.jTextArea.copy();
                    ErrorDialog.this.jTextArea.setSelectionEnd(0);
                }
            });
        }
        return this.jTextArea;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("Info", null, this.getJPanelInfo(), null);
            this.jTabbedPane.addTab("Details", null, this.getJScrollPane2(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel getJPanelInfo() {
        if (this.jPanelInfo == null) {
            this.jPanelInfo = new JPanel();
            this.jPanelInfo.setLayout(new BorderLayout());
            this.jPanelInfo.add((Component)this.getJPanel(), "North");
            this.jPanelInfo.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jPanelInfo;
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setViewportView(this.getJTextArea());
        }
        return this.jScrollPane2;
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList();
        }
        return this.jList;
    }

    private JButton getYesButton() {
        if (this.yesButton == null) {
            this.yesButton = new JButton();
            this.yesButton.setText("Yes");
            this.yesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ErrorDialog.this.yesBtnPressed = true;
                    ErrorDialog.this.dispose();
                }
            });
        }
        return this.yesButton;
    }
}

