/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.core;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.openestate.io.core.CsvRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CsvParser<Record extends CsvRecord>
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvParser.class);
    private final CSVParser parser;
    private Iterator<CSVRecord> iterator = null;

    protected CsvParser(CSVParser cSVParser) {
        this.parser = cSVParser;
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }

    public final long getCurrentLineNumber() {
        return this.parser.getCurrentLineNumber();
    }

    public final long getRecordNumber() {
        return this.parser.getRecordNumber();
    }

    public final boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.parser.iterator();
        }
        return this.iterator.hasNext();
    }

    public final boolean isClosed() {
        return this.parser.isClosed();
    }

    protected abstract Record newRecord(CSVRecord var1);

    public final Record next() {
        if (this.iterator == null) {
            this.iterator = this.parser.iterator();
        }
        return this.newRecord(this.iterator.next());
    }
}

