/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomValueImpl
extends AbstractImplItem
implements SerializableXmlType {
    private static final long serialVersionUID = 4402143376190858718L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomValueImpl.class);
    public static final int UNDEFINED = -1;
    public static final int BOOLEAN = 0;
    public static final int DATE = 1;
    public static final int DATETIME = 2;
    public static final int DECIMAL = 3;
    public static final int INTEGER = 4;
    public static final int STRING = 5;
    public static final int TEXT = 6;
    public static final int TIME = 7;
    public static final int URL = 8;
    public static final String XML_ATTRIB_KEY = "Key";
    public static final String XML_ELEMENT_BOOLEAN = "Boolean";
    public static final String XML_ELEMENT_DATE = "Date";
    public static final String XML_ELEMENT_DATETIME = "DateTime";
    public static final String XML_ELEMENT_DECIMAL = "Decimal";
    public static final String XML_ELEMENT_INTEGER = "Integer";
    public static final String XML_ELEMENT_STRING = "String";
    public static final String XML_ELEMENT_TEXT = "Text";
    public static final String XML_ELEMENT_TIME = "Time";
    public static final String XML_ELEMENT_URL = "URL";
    private int valueType = -1;
    private Object valueObject = null;

    public CustomValueImpl() {
    }

    public CustomValueImpl(int n) {
        this.valueType = n;
        this.valueObject = null;
    }

    public CustomValueImpl(String string, Object object, int n) {
        this.build(string, object, n);
    }

    private void build(String string, Object object, int n) {
        this.setObject(object, n);
        this.setObjectKey(string);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="NULL is an expected return value.")
    public Boolean getBoolean() {
        return this.isBoolean() ? (Boolean)this.getObject() : null;
    }

    public Date getDate() {
        return this.isDate() ? (Date)this.getObject() : null;
    }

    public Date getDateTime() {
        return this.isDateTime() ? (Date)this.getObject() : null;
    }

    public BigDecimal getDecimal() {
        return this.isDecimal() ? (BigDecimal)this.getObject() : null;
    }

    public BigInteger getInteger() {
        return this.isInteger() ? (BigInteger)this.getObject() : null;
    }

    public Object getObject() {
        return this.valueObject;
    }

    public String getObjectKey() {
        return (String)this.getValue(XML_ATTRIB_KEY, "");
    }

    public int getObjectType() {
        return this.valueType;
    }

    public String getString() {
        return this.isString() ? (String)this.getObject() : null;
    }

    public String getText() {
        return this.isText() ? (String)this.getObject() : null;
    }

    public Date getTime() {
        return this.isTime() ? (Date)this.getObject() : null;
    }

    public URI getUrl() {
        return this.isUrl() ? (URI)this.getObject() : null;
    }

    public boolean isBoolean() {
        return this.getObjectType() == 0;
    }

    public boolean isDate() {
        return this.getObjectType() == 1;
    }

    public boolean isDateTime() {
        return this.getObjectType() == 2;
    }

    public boolean isDecimal() {
        return this.getObjectType() == 3;
    }

    public boolean isInteger() {
        return this.getObjectType() == 4;
    }

    public boolean isString() {
        return this.getObjectType() == 5;
    }

    public boolean isText() {
        return this.getObjectType() == 6;
    }

    public boolean isTime() {
        return this.getObjectType() == 7;
    }

    public boolean isUrl() {
        return this.getObjectType() == 8;
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        block14: {
            this.setObjectKey(CustomValueImpl.selectAttribute(element, XML_ATTRIB_KEY, ""));
            List<Node> list = CustomValueImpl.selectChildElements(element);
            if (list.isEmpty()) {
                this.valueObject = null;
                this.valueType = -1;
            } else {
                try {
                    Node node = list.get(0);
                    if (XML_ELEMENT_BOOLEAN.equals(node.getName())) {
                        this.setObject(Boolean.valueOf(node.getStringValue()), 0);
                        break block14;
                    }
                    if (XML_ELEMENT_DATE.equals(node.getName())) {
                        this.setObject(OpenEstateUtils.getXsdDateFormat().parse(node.getStringValue()), 1);
                        break block14;
                    }
                    if (XML_ELEMENT_DATETIME.equals(node.getName())) {
                        this.setObject(OpenEstateUtils.getXsdDateTimeFormat().parse(node.getStringValue()), 2);
                        break block14;
                    }
                    if (XML_ELEMENT_DECIMAL.equals(node.getName())) {
                        this.setObject(new BigDecimal(node.getStringValue()), 3);
                        break block14;
                    }
                    if (XML_ELEMENT_INTEGER.equals(node.getName())) {
                        this.setObject(BigInteger.valueOf(Long.parseLong(node.getStringValue())), 4);
                        break block14;
                    }
                    if (XML_ELEMENT_STRING.equals(node.getName())) {
                        this.setObject(OpenEstateUtils.parseString(node.getStringValue()), 5);
                        break block14;
                    }
                    if (XML_ELEMENT_TEXT.equals(node.getName())) {
                        this.setObject(OpenEstateUtils.parseString(node.getStringValue()), 6);
                        break block14;
                    }
                    if (XML_ELEMENT_TIME.equals(node.getName())) {
                        this.setObject(OpenEstateUtils.getXsdTimeFormat().parse(node.getStringValue()), 7);
                        break block14;
                    }
                    if (XML_ELEMENT_URL.equals(node.getName())) {
                        String string = StringUtils.trimToNull((String)node.getStringValue());
                        if (string != null) {
                            this.setObject(new URI(string), 8);
                        }
                        break block14;
                    }
                    throw new Exception("unknown value-type: " + node.getName());
                }
                catch (Exception exception) {
                    throw new DocumentException("could not convert custom-value: " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        element.addAttribute(XML_ATTRIB_KEY, this.getObjectKey());
        if (this.isBoolean()) {
            element.addElement(XML_ELEMENT_BOOLEAN).setText(this.getBoolean().toString());
        } else if (this.isDate()) {
            element.addElement(XML_ELEMENT_DATE).setText(OpenEstateUtils.getXsdDateFormat().format(this.getDate()));
        } else if (this.isDateTime()) {
            element.addElement(XML_ELEMENT_DATETIME).setText(OpenEstateUtils.getXsdDateTimeFormat().format(this.getDateTime()));
        } else if (this.isDecimal()) {
            element.addElement(XML_ELEMENT_DECIMAL).setText(this.getDecimal().toPlainString());
        } else if (this.isInteger()) {
            element.addElement(XML_ELEMENT_INTEGER).setText(this.getInteger().toString());
        } else if (this.isString()) {
            element.addElement(XML_ELEMENT_STRING).setText(OpenEstateUtils.serializeString(StringEscapeUtils.unescapeHtml4((String)this.getString())));
        } else if (this.isText()) {
            element.addElement(XML_ELEMENT_TEXT).setText(OpenEstateUtils.serializeString(StringEscapeUtils.unescapeHtml4((String)this.getText())));
        } else if (this.isTime()) {
            element.addElement(XML_ELEMENT_TIME).setText(OpenEstateUtils.getXsdTimeFormat().format(this.getTime()));
        } else if (this.isUrl()) {
            element.addElement(XML_ELEMENT_URL).setText(this.getUrl().toString());
        }
    }

    public void setObject(Object object, int n) {
        if (object == null) {
            this.valueObject = null;
            this.valueType = -1;
        } else if (object instanceof Boolean && n == 0) {
            this.valueObject = object;
            this.valueType = n;
        } else if (object instanceof Date && n == 1) {
            this.valueObject = object;
            this.valueType = n;
        } else if (object instanceof Date && n == 2) {
            this.valueObject = object;
            this.valueType = n;
        } else if (object instanceof BigDecimal && n == 3) {
            this.valueObject = object;
            this.valueType = n;
        } else if (object instanceof Double && n == 3) {
            this.valueObject = BigDecimal.valueOf((Double)object);
            this.valueType = n;
        } else if (object instanceof BigInteger && n == 4) {
            this.valueObject = object;
            this.valueType = n;
        } else if (object instanceof Long && n == 4) {
            this.valueObject = BigInteger.valueOf((Long)object);
            this.valueType = n;
        } else if (object instanceof String && n == 5) {
            this.valueObject = object;
            this.valueType = n;
        } else if (object instanceof String && n == 6) {
            this.valueObject = object;
            this.valueType = n;
        } else if (object instanceof Date && n == 7) {
            this.valueObject = object;
            this.valueType = n;
        } else if (object instanceof URI && n == 8) {
            this.valueObject = object;
            this.valueType = n;
        } else if (object instanceof String && n == 8) {
            try {
                String string = StringUtils.trimToNull((String)((String)object));
                if (string != null) {
                    this.valueObject = new URI((String)object);
                    this.valueType = n;
                }
                this.valueObject = null;
                this.valueType = -1;
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("invalid url provided!");
            }
        } else {
            throw new IllegalArgumentException("invalid object provided, type=" + n + ", class=" + object.getClass().getName());
        }
    }

    public void setObjectKey(String string) {
        this.putValue(XML_ATTRIB_KEY, string);
    }
}

