/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EstateLinkProvider {
    GALLERY_PANOCREATOR_COM("gallery@panocreator.com", "https://panocreator.com/view/gallery/id/{ID}/", "panocreator\\.com/view/[\\w/]+/id/(\\w+)/?.*"),
    GALLERY_ROUND_ME("gallery@round.me", "https://round.me/tour/{ID}/", "round\\.me/tour/(\\d+)/?.*", "roundme\\.com/tour/(\\d+)/?.*"),
    VIDEO_D_TUBE("video@d.tube", "https://d.tube/v/{ID}", "d\\.tube/v/(\\w+/\\w+)/?", "d\\.tube/#!/v/(\\w+/\\w+)/?"),
    VIDEO_DAILYMOTION_COM("video@dailymotion.com", "https://www.dailymotion.com/video/{ID}", "dailymotion\\.com/?.*/video/([a-zA-Z0-9]+)_?.*"),
    VIDEO_VEOH_COM("video@veoh.com", "http://www.veoh.com/watch/{ID}/", "veoh\\.com/watch/(\\w+)/?"),
    VIDEO_VIMEO_COM("video@vimeo.com", "https://vimeo.com/{ID}/", "vimeo\\.com/(\\d+)/?"),
    VIDEO_YOUTUBE_COM("video@youtube.com", "https://www.youtube.com/watch?v={ID}", "youtube\\.com/watch\\?.*v=([\\w\\-]+)&?.*", "youtu\\.be/([\\w\\-]+)/?.*");

    private static final Logger LOGGER;
    private final String xmlName;
    private final String linkTemplate;
    private final Pattern[] urlPatterns;

    private EstateLinkProvider(String string2, String string3, String ... stringArray) {
        this.xmlName = string2;
        this.linkTemplate = string3;
        this.urlPatterns = new Pattern[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.urlPatterns[i] = Pattern.compile(stringArray[i]);
        }
    }

    public String getEmbedHtml(String string, String string2, int n, int n2) {
        return EstateLinkProvider.getEmbedHtml(this, string, string2, n, n2);
    }

    public static String getEmbedHtml(EstateLinkProvider estateLinkProvider, String string, String string2, int n, int n2) {
        URI uRI = estateLinkProvider.getUrlFromLinkId(string);
        if (uRI == null) {
            return null;
        }
        switch (estateLinkProvider) {
            case GALLERY_PANOCREATOR_COM: {
                n2 = n2 > 0 ? n2 : 500;
                return "<div class=\"gallery_panocreator_com\" style=\"width:100%; margin-bottom:0.5em; margin-top:0.5em;\">" + System.lineSeparator() + "<div class=\"gallery_container\" style=\"width:100%; height:" + n2 + "px;\"><iframe src=\"https://panocreator.com/view/gallery/id/" + StringEscapeUtils.escapeXml11((String)string) + "\" width=\"100%\" height=\"" + n2 + "\" align=\"left\" marginheight=\"0\" marginwidth=\"0\" frameborder=\"0\" scrolling=\"no\"></iframe></div>" + System.lineSeparator() + "<div class=\"gallery_provider\" style=\"text-align:right;\"><a href=\"" + StringEscapeUtils.escapeXml11((String)uRI.toString()) + "\" target=\"_blank\">" + StringEscapeUtils.escapeXml11((String)string2) + "</a> @ <a href=\"http://www.panocreator.com/\" target=\"_blank\">panocreator.com</a></div>" + System.lineSeparator() + "</div>";
            }
            case GALLERY_ROUND_ME: {
                n2 = n2 > 0 ? n2 : 500;
                return "<div class=\"gallery_round_me\" style=\"width:100%; margin-bottom:0.5em; margin-top:0.5em;\">" + System.lineSeparator() + "<div class=\"gallery_container\" style=\"width:100%; height:" + n2 + "px;\"><iframe src=\"https://roundme.com/tour/" + StringEscapeUtils.escapeXml11((String)string) + "\" width=\"100%\" height=\"" + n2 + "\" align=\"left\" marginheight=\"0\" marginwidth=\"0\" frameborder=\"0\" scrolling=\"no\"></iframe></div>" + System.lineSeparator() + "<div class=\"gallery_provider\" style=\"text-align:right;\"><a href=\"" + StringEscapeUtils.escapeXml11((String)uRI.toString()) + "\" target=\"_blank\">" + StringEscapeUtils.escapeXml11((String)string2) + "</a> @ <a href=\"https://roundme.com/\" target=\"_blank\">round.me</a></div>" + System.lineSeparator() + "</div>";
            }
            case VIDEO_D_TUBE: {
                n = n > 0 ? n : 560;
                n2 = n2 > 0 ? n2 : 315;
                return "<div class=\"video_d_tube\" style=\"width:" + n + "px; margin-bottom:0.5em; margin-top:0.5em;\">" + System.lineSeparator() + "<div class=\"video_container\" style=\"width:" + n + "px; height:" + n2 + "px;\"><iframe src=\"https://emb.d.tube/#!/" + StringEscapeUtils.escapeXml11((String)string) + "\" width=\"" + n + "\" height=\"" + n2 + "\" align=\"left\" marginheight=\"0\" marginwidth=\"0\" frameborder=\"0\" scrolling=\"no\"  allowfullscreen></iframe></div>" + System.lineSeparator() + "<div class=\"video_provider\" style=\"text-align:right;\"><a href=\"" + StringEscapeUtils.escapeXml11((String)uRI.toString()) + "\" target=\"_blank\">" + StringEscapeUtils.escapeXml11((String)string2) + "</a> @ <a href=\"https://d.tube/\" target=\"_blank\">d.tube</a></div>" + System.lineSeparator() + "</div>";
            }
            case VIDEO_DAILYMOTION_COM: {
                n = n > 0 ? n : 480;
                n2 = n2 > 0 ? n2 : 270;
                return "<div class=\"video_dailymotion_com\" style=\"width:" + n + "px; margin-bottom:0.5em; margin-top:0.5em;\">" + System.lineSeparator() + "<div class=\"video_container\" style=\"width:" + n + "px; height:" + n2 + "px;\"><iframe src=\"http://www.dailymotion.com/embed/video/" + StringEscapeUtils.escapeXml11((String)string) + "\" width=\"" + n + "\" height=\"" + n2 + "\" align=\"left\" marginheight=\"0\" marginwidth=\"0\" frameborder=\"0\" scrolling=\"no\"  allowfullscreen></iframe></div>" + System.lineSeparator() + "<div class=\"video_provider\" style=\"text-align:right;\"><a href=\"" + StringEscapeUtils.escapeXml11((String)uRI.toString()) + "\" target=\"_blank\">" + StringEscapeUtils.escapeXml11((String)string2) + "</a> @ <a href=\"http://www.dailymotion.com/\" target=\"_blank\">dailymotion.com</a></div>" + System.lineSeparator() + "</div>";
            }
            case VIDEO_VEOH_COM: {
                n = n > 0 ? n : 410;
                n2 = n2 > 0 ? n2 : 341;
                return "<div class=\"video_veoh_com\" style=\"width:" + n + "px; margin-bottom:0.5em; margin-top:0.5em;\">" + System.lineSeparator() + "<div class=\"video_container\" style=\"width:" + n + "px; height:" + n2 + "px;\"><object id=\"veohFlashPlayer\" width=\"" + n + "\" height=\"" + n2 + "\"><param name=\"allowFullscreen\" value=\"true\" /><param name=\"allowScriptAccess\" value=\"always\" /><param name=\"movie\" value=\"http://www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1343&amp;permalinkId=" + StringEscapeUtils.escapeXml11((String)string) + "&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous\" /><embed src=\"http://www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1343&amp;permalinkId=" + StringEscapeUtils.escapeXml11((String)string) + "&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous\" type=\"application/x-shockwave-flash\" allowscriptaccess=\"always\" allowfullscreen=\"true\" width=\"" + n + "\" height=\"" + n2 + "\" id=\"veohFlashPlayerEmbed\" name=\"veohFlashPlayerEmbed\"/></object></div>" + System.lineSeparator() + "<div class=\"video_provider\" style=\"text-align:right;\"><a href=\"" + StringEscapeUtils.escapeXml11((String)uRI.toString()) + "\" target=\"_blank\">" + StringEscapeUtils.escapeXml11((String)string2) + "</a> @ <a href=\"http://www.veoh.com/\" target=\"_blank\">veoh.com</a></div>" + System.lineSeparator() + "</div>";
            }
            case VIDEO_VIMEO_COM: {
                n = n > 0 ? n : 560;
                n2 = n2 > 0 ? n2 : 315;
                return "<div class=\"video_vimeo_com\" style=\"width:" + n + "px; margin-bottom:0.5em; margin-top:0.5em;\">" + System.lineSeparator() + "<div class=\"video_container\" style=\"width:" + n + "px; height:" + n2 + "px;\"><iframe src=\"http://player.vimeo.com/video/" + StringEscapeUtils.escapeXml11((String)string) + "?title=0&amp;byline=0&amp;portrait=0\" width=\"" + n + "\" height=\"" + n2 + "\" align=\"left\" marginheight=\"0\" marginwidth=\"0\" frameborder=\"0\" scrolling=\"no\"  webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe></div>" + System.lineSeparator() + "<div class=\"video_provider\" style=\"text-align:right;\"><a href=\"" + StringEscapeUtils.escapeXml11((String)uRI.toString()) + "\" target=\"_blank\">" + StringEscapeUtils.escapeXml11((String)string2) + "</a> @ <a href=\"http://vimeo.com/\" target=\"_blank\">vimeo.com</a></div>" + System.lineSeparator() + "</div>";
            }
            case VIDEO_YOUTUBE_COM: {
                n = n > 0 ? n : 560;
                n2 = n2 > 0 ? n2 : 315;
                return "<div class=\"video_youtube_com\" style=\"width:" + n + "px; margin-bottom:0.5em; margin-top:0.5em;\">" + System.lineSeparator() + "<div class=\"video_container\" style=\"width:" + n + "px; height:" + n2 + "px;\"><iframe src=\"https://www.youtube.com/embed/" + StringEscapeUtils.escapeXml11((String)string) + "?rel=0\" width=\"" + n + "\" height=\"" + n2 + "\" allowfullscreen=\"allowfullscreen\" align=\"left\" marginheight=\"0\" marginwidth=\"0\" frameborder=\"0\" scrolling=\"no\"  allowfullscreen></iframe></div>" + System.lineSeparator() + "<div class=\"video_provider\" style=\"text-align:right;\"><a href=\"" + StringEscapeUtils.escapeXml11((String)uRI.toString()) + "\" target=\"_blank\">" + StringEscapeUtils.escapeXml11((String)string2) + "</a> @ <a href=\"http://www.youtube.com/\" target=\"_blank\">youtube.com</a></div>" + System.lineSeparator() + "</div>";
            }
        }
        return null;
    }

    public String getLinkIdFromUrl(String string) {
        for (Pattern pattern : this.urlPatterns) {
            Matcher matcher = pattern.matcher(string);
            try {
                if (!matcher.find()) continue;
                return matcher.group(1);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read link ID from URL!");
                LOGGER.warn("> for: " + this.getXmlName());
                LOGGER.warn("> url: " + string);
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                return null;
            }
        }
        return null;
    }

    public URI getUrlFromLinkId(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        String string2 = this.linkTemplate.replace("{ID}", string);
        try {
            return new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warn("Can't read URL from link ID!");
            LOGGER.warn("> for: " + this.getXmlName());
            LOGGER.warn("> url: " + string2);
            return null;
        }
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public boolean isGallery() {
        return this.getXmlName().toLowerCase().startsWith("gallery@");
    }

    public boolean isVideo() {
        return this.getXmlName().toLowerCase().startsWith("video@");
    }

    static {
        LOGGER = LoggerFactory.getLogger(EstateLinkProvider.class);
    }
}

