/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.SerializableXmlType;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchEqualsImpl
extends AbstractImplItem
implements SerializableXmlType {
    private static final long serialVersionUID = 6674868583750721709L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchEqualsImpl.class);
    private static final String XML_ATTRIB_VALUE = "Value";
    private static final String XML_ATTRIB_LIKE = "Like";
    private static final String XML_ATTRIB_CASESENSITIVE = "CaseSensitive";
    private boolean caseSensitive = true;
    private boolean like = false;
    private String value;
    private long order = 0L;

    public SearchEqualsImpl() {
        this(null);
    }

    public SearchEqualsImpl(String string) {
        this.value = string;
    }

    public long getOrder() {
        return this.order;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isLike() {
        return this.like;
    }

    public boolean isMatching(String string) {
        if (StringUtils.isBlank((CharSequence)this.value)) {
            return true;
        }
        String string2 = StringUtils.trimToEmpty((String)this.value);
        String string3 = StringUtils.trimToEmpty((String)string);
        if (!this.isCaseSensitive()) {
            string2 = string2.toLowerCase();
            string3 = string3.toLowerCase();
        }
        if (this.isLike()) {
            string2 = StringUtils.replace((String)string2, (String)"*", (String)"%");
            StringBuilder stringBuilder = new StringBuilder();
            if (string2.startsWith("%")) {
                stringBuilder.append(".*");
            }
            String[] stringArray = StringUtils.split((String)string2, (String)"%");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(".*");
                }
                stringBuilder.append(Pattern.quote(stringArray[i]));
            }
            if (string2.endsWith("%")) {
                stringBuilder.append(".*");
            }
            return string3.matches(stringBuilder.toString());
        }
        return string3.equals(string2);
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        this.setCaseSensitive(SearchEqualsImpl.selectAttributeAsBoolean(element, XML_ATTRIB_CASESENSITIVE, true));
        this.setLike(SearchEqualsImpl.selectAttributeAsBoolean(element, XML_ATTRIB_LIKE, false));
        this.setValue(SearchEqualsImpl.selectAttribute(element, XML_ATTRIB_VALUE, null));
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        element.addAttribute(XML_ATTRIB_CASESENSITIVE, Boolean.toString(this.isCaseSensitive()));
        element.addAttribute(XML_ATTRIB_LIKE, Boolean.toString(this.isLike()));
        if (this.value != null) {
            element.addAttribute(XML_ATTRIB_VALUE, this.value);
        }
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public void setLike(boolean bl) {
        this.like = bl;
    }

    public void setOrder(long l) {
        this.order = l;
    }

    public void setValue(String string) {
        this.value = string;
    }
}

