/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs.prices;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.attribs.ComplexCurrencyAttrib;
import com.openindex.openestate.impl.values.CurrencyValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import java.util.Locale;

public final class DepositAmount
extends ComplexCurrencyAttrib {
    public DepositAmount() {
        super(OpenEstateAttrib.PRICES_DEPOSIT_AMOUNT, null);
    }

    public DepositAmount(CurrencyValue currencyValue) {
        this();
        this.setValue(currencyValue);
    }

    public DepositAmount(Number number, Currency currency) {
        this();
        if (number != null) {
            this.setValue(CurrencyValue.parse(number, currency));
        }
    }

    public static CurrencyValue get(EstateImpl estateImpl) {
        return DepositAmount.get(estateImpl, OpenEstateAttrib.PRICES_DEPOSIT_AMOUNT);
    }

    public static BigDecimal getAsBigDecimal(EstateImpl estateImpl) {
        return DepositAmount.getAsBigDecimal(estateImpl, OpenEstateAttrib.PRICES_DEPOSIT_AMOUNT);
    }

    public static BigInteger getAsBigInteger(EstateImpl estateImpl) {
        return DepositAmount.getAsBigInteger(estateImpl, OpenEstateAttrib.PRICES_DEPOSIT_AMOUNT);
    }

    public static Double getAsDouble(EstateImpl estateImpl) {
        return DepositAmount.getAsDouble(estateImpl, OpenEstateAttrib.PRICES_DEPOSIT_AMOUNT);
    }

    public static Float getAsFloat(EstateImpl estateImpl) {
        return DepositAmount.getAsFloat(estateImpl, OpenEstateAttrib.PRICES_DEPOSIT_AMOUNT);
    }

    public static Integer getAsInteger(EstateImpl estateImpl) {
        return DepositAmount.getAsInteger(estateImpl, OpenEstateAttrib.PRICES_DEPOSIT_AMOUNT);
    }

    public static Long getAsLong(EstateImpl estateImpl) {
        return DepositAmount.getAsLong(estateImpl, OpenEstateAttrib.PRICES_DEPOSIT_AMOUNT);
    }

    public static String getAsString(EstateImpl estateImpl) {
        return DepositAmount.getAsString(estateImpl, OpenEstateAttrib.PRICES_DEPOSIT_AMOUNT);
    }

    public static String getAsString(EstateImpl estateImpl, Locale locale) {
        return DepositAmount.getAsString(estateImpl, OpenEstateAttrib.PRICES_DEPOSIT_AMOUNT, locale);
    }

    public static void put(EstateImpl estateImpl, String string) {
        DepositAmount.put(estateImpl, OpenEstateAttrib.PRICES_DEPOSIT_AMOUNT, string);
    }

    public static void put(EstateImpl estateImpl, Number number) {
        DepositAmount.put(estateImpl, OpenEstateAttrib.PRICES_DEPOSIT_AMOUNT, number);
    }

    public static void put(EstateImpl estateImpl, CurrencyValue currencyValue) {
        DepositAmount.put(estateImpl, OpenEstateAttrib.PRICES_DEPOSIT_AMOUNT, currencyValue);
    }
}

