/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db;

import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.db.DbGeoHandler;
import com.openindex.openestate.impl.db.DbHandlerImpl;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.DbObjectsHandler;
import com.openindex.openestate.impl.db.DbSearch;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbObjectsHandlerImpl
extends DbHandlerImpl
implements DbObjectsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbObjectsHandlerImpl.class);

    protected DbObjectsHandlerImpl() {
        super(null);
    }

    protected DbObjectsHandlerImpl(String string) {
        super(string);
    }

    protected DbObject createObject() {
        return new DbObject();
    }

    @Override
    public final int getNumberOfFiles(Connection connection, long l) throws SQLException {
        return this.getNumberOfFiles(connection, l, null, null);
    }

    @Override
    public final int getNumberOfFiles(Connection connection, long l, Boolean bl) throws SQLException {
        return this.getNumberOfFiles(connection, l, bl, null);
    }

    @Override
    public abstract int getNumberOfFiles(Connection var1, long var2, Boolean var4, String var5) throws SQLException;

    @Override
    public final DbObject getObject(Connection connection, long l) throws SQLException {
        DbObject[] dbObjectArray = this.getObjects(connection, new long[]{l});
        return dbObjectArray != null && dbObjectArray.length > 0 ? dbObjectArray[0] : null;
    }

    @Override
    public final DbObject getObject(Connection connection, String string) throws SQLException {
        DbObject[] dbObjectArray = this.getObjects(connection, new String[]{string});
        return dbObjectArray != null && dbObjectArray.length > 0 ? dbObjectArray[0] : null;
    }

    @Override
    public final DbObject[] getObjects(Connection connection) throws SQLException {
        return this.getObjects(connection, (long[])null);
    }

    @Override
    public abstract DbObject[] getObjects(Connection var1, long[] var2) throws SQLException;

    @Override
    public abstract DbObject[] getObjects(Connection var1, String[] var2) throws SQLException;

    @Override
    public DbObject[] getObjects(Connection connection, DbSearch dbSearch) throws SQLException {
        long[] lArray = this.getObjectIds(connection, dbSearch);
        return lArray != null && lArray.length > 0 ? this.getObjects(connection, lArray) : new DbObject[]{};
    }

    @Override
    public final DbObject[] getObjectsByKeyword(Connection connection, String string) throws SQLException {
        return this.getObjectsByKeyword(connection, string, 0);
    }

    @Override
    public abstract DbObject[] getObjectsByKeyword(Connection var1, String var2, int var3) throws SQLException;

    @Override
    public abstract OpenEstateAction[] getObjectActions(Connection var1) throws SQLException;

    @Override
    public abstract long getObjectId(Connection var1, String var2) throws SQLException;

    @Override
    public final long[] getObjectIds(Connection connection) throws SQLException {
        return this.getObjectIds(connection, (long[])null);
    }

    @Override
    public final long[] getObjectIds(Connection connection, long l) throws SQLException {
        if (l < 1L) {
            return this.getObjectIds(connection, (long[])null);
        }
        return this.getObjectIds(connection, new long[]{l});
    }

    @Override
    public abstract long[] getObjectIds(Connection var1, long[] var2) throws SQLException;

    @Override
    public abstract long[] getObjectIds(Connection var1, DbSearch var2) throws SQLException;

    @Override
    public abstract OpenEstateType[] getObjectTypes(Connection var1) throws SQLException;

    @Override
    public final void loadObjectAttribs(Connection connection, DbObject dbObject, DbLanguagesHandler dbLanguagesHandler) throws SQLException {
        if (dbObject != null) {
            this.loadObjectAttribs(connection, new DbObject[]{dbObject}, dbLanguagesHandler);
        }
    }

    @Override
    public final void loadObjectAttribs(Connection connection, DbObject dbObject, Map<Long, String> map) throws SQLException {
        if (dbObject != null) {
            this.loadObjectAttribs(connection, new DbObject[]{dbObject}, map);
        }
    }

    @Override
    public final void loadObjectAttribs(Connection connection, DbObject[] dbObjectArray, DbLanguagesHandler dbLanguagesHandler) throws SQLException {
        this.loadObjectAttribs(connection, dbObjectArray, dbLanguagesHandler.getLanguageMap(connection, true));
    }

    @Override
    public abstract void loadObjectAttribs(Connection var1, DbObject[] var2, Map<Long, String> var3) throws SQLException;

    @Override
    public final void loadObjectGeoDbAreas(Connection connection, DbObject dbObject, DbGeoHandler dbGeoHandler) throws SQLException {
        if (dbObject != null) {
            this.loadObjectGeoDbAreas(connection, new DbObject[]{dbObject}, dbGeoHandler);
        }
    }

    @Override
    public abstract void loadObjectGeoDbAreas(Connection var1, DbObject[] var2, DbGeoHandler var3) throws SQLException;

    @Override
    public final void loadObjectTranslations(Connection connection, DbObject dbObject, DbLanguagesHandler dbLanguagesHandler) throws SQLException {
        if (dbObject != null) {
            this.loadObjectTranslations(connection, new DbObject[]{dbObject}, dbLanguagesHandler.getLanguageMap(connection, true));
        }
    }

    @Override
    public final void loadObjectTranslations(Connection connection, DbObject dbObject, Map<Long, String> map) throws SQLException {
        if (dbObject != null) {
            this.loadObjectTranslations(connection, new DbObject[]{dbObject}, map);
        }
    }

    @Override
    public final void loadObjectTranslations(Connection connection, DbObject[] dbObjectArray, DbLanguagesHandler dbLanguagesHandler) throws SQLException {
        this.loadObjectTranslations(connection, dbObjectArray, dbLanguagesHandler.getLanguageMap(connection, true));
    }

    @Override
    public abstract void loadObjectTranslations(Connection var1, DbObject[] var2, Map<Long, String> var3) throws SQLException;

    @Override
    public final void removeObject(Connection connection, long l) throws SQLException {
        this.removeObjects(connection, new long[]{l});
    }

    @Override
    public abstract void removeObjects(Connection var1, long[] var2) throws SQLException;

    @Override
    public final void saveObject(Connection connection, DbObject dbObject) throws SQLException {
        this.saveObject(connection, dbObject, (DbLanguagesHandler)null, false, false);
    }

    @Override
    public final void saveObject(Connection connection, DbObject dbObject, DbLanguagesHandler dbLanguagesHandler, boolean bl, boolean bl2) throws SQLException {
        if (bl || bl2) {
            this.saveObject(connection, dbObject, dbLanguagesHandler.getLanguageMap(connection, true), bl, bl2);
        } else {
            this.saveObject(connection, dbObject, (Map<Long, String>)null, false, false);
        }
    }

    @Override
    public abstract void saveObject(Connection var1, DbObject var2, Map<Long, String> var3, boolean var4, boolean var5) throws SQLException;

    @Override
    public final void setObjectContactId(Connection connection, long l, long l2) throws SQLException {
        this.setObjectContactId(connection, new long[]{l}, l2);
    }

    @Override
    public abstract void setObjectContactId(Connection var1, long[] var2, long var3) throws SQLException;
}

