/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.utils.AbstractConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class CSVReader
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVReader.class);

    public static BigDecimal getBigDecimal(int n, String[] stringArray) {
        return CSVReader.getBigDecimal(n, stringArray, null);
    }

    public static BigDecimal getBigDecimal(int n, String[] stringArray, BigDecimal bigDecimal) {
        try {
            if (n < 0 || stringArray.length <= n) {
                return bigDecimal;
            }
            String string = stringArray[n].replace(',', '.');
            if (string.startsWith(".")) {
                string = "0" + string;
            }
            if (string.trim().length() <= 0) {
                return bigDecimal;
            }
            return new BigDecimal(string.trim());
        }
        catch (Exception exception) {
            LOGGER.warn("could not parse big decimal at field " + n);
            LOGGER.warn("> " + exception.getLocalizedMessage());
            return bigDecimal;
        }
    }

    public static BigInteger getBigInteger(int n, String[] stringArray) {
        return CSVReader.getBigInteger(n, stringArray, null);
    }

    public static BigInteger getBigInteger(int n, String[] stringArray, BigInteger bigInteger) {
        try {
            if (n < 0 || stringArray.length <= n) {
                return bigInteger;
            }
            String string = stringArray[n];
            if (string.trim().length() <= 0) {
                return bigInteger;
            }
            return new BigInteger(string.trim());
        }
        catch (Exception exception) {
            LOGGER.warn("could not parse big integer at field " + n);
            LOGGER.warn("> " + exception.getLocalizedMessage());
            return bigInteger;
        }
    }

    public static char getChar(int n, String[] stringArray) {
        return CSVReader.getChar(n, stringArray, '-');
    }

    public static char getChar(int n, String[] stringArray, char c) {
        if (n < 0 || stringArray.length <= n) {
            return c;
        }
        String string = stringArray[n];
        if (string.trim().length() <= 0) {
            return c;
        }
        return string.toUpperCase().trim().toCharArray()[0];
    }

    public String getCharset() {
        return Charset.defaultCharset().name();
    }

    public static Double getDouble(int n, String[] stringArray) {
        return CSVReader.getDouble(n, stringArray, null);
    }

    public static Double getDouble(int n, String[] stringArray, Double d) {
        try {
            if (n < 0 || stringArray.length <= n) {
                return d;
            }
            String string = stringArray[n].replace(',', '.');
            if (string.startsWith(".")) {
                string = "0" + string;
            }
            if (string.trim().length() <= 0) {
                return d;
            }
            return Double.valueOf(string.trim());
        }
        catch (Exception exception) {
            LOGGER.warn("could not parse double at field " + n);
            LOGGER.warn("> " + exception.getLocalizedMessage());
            return d;
        }
    }

    public static Float getFloat(int n, String[] stringArray) {
        return CSVReader.getFloat(n, stringArray, null);
    }

    public static Float getFloat(int n, String[] stringArray, Float f) {
        try {
            if (n < 0 || stringArray.length <= n) {
                return f;
            }
            String string = stringArray[n].replace(',', '.');
            if (string.startsWith(".")) {
                string = "0" + string;
            }
            if (string.trim().length() <= 0) {
                return f;
            }
            return Float.valueOf(Double.valueOf(string.trim()).floatValue());
        }
        catch (Exception exception) {
            LOGGER.warn("could not parse float at field " + n);
            LOGGER.warn("> " + exception.getLocalizedMessage());
            return f;
        }
    }

    public static Integer getInt(int n, String[] stringArray) {
        return CSVReader.getInt(n, stringArray, null);
    }

    public static Integer getInt(int n, String[] stringArray, Integer n2) {
        try {
            if (n < 0 || stringArray.length <= n) {
                return n2;
            }
            String string = stringArray[n];
            if (string.trim().length() <= 0) {
                return n2;
            }
            return Double.valueOf(string.trim()).intValue();
        }
        catch (Exception exception) {
            LOGGER.warn("could not parse integer at field " + n);
            LOGGER.warn("> " + exception.getLocalizedMessage());
            return n2;
        }
    }

    public static Long getLong(int n, String[] stringArray) {
        return CSVReader.getLong(n, stringArray, null);
    }

    public static Long getLong(int n, String[] stringArray, Long l) {
        try {
            if (n < 0 || stringArray.length <= n) {
                return l;
            }
            String string = stringArray[n];
            if (string.trim().length() <= 0) {
                return l;
            }
            return Double.valueOf(string.trim()).longValue();
        }
        catch (Exception exception) {
            LOGGER.warn("could not parse integer at field " + n);
            LOGGER.warn("> " + exception.getLocalizedMessage());
            return l;
        }
    }

    public static String getString(int n, String[] stringArray) {
        return CSVReader.getString(n, stringArray, null);
    }

    public static String getString(int n, String[] stringArray, String string) {
        try {
            if (n < 0 || stringArray.length <= n) {
                return string;
            }
            String string2 = stringArray[n];
            if (StringUtils.isBlank((CharSequence)string2)) {
                return string;
            }
            return string2.replaceAll("<br>", SystemUtils.LINE_SEPARATOR).trim();
        }
        catch (Exception exception) {
            LOGGER.warn("could not parse string at field " + n);
            LOGGER.warn("> " + exception.getLocalizedMessage());
            return string;
        }
    }

    public void read(File file, SerializableXmlElement serializableXmlElement) throws IOException {
        this.read(file, serializableXmlElement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file, SerializableXmlElement serializableXmlElement, String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.read(fileInputStream, serializableXmlElement, string);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
    }

    public void read(InputStream inputStream, SerializableXmlElement serializableXmlElement) throws IOException {
        this.read(inputStream, serializableXmlElement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream inputStream, SerializableXmlElement serializableXmlElement, String string) throws IOException {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, string != null ? string : this.getCharset());
            this.read(inputStreamReader, serializableXmlElement);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStreamReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)inputStreamReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Reader reader, SerializableXmlElement serializableXmlElement) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(reader);
            String string = bufferedReader.readLine();
            while (string != null) {
                if (StringUtils.isBlank((CharSequence)string)) continue;
                try {
                    this.readLine(string, serializableXmlElement);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read csv-line!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
                finally {
                    string = bufferedReader.readLine();
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
    }

    public abstract void readLine(String var1, SerializableXmlElement var2);
}

