/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionMultiplicity;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.ParameterMultiplicity;
import org.java.plugin.registry.ParameterType;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.xml.IntegrityChecker;
import org.java.plugin.registry.xml.ModelExtensionPoint;
import org.java.plugin.registry.xml.ModelParameterDef;
import org.java.plugin.registry.xml.ParameterValueParser;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginElementImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExtensionPointImpl
extends PluginElementImpl<ExtensionPoint>
implements ExtensionPoint {
    private final ModelExtensionPoint model;
    private Map<String, Extension> connectedExtensions;
    private Map<String, Extension> availableExtensions;
    private List<ExtensionPoint.ParameterDefinition> parameterDefinitions;
    private Boolean isValid;
    private boolean paramDefsMerged = false;
    private List<ExtensionPoint> descendants;

    ExtensionPointImpl(PluginDescriptorImpl descr, PluginFragmentImpl aFragment, ModelExtensionPoint aModel) throws ManifestProcessingException {
        super(descr, aFragment, aModel.getId(), aModel.getDocumentation());
        this.model = aModel;
        if (this.model.getParentPointId() != null && this.model.getParentPluginId() == null) {
            this.log.warn((Object)("parent plug-in ID not specified together with parent extension point ID, using declaring plug-in ID, extension point is " + this.getUniqueId()));
            this.model.setParentPluginId(descr.getId());
        }
        this.parameterDefinitions = new ArrayList<ExtensionPoint.ParameterDefinition>(this.model.getParamDefs().size());
        HashSet<String> names = new HashSet<String>();
        for (ModelParameterDef modelParameterDef : this.model.getParamDefs()) {
            ParameterDefinitionImpl def = new ParameterDefinitionImpl(null, modelParameterDef);
            if (names.contains(def.getId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateParameterDefinition", new Object[]{def.getId(), this.getId(), descr.getId()});
            }
            names.add(def.getId());
            this.parameterDefinitions.add(def);
        }
        this.parameterDefinitions = Collections.unmodifiableList(this.parameterDefinitions);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("object instantiated: " + this));
        }
    }

    @Override
    public String getUniqueId() {
        return this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.getDeclaringPluginDescriptor().getId(), this.getId());
    }

    @Override
    public ExtensionMultiplicity getMultiplicity() {
        return this.model.getExtensionMultiplicity();
    }

    private void updateExtensionsLists() {
        this.connectedExtensions = new HashMap<String, Extension>();
        this.availableExtensions = new HashMap<String, Extension>();
        for (PluginDescriptor descr : this.getDeclaringPluginDescriptor().getRegistry().getPluginDescriptors()) {
            for (Extension ext : descr.getExtensions()) {
                if (!this.getDeclaringPluginDescriptor().getId().equals(ext.getExtendedPluginId()) || !this.getId().equals(ext.getExtendedPointId())) continue;
                this.availableExtensions.put(ext.getUniqueId(), ext);
                if (ext.isValid()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("extension " + ext + " connected to point " + this));
                    }
                    this.connectedExtensions.put(ext.getUniqueId(), ext);
                    continue;
                }
                this.log.warn((Object)("extension " + ext.getUniqueId() + " is invalid and doesn't connected to" + " extension point " + this.getUniqueId()));
            }
        }
    }

    @Override
    public Collection<Extension> getAvailableExtensions() {
        if (this.availableExtensions == null) {
            this.updateExtensionsLists();
        }
        return Collections.unmodifiableCollection(this.availableExtensions.values());
    }

    @Override
    public Extension getAvailableExtension(String uniqueId) {
        Extension result;
        if (this.availableExtensions == null) {
            this.updateExtensionsLists();
        }
        if ((result = this.availableExtensions.get(uniqueId)) == null) {
            throw new IllegalArgumentException("extension " + uniqueId + " not available in point " + this.getUniqueId());
        }
        return result;
    }

    @Override
    public boolean isExtensionAvailable(String uniqueId) {
        if (this.availableExtensions == null) {
            this.updateExtensionsLists();
        }
        return this.availableExtensions.containsKey(uniqueId);
    }

    @Override
    public Collection<Extension> getConnectedExtensions() {
        if (this.connectedExtensions == null) {
            this.updateExtensionsLists();
        }
        return Collections.unmodifiableCollection(this.connectedExtensions.values());
    }

    @Override
    public Extension getConnectedExtension(String uniqueId) {
        Extension result;
        if (this.connectedExtensions == null) {
            this.updateExtensionsLists();
        }
        if ((result = this.connectedExtensions.get(uniqueId)) == null) {
            throw new IllegalArgumentException("extension " + uniqueId + " not connected to point " + this.getUniqueId());
        }
        return result;
    }

    @Override
    public boolean isExtensionConnected(String uniqueId) {
        if (this.connectedExtensions == null) {
            this.updateExtensionsLists();
        }
        return this.connectedExtensions.containsKey(uniqueId);
    }

    @Override
    public boolean isValid() {
        if (this.isValid == null) {
            this.validate();
        }
        return this.isValid;
    }

    Collection<IntegrityCheckReport.ReportItem> validate() {
        if (this.model.getParentPluginId() != null && this.model.getParentPointId() != null) {
            try {
                if (!this.isExtensionPointAvailable(this.model.getParentPluginId(), this.model.getParentPointId())) {
                    this.isValid = Boolean.FALSE;
                    return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION_POINT, "parentExtPointNotAvailable", new Object[]{this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.model.getParentPluginId(), this.model.getParentPointId()), this.getUniqueId()}));
                }
            }
            catch (Throwable t) {
                this.isValid = Boolean.FALSE;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("failed checking availability of extension point " + this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.model.getParentPluginId(), this.model.getParentPointId())), t);
                }
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION_POINT, "parentExtPointAvailabilityCheckFailed", new Object[]{this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.model.getParentPluginId(), this.model.getParentPointId()), this.getUniqueId(), t}));
            }
        }
        switch (this.getMultiplicity()) {
            case ANY: {
                this.isValid = Boolean.TRUE;
                return Collections.emptyList();
            }
            case ONE: {
                this.isValid = this.getAvailableExtensions().size() == 1;
                if (this.isValid.booleanValue()) break;
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION_POINT, "toManyOrFewExtsConnected", this.getUniqueId()));
            }
            case NONE: {
                this.isValid = this.getAvailableExtensions().size() == 0;
                if (this.isValid.booleanValue()) break;
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION_POINT, "extsConnectedToAbstractExtPoint", this.getUniqueId()));
            }
            case ONE_PER_PLUGIN: {
                this.isValid = Boolean.TRUE;
                HashSet<String> foundPlugins = new HashSet<String>();
                for (Extension extension : this.getAvailableExtensions()) {
                    String pluginId = extension.getDeclaringPluginDescriptor().getId();
                    if (foundPlugins.add(pluginId)) continue;
                    this.isValid = Boolean.FALSE;
                    return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION_POINT, "toManyExtsConnected", this.getUniqueId()));
                }
                break;
            }
        }
        return Collections.emptyList();
    }

    private boolean isExtensionPointAvailable(String pluginId, String pointId) {
        PluginRegistry registry = this.getDeclaringPluginDescriptor().getRegistry();
        if (!registry.isPluginDescriptorAvailable(pluginId)) {
            return false;
        }
        for (ExtensionPoint extensionPoint : registry.getPluginDescriptor(pluginId).getExtensionPoints()) {
            if (!extensionPoint.getId().equals(pointId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ExtensionPoint.ParameterDefinition> getParameterDefinitions() {
        if (this.model.getParentPluginId() == null || this.model.getParentPointId() == null || this.paramDefsMerged) {
            return this.parameterDefinitions;
        }
        HashSet<String> names = new HashSet<String>();
        Collection<ExtensionPoint.ParameterDefinition> parentParamDefs = this.getDeclaringPluginDescriptor().getRegistry().getExtensionPoint(this.model.getParentPluginId(), this.model.getParentPointId()).getParameterDefinitions();
        ArrayList<ExtensionPoint.ParameterDefinition> newParamDefs = new ArrayList<ExtensionPoint.ParameterDefinition>(this.parameterDefinitions.size() + parentParamDefs.size());
        for (ExtensionPoint.ParameterDefinition def : this.parameterDefinitions) {
            names.add(def.getId());
            newParamDefs.add(def);
        }
        for (ExtensionPoint.ParameterDefinition def : parentParamDefs) {
            if (names.contains(def.getId())) continue;
            newParamDefs.add(def);
        }
        this.paramDefsMerged = true;
        this.parameterDefinitions = Collections.unmodifiableList(newParamDefs);
        return this.parameterDefinitions;
    }

    @Override
    public ExtensionPoint.ParameterDefinition getParameterDefinition(String id) {
        for (ExtensionPoint.ParameterDefinition parameterDefinition : this.getParameterDefinitions()) {
            ParameterDefinitionImpl def = (ParameterDefinitionImpl)parameterDefinition;
            if (!def.getId().equals(id)) continue;
            return def;
        }
        throw new IllegalArgumentException("parameter definition with ID " + id + " not found in extension point " + this.getUniqueId() + " and all it parents");
    }

    @Override
    public String getParentPluginId() {
        return this.model.getParentPluginId();
    }

    @Override
    public String getParentExtensionPointId() {
        return this.model.getParentPointId();
    }

    @Override
    public boolean isSuccessorOf(ExtensionPoint extensionPoint) {
        if (this.model.getParentPluginId() == null || this.model.getParentPointId() == null) {
            return false;
        }
        if (this.model.getParentPluginId().equals(extensionPoint.getDeclaringPluginDescriptor().getId()) && this.model.getParentPointId().equals(extensionPoint.getId())) {
            return true;
        }
        try {
            return this.getDeclaringPluginDescriptor().getRegistry().getExtensionPoint(this.model.getParentPluginId(), this.model.getParentPointId()).isSuccessorOf(extensionPoint);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private void collectDescendants() {
        this.descendants = new LinkedList<ExtensionPoint>();
        for (PluginDescriptor descr : this.getDeclaringPluginDescriptor().getRegistry().getPluginDescriptors()) {
            for (ExtensionPoint extp : descr.getExtensionPoints()) {
                if (!extp.isSuccessorOf(this)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("extension point " + extp + " is descendant of point " + this));
                }
                this.descendants.add(extp);
            }
        }
        this.descendants = Collections.unmodifiableList(this.descendants);
    }

    @Override
    public Collection<ExtensionPoint> getDescendants() {
        if (this.descendants == null) {
            this.collectDescendants();
        }
        return this.descendants;
    }

    public String toString() {
        return "{ExtensionPoint: uid=" + this.getUniqueId() + "}";
    }

    void registryChanged() {
        this.isValid = null;
        this.connectedExtensions = null;
        this.availableExtensions = null;
        this.descendants = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ParameterDefinitionImpl
    extends PluginElementImpl<ExtensionPoint.ParameterDefinition>
    implements ExtensionPoint.ParameterDefinition {
        private List<ExtensionPoint.ParameterDefinition> subDefinitions;
        private final ParameterDefinitionImpl superDefinition;
        private final ModelParameterDef modelParamDef;
        private final ParameterValueParser valueParser;

        ParameterDefinitionImpl(ParameterDefinitionImpl aSuperDefinition, ModelParameterDef aModel) throws ManifestProcessingException {
            super(ExtensionPointImpl.this.getDeclaringPluginDescriptor(), ExtensionPointImpl.this.getDeclaringPluginFragment(), aModel.getId(), aModel.getDocumentation());
            this.superDefinition = aSuperDefinition;
            this.modelParamDef = aModel;
            this.valueParser = new ParameterValueParser(this.getDeclaringPluginDescriptor().getRegistry(), this, this.modelParamDef.getDefaultValue());
            if (!this.valueParser.isParsingSucceeds()) {
                this.log.warn((Object)("parsing default value for parameter definition " + this + " failed, message is: " + this.valueParser.getParsingMessage()));
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "invalidDefaultValueAttribute", new Object[]{this.modelParamDef.getDefaultValue(), ExtensionPointImpl.this.getId(), ExtensionPointImpl.this.getDeclaringPluginDescriptor().getId()});
            }
            if (ParameterType.ANY == this.modelParamDef.getType()) {
                this.subDefinitions = Collections.emptyList();
            } else {
                this.subDefinitions = new ArrayList<ExtensionPoint.ParameterDefinition>(this.modelParamDef.getParamDefs().size());
                HashSet<String> names = new HashSet<String>();
                for (ModelParameterDef modelParameterDef : this.modelParamDef.getParamDefs()) {
                    ParameterDefinitionImpl def = new ParameterDefinitionImpl(this, modelParameterDef);
                    if (names.contains(def.getId())) {
                        throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateParameterDefinition", new Object[]{def.getId(), ExtensionPointImpl.this.getId(), ExtensionPointImpl.this.getDeclaringPluginDescriptor().getId()});
                    }
                    names.add(def.getId());
                    this.subDefinitions.add(def);
                }
                this.subDefinitions = Collections.unmodifiableList(this.subDefinitions);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("object instantiated: " + this));
            }
        }

        ParameterValueParser getValueParser() {
            return this.valueParser;
        }

        @Override
        public ExtensionPoint getDeclaringExtensionPoint() {
            return ExtensionPointImpl.this;
        }

        @Override
        public ParameterMultiplicity getMultiplicity() {
            return this.modelParamDef.getMultiplicity();
        }

        @Override
        public Collection<ExtensionPoint.ParameterDefinition> getSubDefinitions() {
            return this.subDefinitions;
        }

        @Override
        public ExtensionPoint.ParameterDefinition getSuperDefinition() {
            return this.superDefinition;
        }

        @Override
        public ExtensionPoint.ParameterDefinition getSubDefinition(String id) {
            for (ExtensionPoint.ParameterDefinition parameterDefinition : this.subDefinitions) {
                ParameterDefinitionImpl def = (ParameterDefinitionImpl)parameterDefinition;
                if (!def.getId().equals(id)) continue;
                return def;
            }
            throw new IllegalArgumentException("parameter definition with ID " + id + " not found in extension point " + ExtensionPointImpl.this.getUniqueId());
        }

        @Override
        public ParameterType getType() {
            return this.modelParamDef.getType();
        }

        @Override
        public String getCustomData() {
            return this.modelParamDef.getCustomData();
        }

        @Override
        public String getDefaultValue() {
            return this.modelParamDef.getDefaultValue();
        }

        public String toString() {
            return "{PluginExtensionPoint.ParameterDefinition: extPointUid=" + this.getDeclaringExtensionPoint().getUniqueId() + "; id=" + this.getId() + "}";
        }

        @Override
        protected boolean isEqualTo(Identity idt) {
            if (!super.isEqualTo(idt)) {
                return false;
            }
            ParameterDefinitionImpl other = (ParameterDefinitionImpl)idt;
            if (this.getSuperDefinition() == null && other.getSuperDefinition() == null) {
                return true;
            }
            if (this.getSuperDefinition() == null || other.getSuperDefinition() == null) {
                return false;
            }
            return this.getSuperDefinition().equals(other.getSuperDefinition());
        }
    }
}

