/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jxmapviewer.cache.LocalCache;

public class FileBasedLocalCache
implements LocalCache {
    private static final Log log = LogFactory.getLog(FileBasedLocalCache.class);
    private final File cacheDir;
    private final boolean checkForUpdates;

    public FileBasedLocalCache(File cacheDir, boolean checkForUpdates) {
        this.cacheDir = cacheDir;
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        this.checkForUpdates = checkForUpdates;
    }

    @Override
    public InputStream get(URL url) throws IOException {
        File localFile = this.getLocalFile(url);
        if (!localFile.exists()) {
            return null;
        }
        if (this.checkForUpdates && FileBasedLocalCache.isUpdateAvailable(url, localFile)) {
            return null;
        }
        return new FileInputStream(localFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(URL url, InputStream data) throws IOException {
        File localFile = this.getLocalFile(url);
        localFile.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(localFile);
        try {
            FileBasedLocalCache.copy(data, out);
        }
        finally {
            out.close();
        }
    }

    public File getLocalFile(URL remoteUri) {
        StringBuilder sb = new StringBuilder();
        String host = remoteUri.getHost();
        String query = remoteUri.getQuery();
        String path = remoteUri.getPath();
        if (host != null) {
            sb.append(host);
        }
        if (path != null) {
            sb.append(path);
        }
        if (query != null) {
            sb.append('?');
            sb.append(query);
        }
        int maxLen = 250;
        String name = sb.length() < 250 ? sb.toString() : sb.substring(0, 250);
        name = name.replace('?', '$');
        name = name.replace('*', '$');
        name = name.replace(':', '$');
        name = name.replace('<', '$');
        name = name.replace('>', '$');
        name = name.replace('\"', '$');
        File f = new File(this.cacheDir, name);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isUpdateAvailable(URL remoteUri, File localFile) {
        URLConnection conn;
        try {
            conn = remoteUri.openConnection();
        }
        catch (MalformedURLException ex) {
            log.error((Object)"An exception occurred", (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            log.error((Object)"An exception occurred", (Throwable)ex);
            return false;
        }
        if (!(conn instanceof HttpURLConnection)) {
            return false;
        }
        long localLastMod = localFile.lastModified();
        long remoteLastMod = 0L;
        HttpURLConnection httpconn = (HttpURLConnection)conn;
        httpconn.setUseCaches(false);
        try {
            httpconn.connect();
            remoteLastMod = httpconn.getLastModified();
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            httpconn.disconnect();
        }
        return remoteLastMod > localLastMod;
    }

    private static long copy(InputStream source, OutputStream sink) throws IOException {
        int n;
        long nread = 0L;
        byte[] buf = new byte[8192];
        while ((n = source.read(buf)) > 0) {
            sink.write(buf, 0, n);
            nread += (long)n;
        }
        return nread;
    }
}

