/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.core.ssl;

import com.openindex.openestate.tool.core.ssl.CallbackTrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedSSLSocketFactory
extends SSLSocketFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedSSLSocketFactory.class);
    private static CallbackTrustManager.Callback CALLBACK = null;
    private static KeyStore CUSTOM_TRUSTSTORE = null;
    private static char[] CUSTOM_TRUSTSTORE_PASSWORD = null;
    private SSLSocketFactory defaultFactory;

    public ExtendedSSLSocketFactory() throws KeyManagementException, NoSuchAlgorithmException {
        this(ExtendedSSLSocketFactory.createSSLContext());
    }

    public ExtendedSSLSocketFactory(SSLContext sSLContext) {
        this.defaultFactory = sSLContext.getSocketFactory();
    }

    public static SSLContext createSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        CallbackTrustManager callbackTrustManager = new CallbackTrustManager(CUSTOM_TRUSTSTORE, CUSTOM_TRUSTSTORE_PASSWORD, CALLBACK);
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, new TrustManager[]{callbackTrustManager}, null);
        return sSLContext;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.defaultFactory.createSocket();
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.defaultFactory.createSocket(inetAddress, n);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return this.defaultFactory.createSocket(inetAddress, n, inetAddress2, n2);
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException {
        return this.defaultFactory.createSocket(string, n);
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        return this.defaultFactory.createSocket(string, n, inetAddress, n2);
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return this.defaultFactory.createSocket(socket, string, n, bl);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.defaultFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.defaultFactory.getSupportedCipherSuites();
    }

    public static void init(CallbackTrustManager.Callback callback, KeyStore keyStore, char[] cArray) throws KeyManagementException, NoSuchAlgorithmException {
        CALLBACK = callback;
        CUSTOM_TRUSTSTORE = keyStore;
        CUSTOM_TRUSTSTORE_PASSWORD = cArray;
        SSLContext.setDefault(ExtendedSSLSocketFactory.createSSLContext());
    }
}

