/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.atlanticbb.tantlinger.io.CopyMonitor;

public class MonitoredInputStream
extends FilterInputStream {
    CopyMonitor monitor;

    public MonitoredInputStream(InputStream inputStream, CopyMonitor copyMonitor) {
        super(inputStream);
        this.monitor = copyMonitor;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        this.checkAborted();
        return super.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkAborted();
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.monitor.bytesCopied(n3);
        }
        return n3;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        this.checkAborted();
        return super.read(byArray);
    }

    private void checkAborted() throws IOException {
        if (this.monitor.isCopyAborted()) {
            System.err.println("copy aborted");
            throw new IOException("Copy aborted");
        }
    }
}

