/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.shef;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;
import net.atlanticbb.tantlinger.i18n.I18n;
import net.atlanticbb.tantlinger.ui.DefaultAction;
import net.atlanticbb.tantlinger.ui.text.AbstractEditor;
import net.atlanticbb.tantlinger.ui.text.AbstractSourceEditor;
import net.atlanticbb.tantlinger.ui.text.AbstractToolBar;
import net.atlanticbb.tantlinger.ui.text.AbstractWysiwygEditor;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.DefaultSourceEditor;
import net.atlanticbb.tantlinger.ui.text.DefaultWysiwygEditor;
import net.atlanticbb.tantlinger.ui.text.Entities;
import net.atlanticbb.tantlinger.ui.text.actions.ClearStylesAction;
import net.atlanticbb.tantlinger.ui.text.actions.FindReplaceAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLEditorActionFactory;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLElementPropertiesAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLFontAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLFontColorAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLHorizontalRuleAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLImageAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLLineBreakAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLLinkAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTableAction;
import net.atlanticbb.tantlinger.ui.text.actions.SpecialCharAction;
import org.bushe.swing.action.ActionList;
import org.bushe.swing.action.ActionUIFactory;

public class HTMLEditorPane
extends JPanel {
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.shef");
    private static final String[] INVALID_TAGS = new String[]{"html", "head", "body", "title", "meta"};
    private AbstractWysiwygEditor wysEditor;
    private AbstractSourceEditor srcEditor;
    private AbstractEditor currentEditor = null;
    private List<AbstractEditor> editors = new ArrayList<AbstractEditor>();
    private JPanel toolBarPanel;
    private JPanel toolBarPanelContainer;
    private JTabbedPane tabs;
    private JMenu editMenu;
    private JMenu formatMenu;
    private JMenu insertMenu;
    private JPopupMenu wysPopupMenu;
    private JPopupMenu srcPopupMenu;
    private ActionList actionList;
    private FocusListener focusHandler = new FocusHandler();
    private DocumentListener textChangedHandler = new TextChangedHandler();
    private MouseListener popupHandler = new PopupHandler();
    private boolean isWysTextChanged;

    public HTMLEditorPane() {
        this.build();
        this.updateToolBar();
    }

    protected void addEditor(AbstractEditor abstractEditor) {
        if (!this.editors.contains(abstractEditor)) {
            this.editors.add(abstractEditor);
            this.tabs.addTab(abstractEditor.getTabTitle(), abstractEditor.getComponent());
        }
    }

    private void build() {
        this.buildToolBar();
        this.buildEditorTabs();
        this.buildEditorActions();
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBarPanel, "North");
        this.add((Component)this.tabs, "Center");
    }

    private void buildEditorActions() {
        this.actionList = new ActionList((Object)"editor-actions");
        ActionList actionList = new ActionList((Object)"paraActions");
        ActionList actionList2 = new ActionList((Object)"fontSizeActions");
        ActionList actionList3 = HTMLEditorActionFactory.createEditActionList();
        HTMLElementPropertiesAction hTMLElementPropertiesAction = new HTMLElementPropertiesAction();
        this.wysPopupMenu = ActionUIFactory.getInstance().createPopupMenu(actionList3);
        this.wysPopupMenu.addSeparator();
        this.wysPopupMenu.add((Action)((Object)hTMLElementPropertiesAction));
        this.srcPopupMenu = ActionUIFactory.getInstance().createPopupMenu(actionList3);
        ActionList actionList4 = new ActionList((Object)"edits");
        DefaultAction defaultAction = new ChangeTabAction(0);
        actionList4.add((Object)defaultAction);
        defaultAction = new ChangeTabAction(1);
        actionList4.add((Object)defaultAction);
        actionList4.add(null);
        actionList4.addAll((Collection)actionList3);
        actionList4.add(null);
        actionList4.add((Object)new FindReplaceAction(false));
        this.actionList.addAll((Collection)actionList4);
        this.editMenu = ActionUIFactory.getInstance().createMenu(actionList4);
        this.editMenu.setText(i18n.str("edit"));
        this.formatMenu = new JMenu(i18n.str("format"));
        actionList4 = HTMLEditorActionFactory.createFontSizeActionList();
        this.actionList.addAll((Collection)actionList4);
        this.formatMenu.add(this.createMenu(actionList4, i18n.str("size")));
        actionList2.addAll((Collection)actionList4);
        actionList4 = HTMLEditorActionFactory.createInlineActionList();
        this.actionList.addAll((Collection)actionList4);
        this.formatMenu.add(this.createMenu(actionList4, i18n.str("style")));
        defaultAction = new HTMLFontColorAction();
        this.actionList.add((Object)defaultAction);
        this.formatMenu.add((Action)((Object)defaultAction));
        defaultAction = new HTMLFontAction();
        this.actionList.add((Object)defaultAction);
        this.formatMenu.add((Action)((Object)defaultAction));
        defaultAction = new ClearStylesAction();
        this.actionList.add((Object)defaultAction);
        this.formatMenu.add((Action)((Object)defaultAction));
        this.formatMenu.addSeparator();
        actionList4 = HTMLEditorActionFactory.createBlockElementActionList();
        this.actionList.addAll((Collection)actionList4);
        this.formatMenu.add(this.createMenu(actionList4, i18n.str("paragraph")));
        actionList.addAll((Collection)actionList4);
        actionList4 = HTMLEditorActionFactory.createListElementActionList();
        this.actionList.addAll((Collection)actionList4);
        this.formatMenu.add(this.createMenu(actionList4, i18n.str("list")));
        this.formatMenu.addSeparator();
        actionList.addAll((Collection)actionList4);
        actionList4 = HTMLEditorActionFactory.createAlignActionList();
        this.actionList.addAll((Collection)actionList4);
        this.formatMenu.add(this.createMenu(actionList4, i18n.str("align")));
        JMenu jMenu = new JMenu(i18n.str("table"));
        actionList4 = HTMLEditorActionFactory.createInsertTableElementActionList();
        this.actionList.addAll((Collection)actionList4);
        jMenu.add(this.createMenu(actionList4, i18n.str("insert")));
        actionList4 = HTMLEditorActionFactory.createDeleteTableElementActionList();
        this.actionList.addAll((Collection)actionList4);
        jMenu.add(this.createMenu(actionList4, i18n.str("delete")));
        this.formatMenu.add(jMenu);
        this.formatMenu.addSeparator();
        this.actionList.add((Object)hTMLElementPropertiesAction);
        this.formatMenu.add((Action)((Object)hTMLElementPropertiesAction));
        this.insertMenu = new JMenu(i18n.str("insert"));
        defaultAction = new HTMLLinkAction();
        this.actionList.add((Object)defaultAction);
        this.insertMenu.add((Action)((Object)defaultAction));
        defaultAction = new HTMLImageAction();
        this.actionList.add((Object)defaultAction);
        this.insertMenu.add((Action)((Object)defaultAction));
        defaultAction = new HTMLTableAction();
        this.actionList.add((Object)defaultAction);
        this.insertMenu.add((Action)((Object)defaultAction));
        this.insertMenu.addSeparator();
        defaultAction = new HTMLLineBreakAction();
        this.actionList.add((Object)defaultAction);
        this.insertMenu.add((Action)((Object)defaultAction));
        defaultAction = new HTMLHorizontalRuleAction();
        this.actionList.add((Object)defaultAction);
        this.insertMenu.add((Action)((Object)defaultAction));
        defaultAction = new SpecialCharAction();
        this.actionList.add((Object)defaultAction);
        this.insertMenu.add((Action)((Object)defaultAction));
    }

    private void buildEditorTabs() {
        this.wysEditor = this.createWysiwygEditor();
        this.wysEditor.addFocusListener(this.focusHandler);
        this.wysEditor.addMouseListener(this.popupHandler);
        this.wysEditor.addDocumentListener(this.textChangedHandler);
        this.srcEditor = this.createSourceEditor();
        this.srcEditor.addFocusListener(this.focusHandler);
        this.srcEditor.addMouseListener(this.popupHandler);
        this.tabs = new JTabbedPane(3);
        this.initEditorTabs(this.wysEditor, this.srcEditor);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                HTMLEditorPane.this.updateEditor();
            }
        });
        Document document = this.wysEditor.getDocument();
        document.addUndoableEditListener(new CompoundUndoManager(document, new UndoManager()));
        Document document2 = this.srcEditor.getDocument();
        document2.addUndoableEditListener(new CompoundUndoManager(document2, new UndoManager()));
    }

    private void buildToolBar() {
        this.toolBarPanel = new JPanel(new BorderLayout());
        this.toolBarPanelContainer = new JPanel(new BorderLayout());
        this.toolBarPanel.add((Component)this.toolBarPanelContainer, "Center");
        this.initToolBarPanel(this.toolBarPanel);
    }

    private JMenu createMenu(ActionList actionList, String string) {
        JMenu jMenu = ActionUIFactory.getInstance().createMenu(actionList);
        jMenu.setText(string);
        return jMenu;
    }

    protected AbstractSourceEditor createSourceEditor() {
        return new DefaultSourceEditor();
    }

    protected AbstractWysiwygEditor createWysiwygEditor() {
        return new DefaultWysiwygEditor();
    }

    public JMenu getEditMenu() {
        return this.editMenu;
    }

    public JMenu getFormatMenu() {
        return this.formatMenu;
    }

    public JMenu getInsertMenu() {
        return this.insertMenu;
    }

    public AbstractEditor getSelectedEditor() {
        int n = this.tabs.getSelectedIndex();
        return n > -1 && n < this.editors.size() ? this.editors.get(n) : null;
    }

    public String getSourceText() {
        String string = HTMLEditorPane.removeInvalidTags(this.srcEditor.getText());
        string = HTMLEditorPane.deIndent(HTMLEditorPane.removeInvalidTags(string));
        string = Entities.HTML40.unescapeUnknownEntities(string);
        return string;
    }

    public String getText() {
        String string = null;
        if (this.isWysiwygEditorSelected()) {
            string = this.getWysiwygText();
        } else if (this.isSourceEditorSelected()) {
            string = this.getSourceText();
        } else {
            AbstractEditor abstractEditor = this.getSelectedEditor();
            if (abstractEditor != null) {
                string = abstractEditor.getText();
            }
        }
        return string != null ? string : "";
    }

    public String getWysiwygText() {
        return HTMLEditorPane.removeInvalidTags(this.wysEditor.getText());
    }

    protected void initEditorTabs(AbstractWysiwygEditor abstractWysiwygEditor, AbstractSourceEditor abstractSourceEditor) {
        this.addEditor(abstractWysiwygEditor);
        this.addEditor(abstractSourceEditor);
    }

    protected void initToolBarPanel(JPanel jPanel) {
    }

    public boolean isEditorSelected(AbstractEditor abstractEditor) {
        int n = this.editors.indexOf(abstractEditor);
        return n > -1 && this.tabs.getSelectedIndex() == n;
    }

    public boolean isSourceEditorSelected() {
        return this.isEditorSelected(this.srcEditor);
    }

    public boolean isWysiwygEditorSelected() {
        return this.isEditorSelected(this.wysEditor);
    }

    public void setCaretPosition(int n) {
        AbstractEditor abstractEditor = this.getSelectedEditor();
        if (abstractEditor != null) {
            abstractEditor.setCaretPosition(n);
            abstractEditor.requestFocusInWindow();
        }
    }

    public void setEditorEnabled(AbstractEditor abstractEditor, boolean bl) {
        int n = this.editors.indexOf(abstractEditor);
        if (n < 0) {
            return;
        }
        this.tabs.setEnabledAt(n, bl);
        if (!bl && this.tabs.getSelectedIndex() == n) {
            for (int i = 0; i < this.tabs.getTabCount(); ++i) {
                if (i == n || !this.tabs.isEnabledAt(i)) continue;
                this.tabs.setSelectedIndex(i);
                break;
            }
        }
    }

    public void setSelectedEditor(AbstractEditor abstractEditor) {
        int n = this.editors.indexOf(abstractEditor);
        if (n > -1) {
            this.tabs.setSelectedIndex(n);
        }
    }

    public void setSourceEnabled(boolean bl) {
        this.setEditorEnabled(this.srcEditor, bl);
    }

    public void setSourceText(String string) {
        String string2 = HTMLEditorPane.deIndent(HTMLEditorPane.removeInvalidTags(string));
        string2 = Entities.HTML40.unescapeUnknownEntities(string2);
        this.srcEditor.setText(string2);
        this.srcEditor.setCaretPosition(0);
    }

    public void setText(String string) {
        String string2 = HTMLEditorPane.removeInvalidTags(string);
        if (this.isWysiwygEditorSelected()) {
            this.setWysiwygText(string2);
            CompoundUndoManager.discardAllEdits(this.wysEditor.getDocument());
        } else if (this.isSourceEditorSelected()) {
            this.setSourceText(string2);
            CompoundUndoManager.discardAllEdits(this.srcEditor.getDocument());
        } else {
            AbstractEditor abstractEditor = this.getSelectedEditor();
            if (abstractEditor != null) {
                abstractEditor.setText(string2);
                CompoundUndoManager.discardAllEdits(abstractEditor.getDocument());
            }
        }
    }

    public void setToolBarVisible(boolean bl) {
        this.toolBarPanel.setVisible(bl);
    }

    public void setWysiwygEnabled(boolean bl) {
        this.setEditorEnabled(this.wysEditor, bl);
    }

    public void setWysiwygText(String string) {
        this.wysEditor.setText("");
        this.wysEditor.insertHTML(string, 0);
        this.wysEditor.setCaretPosition(0);
    }

    private void updateEditor() {
        if (this.isWysiwygEditorSelected() && this.currentEditor == this.srcEditor) {
            String string = HTMLEditorPane.removeInvalidTags(this.srcEditor.getText());
            this.wysEditor.setText("");
            this.wysEditor.insertHTML(string, 0);
            this.wysEditor.setCaretPosition(0);
            CompoundUndoManager.discardAllEdits(this.wysEditor.getDocument());
        } else if (this.isSourceEditorSelected() && this.currentEditor == this.wysEditor) {
            String string = HTMLEditorPane.removeInvalidTags(this.wysEditor.getText());
            if (this.isWysTextChanged || this.srcEditor.getText().equals("")) {
                String string2 = HTMLEditorPane.deIndent(HTMLEditorPane.removeInvalidTags(string));
                string2 = Entities.HTML40.unescapeUnknownEntities(string2);
                this.srcEditor.setText(string2);
                this.srcEditor.setCaretPosition(0);
            }
            CompoundUndoManager.discardAllEdits(this.srcEditor.getDocument());
        }
        this.currentEditor = this.getSelectedEditor();
        this.updateToolBar();
        this.isWysTextChanged = false;
    }

    private void updateToolBar() {
        AbstractEditor abstractEditor = this.getSelectedEditor();
        AbstractToolBar abstractToolBar = abstractEditor != null ? abstractEditor.getToolBar() : null;
        this.toolBarPanelContainer.removeAll();
        if (abstractToolBar != null) {
            this.toolBarPanelContainer.add((Component)abstractToolBar, "Center");
        }
        this.toolBarPanel.revalidate();
        this.toolBarPanel.repaint();
        this.setToolBarVisible(abstractToolBar != null);
    }

    private static String deIndent(String string) {
        String string2 = "\n    ";
        StringBuilder stringBuilder = new StringBuilder(string);
        while (stringBuilder.indexOf(string2) != -1) {
            int n = stringBuilder.indexOf(string2);
            int n2 = n + string2.length();
            stringBuilder.delete(n, n2);
            stringBuilder.insert(n, "\n");
        }
        return stringBuilder.toString();
    }

    private static String removeInvalidTags(String string) {
        for (int i = 0; i < INVALID_TAGS.length; ++i) {
            string = HTMLEditorPane.deleteOccurance(string, '<' + INVALID_TAGS[i] + '>');
            string = HTMLEditorPane.deleteOccurance(string, "</" + INVALID_TAGS[i] + '>');
        }
        return string.trim();
    }

    private static String deleteOccurance(String string, String string2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((n = stringBuilder.toString().toLowerCase().indexOf(string2.toLowerCase())) != -1) {
            stringBuilder.delete(n, n + string2.length());
        }
        return stringBuilder.toString();
    }

    private class ChangeTabAction
    extends DefaultAction {
        int tab;

        public ChangeTabAction(int n) {
            super(n == 0 ? HTMLEditorPane.this.wysEditor.getTabTitle() : HTMLEditorPane.this.srcEditor.getTabTitle());
            this.tab = n;
            this.putValue("BUTTON_TYPE", "radio");
        }

        protected void execute(ActionEvent actionEvent) {
            int n = HTMLEditorPane.this.editors.indexOf(this.tab == 0 ? HTMLEditorPane.this.wysEditor : HTMLEditorPane.this.srcEditor);
            if (n > -1) {
                HTMLEditorPane.this.tabs.setSelectedIndex(n);
            }
            this.setSelected(n > -1);
        }

        protected void contextChanged() {
            int n = HTMLEditorPane.this.editors.indexOf(this.tab == 0 ? HTMLEditorPane.this.wysEditor : HTMLEditorPane.this.srcEditor);
            this.setSelected(n > -1 && HTMLEditorPane.this.tabs.getSelectedIndex() == n);
        }
    }

    private class TextChangedHandler
    implements DocumentListener {
        private TextChangedHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        private void textChanged() {
            if (HTMLEditorPane.this.isWysiwygEditorSelected()) {
                HTMLEditorPane.this.isWysTextChanged = true;
            }
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            AbstractEditor abstractEditor = HTMLEditorPane.this.getSelectedEditor();
            if (abstractEditor != null) {
                CompoundUndoManager.updateUndo(abstractEditor.getDocument());
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class PopupHandler
    extends MouseAdapter {
        private PopupHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.checkForPopupTrigger(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkForPopupTrigger(mouseEvent);
        }

        private void checkForPopupTrigger(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JPopupMenu jPopupMenu = null;
                if (HTMLEditorPane.this.isWysiwygEditorSelected()) {
                    jPopupMenu = HTMLEditorPane.this.wysPopupMenu;
                } else if (HTMLEditorPane.this.isSourceEditorSelected()) {
                    jPopupMenu = HTMLEditorPane.this.srcPopupMenu;
                } else {
                    return;
                }
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

