/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import net.atlanticbb.tantlinger.ui.text.AbstractToolBar;
import net.atlanticbb.tantlinger.ui.text.AbstractWysiwygEditor;
import net.atlanticbb.tantlinger.ui.text.DefaultWysiwygToolBar;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.WysiwygHTMLEditorKit;
import org.bushe.swing.action.ActionList;

public class DefaultWysiwygEditor
extends AbstractWysiwygEditor {
    private JEditorPane textArea;
    private JScrollPane scroller;
    private DefaultWysiwygToolBar toolBar = null;

    public DefaultWysiwygEditor() {
        this(null);
    }

    public DefaultWysiwygEditor(HTMLEditorKit hTMLEditorKit) {
        this.build(hTMLEditorKit);
    }

    @Override
    public void addCaretListener(CaretListener caretListener) {
        this.textArea.addCaretListener(caretListener);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.textArea.addFocusListener(focusListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.textArea.addMouseListener(mouseListener);
    }

    private void build(HTMLEditorKit hTMLEditorKit) {
        this.textArea = new JEditorPane();
        this.textArea.setOpaque(true);
        this.scroller = new JScrollPane(this.textArea);
        this.textArea.setEditorKitForContentType("text/html", hTMLEditorKit != null ? hTMLEditorKit : new WysiwygHTMLEditorKit());
        this.textArea.setContentType("text/html");
        this.insertHTML("<p></p>", 0);
    }

    @Override
    public int getCaretPosition() {
        return this.textArea.getCaretPosition();
    }

    @Override
    public JComponent getComponent() {
        return this.scroller;
    }

    @Override
    public Document getDocument() {
        return this.textArea.getDocument();
    }

    @Override
    public String getFontFamily() {
        return HTMLUtils.getFontFamily(this.textArea);
    }

    @Override
    public String getText() {
        return this.textArea.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractToolBar getToolBar() {
        if (this.toolBar == null) {
            DefaultWysiwygEditor defaultWysiwygEditor = this;
            synchronized (defaultWysiwygEditor) {
                this.toolBar = new DefaultWysiwygToolBar(this);
            }
        }
        return this.toolBar;
    }

    @Override
    public void insertHTML(String string, int n) {
        try {
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.textArea.getEditorKit();
            Document document = this.textArea.getDocument();
            StringReader stringReader = new StringReader(HTMLUtils.jEditorPaneizeHTML(string));
            hTMLEditorKit.read(stringReader, document, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void registerEditor(ActionList actionList) {
        actionList.putContextValueForAll((Object)"editor", (Object)this.textArea);
    }

    @Override
    public void removeCaretListener(CaretListener caretListener) {
        this.textArea.removeCaretListener(caretListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.textArea.removeFocusListener(focusListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.textArea.removeMouseListener(mouseListener);
    }

    @Override
    public void requestFocusInWindow() {
        this.textArea.requestFocusInWindow();
    }

    @Override
    public void setCaretPosition(int n) {
        this.textArea.setCaretPosition(n);
    }

    @Override
    public void setDocument(Document document) {
        this.textArea.setDocument(document);
    }

    @Override
    public void setFontFamily(String string) {
        HTMLUtils.setFontFamily(this.textArea, string);
    }

    @Override
    public void setText(String string) {
        this.textArea.setText(string);
    }
}

