/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.ObjectView;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.DelegateView;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.DecoratedTextAction;
import net.atlanticbb.tantlinger.ui.text.actions.EnterKeyAction;
import net.atlanticbb.tantlinger.ui.text.actions.PasteAction;
import net.atlanticbb.tantlinger.ui.text.actions.RemoveAction;
import net.atlanticbb.tantlinger.ui.text.actions.TabAction;

public class WysiwygHTMLEditorKit
extends HTMLEditorKit {
    private static final long serialVersionUID = 1L;
    private ViewFactory wysFactory = new WysiwygHTMLFactory();
    private ArrayList monitoredViews = new ArrayList();
    private MouseInputAdapter resizeHandler = new ResizeHandler();
    private Map editorToActionsMap = new HashMap();
    private KeyStroke tabBackwardKS = KeyStroke.getKeyStroke(9, 64);

    @Override
    public Document createDefaultDocument() {
        HTMLDocument hTMLDocument = (HTMLDocument)super.createDefaultDocument();
        hTMLDocument.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        return hTMLDocument;
    }

    @Override
    public void install(JEditorPane jEditorPane) {
        super.install(jEditorPane);
        if (this.editorToActionsMap.containsKey(jEditorPane)) {
            return;
        }
        jEditorPane.addMouseListener(this.resizeHandler);
        jEditorPane.addMouseMotionListener(this.resizeHandler);
        HashMap<String, Action> hashMap = new HashMap<String, Action>();
        InputMap inputMap = jEditorPane.getInputMap(0);
        ActionMap actionMap = jEditorPane.getActionMap();
        Action action = actionMap.get("insert-break");
        DecoratedTextAction decoratedTextAction = new EnterKeyAction(action);
        hashMap.put("insert-break", decoratedTextAction);
        actionMap.put("insert-break", decoratedTextAction);
        action = actionMap.get("delete-previous");
        decoratedTextAction = new RemoveAction(0, action);
        hashMap.put("delete-previous", decoratedTextAction);
        actionMap.put("delete-previous", decoratedTextAction);
        action = actionMap.get("delete-next");
        decoratedTextAction = new RemoveAction(1, action);
        hashMap.put("delete-next", decoratedTextAction);
        actionMap.put("delete-next", decoratedTextAction);
        action = actionMap.get("insert-tab");
        decoratedTextAction = new TabAction(0, action);
        hashMap.put("insert-tab", decoratedTextAction);
        actionMap.put("insert-tab", decoratedTextAction);
        action = actionMap.get("paste-from-clipboard");
        PasteAction pasteAction = new PasteAction();
        pasteAction.putContextValue("editor", jEditorPane);
        hashMap.put("paste-from-clipboard", action);
        actionMap.put("paste-from-clipboard", (Action)((Object)pasteAction));
        inputMap.put(this.tabBackwardKS, "tab-backward");
        decoratedTextAction = new TabAction(1, action);
        hashMap.put("tab-backward", decoratedTextAction);
        actionMap.put("tab-backward", decoratedTextAction);
        this.editorToActionsMap.put(jEditorPane, hashMap);
    }

    @Override
    public void deinstall(JEditorPane jEditorPane) {
        super.deinstall(jEditorPane);
        if (!this.editorToActionsMap.containsKey(jEditorPane)) {
            return;
        }
        jEditorPane.removeMouseListener(this.resizeHandler);
        jEditorPane.removeMouseMotionListener(this.resizeHandler);
        ActionMap actionMap = jEditorPane.getActionMap();
        Map map = (Map)this.editorToActionsMap.get(jEditorPane);
        Action action = actionMap.get("insert-break");
        if (action == map.get("insert-break")) {
            actionMap.put("insert-break", ((DecoratedTextAction)action).getDelegate());
        }
        if ((action = actionMap.get("delete-previous")) == map.get("delete-previous")) {
            actionMap.put("delete-previous", ((DecoratedTextAction)action).getDelegate());
        }
        if ((action = actionMap.get("delete-next")) == map.get("delete-next")) {
            actionMap.put("delete-next", ((DecoratedTextAction)action).getDelegate());
        }
        if ((action = actionMap.get("insert-tab")) == map.get("insert-tab")) {
            actionMap.put("insert-tab", ((DecoratedTextAction)action).getDelegate());
        }
        if ((action = actionMap.get("paste-from-clipboard")) instanceof PasteAction) {
            actionMap.put("paste-from-clipboard", (Action)map.get("paste-from-clipboard"));
        }
        if ((action = actionMap.get("tab-backward")) == map.get("insert-tab")) {
            actionMap.remove("tab-backward");
        }
        this.editorToActionsMap.remove(jEditorPane);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.wysFactory;
    }

    private class UnknownElementView
    extends ComponentView {
        public UnknownElementView(Element element) {
            super(element);
        }

        @Override
        protected Component createComponent() {
            JLabel jLabel = new JLabel();
            if (this.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.COMMENT) {
                Object object;
                jLabel.setText("<!-- -->");
                AttributeSet attributeSet = this.getElement().getAttributes();
                if (attributeSet != null && (object = attributeSet.getAttribute(HTML.Attribute.COMMENT)) instanceof String) {
                    jLabel.setToolTipText((String)object);
                }
            } else {
                String string = this.getElement().getName();
                if (string == null || string.equals("")) {
                    string = "??";
                }
                string = this.isEndTag() ? "</" + string + ">" : "<" + string + ">";
                jLabel.setText(string);
            }
            jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            jLabel.setBackground(Color.YELLOW);
            jLabel.setForeground(Color.BLUE);
            jLabel.setOpaque(true);
            return jLabel;
        }

        boolean isEndTag() {
            Object object;
            AttributeSet attributeSet = this.getElement().getAttributes();
            return attributeSet != null && (object = attributeSet.getAttribute(HTML.Attribute.ENDTAG)) != null && object instanceof String && ((String)object).equals("true");
        }
    }

    private class BorderlessTableView
    extends DelegateView {
        public BorderlessTableView(View view) {
            super(view);
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            if (this.shouldDrawDottedBorder()) {
                Object object;
                Object object2;
                Color color = this.getTableBgcolor();
                if (color != null) {
                    object2 = graphics.getColor();
                    graphics.setColor(color);
                    object = shape.getBounds();
                    graphics.fillRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
                    graphics.setColor((Color)object2);
                }
                this.delegate.paint(graphics, shape);
                object2 = (Graphics2D)graphics;
                object = ((Graphics2D)object2).getStroke();
                float[] fArray = new float[]{3.0f};
                BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 10.0f, fArray, 0.0f);
                ((Graphics2D)object2).setStroke(basicStroke);
                ((Graphics)object2).setColor(Color.DARK_GRAY);
                int n = this.getViewCount();
                for (int i = 0; i < n; ++i) {
                    Shape shape2 = this.getChildAllocation(i, shape);
                    View view = this.getView(i);
                    int n2 = view.getViewCount();
                    for (int j = 0; j < n2; ++j) {
                        Shape shape3 = view.getChildAllocation(j, shape2);
                        Rectangle rectangle = shape3.getBounds();
                        ((Graphics)object2).drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                }
                ((Graphics2D)object2).setStroke((Stroke)object);
            } else {
                this.delegate.paint(graphics, shape);
            }
        }

        private Color getTableBgcolor() {
            AttributeSet attributeSet = this.getElement().getAttributes();
            Object object = attributeSet.getAttribute(HTML.Attribute.BGCOLOR);
            if (object != null) {
                Color color = HTMLUtils.stringToColor(object.toString());
                return color;
            }
            return null;
        }

        private boolean shouldDrawDottedBorder() {
            AttributeSet attributeSet = this.getElement().getAttributes();
            boolean bl = this.hasBorderAttr(attributeSet);
            return !bl || bl && attributeSet.getAttribute(HTML.Attribute.BORDER).toString().equals("0");
        }

        private boolean hasBorderAttr(AttributeSet attributeSet) {
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                if (!enumeration.nextElement().toString().equals("border")) continue;
                return true;
            }
            return false;
        }
    }

    private class ResizableView
    extends DelegateView {
        public static final int NW = 0;
        public static final int NE = 1;
        public static final int SW = 2;
        public static final int SE = 3;
        public static final int N = 4;
        public static final int S = 5;
        public static final int E = 6;
        public static final int W = 7;
        private Rectangle curBounds;
        private Rectangle selBounds;

        public ResizableView(View view) {
            super(view);
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            this.curBounds = new Rectangle(shape.getBounds());
            if (this.canBePaintedSafely(this.delegate)) {
                this.delegate.paint(graphics, shape);
            }
            this.drawSelectionHandles(graphics);
        }

        private boolean canBePaintedSafely(View view) {
            return !(view instanceof ImageView) || !this.hasNoImage((ImageView)view);
        }

        private boolean hasNoImage(ImageView imageView) {
            return imageView.getImage() == null;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.setSelectionEnabled(false);
            super.insertUpdate(documentEvent, shape, viewFactory);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.setSelectionEnabled(false);
            super.changedUpdate(documentEvent, shape, viewFactory);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.setSelectionEnabled(false);
            super.removeUpdate(documentEvent, shape, viewFactory);
        }

        public Rectangle getBounds() {
            return this.curBounds;
        }

        public Rectangle getSelectionBounds() {
            return this.selBounds;
        }

        public void setSelectionEnabled(boolean bl) {
            this.selBounds = bl && this.curBounds != null ? new Rectangle(this.curBounds) : null;
        }

        public boolean isSelectionEnabled() {
            return this.selBounds != null;
        }

        public int getHandleForPoint(Point point) {
            if (this.isSelectionEnabled()) {
                Rectangle[] rectangleArray = this.computeHandles(this.selBounds);
                for (int i = 0; i < rectangleArray.length; ++i) {
                    if (!rectangleArray[i].contains(point)) continue;
                    return i;
                }
            }
            return -1;
        }

        private void drawSelectionHandles(Graphics graphics) {
            if (!this.isSelectionEnabled()) {
                return;
            }
            Color color = graphics.getColor();
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawRect(this.selBounds.x, this.selBounds.y, this.selBounds.width, this.selBounds.height);
            Rectangle[] rectangleArray = this.computeHandles(this.selBounds);
            for (int i = 0; i < rectangleArray.length; ++i) {
                graphics.fillRect(rectangleArray[i].x, rectangleArray[i].y, rectangleArray[i].width, rectangleArray[i].height);
            }
            graphics.setColor(color);
        }

        private Rectangle[] computeHandles(Rectangle rectangle) {
            Rectangle[] rectangleArray = new Rectangle[8];
            int n = 8;
            rectangleArray[0] = new Rectangle(rectangle.x, rectangle.y, n, n);
            rectangleArray[1] = new Rectangle(rectangle.x + rectangle.width - n, rectangle.y, n, n);
            rectangleArray[2] = new Rectangle(rectangle.x, rectangle.y + rectangle.height - n, n, n);
            rectangleArray[3] = new Rectangle(rectangle.x + rectangle.width - n, rectangle.y + rectangle.height - n, n, n);
            int n2 = rectangle.x + (rectangle.width / 2 - n / 2);
            int n3 = rectangle.y + (rectangle.height / 2 - n / 2);
            rectangleArray[4] = new Rectangle(n2, rectangle.y, n, n);
            rectangleArray[5] = new Rectangle(n2, rectangle.y + rectangle.height - n, n, n);
            rectangleArray[6] = new Rectangle(rectangle.x + rectangle.width - n, n3, n, n);
            rectangleArray[7] = new Rectangle(rectangle.x, n3, n, n);
            return rectangleArray;
        }
    }

    private class ResizeHandler
    extends MouseInputAdapter {
        boolean dragStarted;
        boolean mouseDown;
        int dragDir = -1;

        private ResizeHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
            boolean bl = false;
            for (int i = WysiwygHTMLEditorKit.this.monitoredViews.size() - 1; i >= 0; --i) {
                ResizableView resizableView = (ResizableView)WysiwygHTMLEditorKit.this.monitoredViews.get(i);
                Rectangle rectangle = resizableView.getBounds();
                if (rectangle != null && rectangle.contains(mouseEvent.getPoint()) && !bl) {
                    resizableView.setSelectionEnabled(true);
                    this.dragDir = resizableView.getHandleForPoint(mouseEvent.getPoint());
                    this.setCursorForDir(this.dragDir, mouseEvent.getComponent());
                    bl = true;
                    continue;
                }
                resizableView.setSelectionEnabled(false);
            }
            mouseEvent.getComponent().repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!this.mouseDown) {
                ResizableView resizableView = this.getSelectedView();
                if (resizableView == null) {
                    return;
                }
                Component component = mouseEvent.getComponent();
                this.setCursorForDir(resizableView.getHandleForPoint(mouseEvent.getPoint()), component);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.dragStarted = this.dragDir != -1;
            ResizableView resizableView = this.getSelectedView();
            if (resizableView == null || !this.dragStarted) {
                return;
            }
            Rectangle rectangle = resizableView.getSelectionBounds();
            if (this.dragDir == 3) {
                rectangle.width = mouseEvent.getX() - rectangle.x;
                rectangle.height = mouseEvent.getY() - rectangle.y;
            } else if (this.dragDir == 1) {
                rectangle.width = mouseEvent.getX() - rectangle.x;
                rectangle.height = rectangle.y + rectangle.height - mouseEvent.getY();
                rectangle.y = mouseEvent.getY();
            } else if (this.dragDir == 2) {
                rectangle.width = rectangle.x + rectangle.width - mouseEvent.getX();
                rectangle.height = mouseEvent.getY() - rectangle.y;
                rectangle.x = mouseEvent.getX();
            } else if (this.dragDir == 0) {
                rectangle.width = rectangle.x + rectangle.width - mouseEvent.getX();
                rectangle.height = rectangle.y + rectangle.height - mouseEvent.getY();
                rectangle.x = mouseEvent.getX();
                rectangle.y = mouseEvent.getY();
            } else if (this.dragDir == 4) {
                rectangle.height = rectangle.y + rectangle.height - mouseEvent.getY();
                rectangle.y = mouseEvent.getY();
            } else if (this.dragDir == 5) {
                rectangle.height = mouseEvent.getY() - rectangle.y;
            } else if (this.dragDir == 6) {
                rectangle.width = mouseEvent.getX() - rectangle.x;
            } else if (this.dragDir == 7) {
                rectangle.width = rectangle.x + rectangle.width - mouseEvent.getX();
                rectangle.x = mouseEvent.getX();
            }
            mouseEvent.getComponent().repaint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
            ResizableView resizableView = this.getSelectedView();
            if (resizableView != null && this.dragStarted) {
                Element element = resizableView.getElement();
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(element.getAttributes());
                Integer n = new Integer(resizableView.getSelectionBounds().width);
                Integer n2 = new Integer(resizableView.getSelectionBounds().height);
                if (element.getName().equals("table")) {
                    simpleAttributeSet.addAttribute(HTML.Attribute.WIDTH, n);
                    String string = HTMLUtils.getElementHTML(element, false);
                    string = HTMLUtils.createTag(HTML.Tag.TABLE, simpleAttributeSet, string);
                    this.replace(element, string);
                } else if (element.getName().equals("img")) {
                    simpleAttributeSet.addAttribute(HTML.Attribute.WIDTH, n);
                    simpleAttributeSet.addAttribute(HTML.Attribute.HEIGHT, n2);
                    String string = "<img";
                    Enumeration<?> enumeration = simpleAttributeSet.getAttributeNames();
                    while (enumeration.hasMoreElements()) {
                        Object obj = enumeration.nextElement();
                        if (obj.toString().equals("name") || obj.toString().equals("a")) continue;
                        Object object = simpleAttributeSet.getAttribute(obj);
                        string = string + " " + obj + "=\"" + object + "\"";
                    }
                    string = string + ">";
                    if (simpleAttributeSet.isDefined(HTML.Tag.A)) {
                        string = "<a " + simpleAttributeSet.getAttribute(HTML.Tag.A) + ">" + string + "</a>";
                    }
                    this.replace(element, string);
                }
                this.updateMonitoredViews((HTMLDocument)resizableView.getDocument());
            }
            this.dragStarted = false;
        }

        private void setCursorForDir(int n, Component component) {
            if (n == 0) {
                component.setCursor(Cursor.getPredefinedCursor(6));
            } else if (n == 2) {
                component.setCursor(Cursor.getPredefinedCursor(4));
            } else if (n == 1) {
                component.setCursor(Cursor.getPredefinedCursor(7));
            } else if (n == 3) {
                component.setCursor(Cursor.getPredefinedCursor(5));
            } else if (n == 4) {
                component.setCursor(Cursor.getPredefinedCursor(8));
            } else if (n == 5) {
                component.setCursor(Cursor.getPredefinedCursor(9));
            } else if (n == 6) {
                component.setCursor(Cursor.getPredefinedCursor(11));
            } else if (n == 7) {
                component.setCursor(Cursor.getPredefinedCursor(10));
            } else if (component.getCursor().getType() != 0) {
                component.setCursor(Cursor.getDefaultCursor());
            }
        }

        private void updateMonitoredViews(HTMLDocument hTMLDocument) {
            Iterator iterator = WysiwygHTMLEditorKit.this.monitoredViews.iterator();
            while (iterator.hasNext()) {
                Element element;
                View view = (View)iterator.next();
                Element element2 = view.getElement();
                if (element2.getName().equals("img")) {
                    element = hTMLDocument.getCharacterElement(element2.getStartOffset());
                    if (element == element2) continue;
                    iterator.remove();
                    continue;
                }
                if (!element2.getName().equals("table")) continue;
                element = hTMLDocument.getParagraphElement(element2.getStartOffset());
                if ((element = HTMLUtils.getParent(element, HTML.Tag.TABLE)) == element2) continue;
                iterator.remove();
            }
        }

        private ResizableView getSelectedView() {
            for (ResizableView resizableView : WysiwygHTMLEditorKit.this.monitoredViews) {
                if (!resizableView.isSelectionEnabled()) continue;
                return resizableView;
            }
            return null;
        }

        private void replace(Element element, String string) {
            HTMLDocument hTMLDocument = (HTMLDocument)element.getDocument();
            CompoundUndoManager.beginCompoundEdit(hTMLDocument);
            try {
                hTMLDocument.setOuterHTML(element, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            CompoundUndoManager.endCompoundEdit(hTMLDocument);
        }
    }

    public class WysiwygHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        @Override
        public View create(Element element) {
            Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (object instanceof HTML.Tag) {
                HTML.Tag tag = (HTML.Tag)object;
                if (tag == HTML.Tag.TABLE) {
                    ResizableView resizableView = new ResizableView(new BorderlessTableView(super.create(element)));
                    WysiwygHTMLEditorKit.this.monitoredViews.add(resizableView);
                    return resizableView;
                }
                if (tag == HTML.Tag.IMG) {
                    ResizableView resizableView = new ResizableView(super.create(element));
                    WysiwygHTMLEditorKit.this.monitoredViews.add(resizableView);
                    return resizableView;
                }
                if (tag == HTML.Tag.COMMENT) {
                    return new UnknownElementView(element);
                }
                if (tag == HTML.Tag.OBJECT) {
                    ObjectView objectView = new ObjectView(element){

                        @Override
                        protected Component createComponent() {
                            JLabel jLabel;
                            Component component = super.createComponent();
                            if (component instanceof JLabel && (jLabel = (JLabel)component).getText().equals("??") && jLabel.getForeground().equals(Color.red)) {
                                jLabel.setIcon(UIUtils.getIcon("resources/images/x24/", "cogs.png"));
                                jLabel.setText(null);
                                jLabel.setBackground(Color.YELLOW);
                                jLabel.setOpaque(true);
                                jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
                                jLabel.setToolTipText("<object></object>");
                            }
                            return component;
                        }
                    };
                    return objectView;
                }
                if (tag instanceof HTML.UnknownTag || tag == HTML.Tag.TITLE || tag == HTML.Tag.META || tag == HTML.Tag.LINK || tag == HTML.Tag.STYLE || tag == HTML.Tag.SCRIPT || tag == HTML.Tag.AREA || tag == HTML.Tag.MAP || tag == HTML.Tag.PARAM || tag == HTML.Tag.APPLET) {
                    return new UnknownElementView(element);
                }
            }
            return super.create(element);
        }
    }
}

