/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;
import net.atlanticbb.tantlinger.ui.text.dialogs.ElementStyleDialog;
import net.atlanticbb.tantlinger.ui.text.dialogs.HyperlinkDialog;
import net.atlanticbb.tantlinger.ui.text.dialogs.ImageDialog;
import net.atlanticbb.tantlinger.ui.text.dialogs.ListDialog;
import net.atlanticbb.tantlinger.ui.text.dialogs.TablePropertiesDialog;
import org.bushe.swing.action.ShouldBeEnabledDelegate;

public class HTMLElementPropertiesAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;
    public static final int TABLE_PROPS = 0;
    public static final int LIST_PROPS = 1;
    public static final int IMG_PROPS = 2;
    public static final int LINK_PROPS = 3;
    public static final int ELEM_PROPS = 4;
    public static final String[] PROPS = new String[]{i18n.str("table_properties_"), i18n.str("list_properties_"), i18n.str("image_properties_"), i18n.str("hyperlink_properties_"), i18n.str("object_properties_")};

    public HTMLElementPropertiesAction() {
        super(PROPS[4]);
        this.addShouldBeEnabledDelegate(new ShouldBeEnabledDelegate(){

            public boolean shouldBeEnabled(Action action) {
                return HTMLElementPropertiesAction.this.getEditMode() != 1 && HTMLElementPropertiesAction.this.elementAtCaretPosition(HTMLElementPropertiesAction.this.getCurrentEditor()) != null;
            }
        });
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        Element element = this.elementAtCaretPosition(jEditorPane);
        int n = this.getElementType(element);
        int n2 = jEditorPane.getCaretPosition();
        if (n == 3) {
            this.editLinkProps(element);
        } else if (n == 2) {
            this.editImageProps(element);
        } else if (n == 0) {
            this.editTableProps(element);
        } else if (n == 1) {
            this.editListProps(element);
        } else if (n == 4) {
            this.editStyleProps(element.getParentElement());
        }
        try {
            jEditorPane.setCaretPosition(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map getAttribs(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AttributeSet attributeSet = element.getAttributes();
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj.toString().equals("name") && !element.getName().equals("a")) continue;
            hashMap.put(obj.toString(), attributeSet.getAttribute(obj).toString());
        }
        return hashMap;
    }

    private String getElementHTML(Element element, Map map) {
        String string = "<" + element.getName();
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            string = string + " " + k + "=\"" + v + "\"";
        }
        String string2 = HTMLUtils.getElementHTML(element, false);
        string = string + ">\n" + (String)string2 + "\n</" + element.getName() + ">";
        return string;
    }

    private Map getLinkAttributes(Element element) {
        String string = HTMLUtils.getElementHTML(element, true).trim();
        Map map = new HashMap();
        if (string.startsWith("<a")) {
            string = string.substring(0, string.indexOf(62));
            string = string.substring(string.indexOf(32), string.length()).trim();
            map = HTMLUtils.tagAttribsToMap(string);
        }
        return map;
    }

    private void editImageProps(Element element) {
        ImageDialog imageDialog = this.createImageDialog();
        if (imageDialog != null) {
            Map map = this.getAttribs(element);
            imageDialog.setImageAttributes(map);
            imageDialog.setLocationRelativeTo(imageDialog.getParent());
            imageDialog.setVisible(true);
            if (!imageDialog.hasUserCancelled()) {
                this.replace(element, imageDialog.getHTML());
            }
        }
    }

    private void editLinkProps(Element element) {
        HyperlinkDialog hyperlinkDialog = this.createLinkDialog();
        if (hyperlinkDialog != null) {
            hyperlinkDialog.setAttributes(this.getLinkAttributes(element));
            hyperlinkDialog.setLocationRelativeTo(hyperlinkDialog.getParent());
            try {
                String string = element.getDocument().getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                hyperlinkDialog.setLinkText(string);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            hyperlinkDialog.setVisible(true);
            if (!hyperlinkDialog.hasUserCancelled()) {
                this.replace(element, hyperlinkDialog.getHTML());
            }
        }
    }

    private void editTableProps(Element element) {
        HTMLDocument hTMLDocument = null;
        try {
            hTMLDocument = (HTMLDocument)element.getDocument();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        Element element2 = HTMLUtils.getParent(element, HTML.Tag.TD);
        Element element3 = HTMLUtils.getParent(element, HTML.Tag.TR);
        Element element4 = HTMLUtils.getParent(element, HTML.Tag.TABLE);
        TablePropertiesDialog tablePropertiesDialog = this.createTablePropertiesDialog();
        if (tablePropertiesDialog == null || element2 == null || element3 == null || element4 == null) {
            return;
        }
        tablePropertiesDialog.setCellAttributes(this.getAttribs(element2));
        tablePropertiesDialog.setRowAttributes(this.getAttribs(element3));
        tablePropertiesDialog.setTableAttributes(this.getAttribs(element4));
        tablePropertiesDialog.setLocationRelativeTo(tablePropertiesDialog.getParent());
        tablePropertiesDialog.setVisible(true);
        if (!tablePropertiesDialog.hasUserCancelled()) {
            CompoundUndoManager.beginCompoundEdit(hTMLDocument);
            try {
                String string = this.getElementHTML(element2, tablePropertiesDialog.getCellAttributes());
                hTMLDocument.setOuterHTML(element2, string);
                string = this.getElementHTML(element3, tablePropertiesDialog.getRowAttribures());
                hTMLDocument.setOuterHTML(element3, string);
                string = this.getElementHTML(element4, tablePropertiesDialog.getTableAttributes());
                hTMLDocument.setOuterHTML(element4, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            CompoundUndoManager.endCompoundEdit(hTMLDocument);
        }
    }

    private void editListProps(Element element) {
        int n;
        if ((element = HTMLUtils.getListParent(element)) == null) {
            return;
        }
        if (element.getName().equals("ul")) {
            n = 0;
        } else if (element.getName().equals("ol")) {
            n = 1;
        } else {
            return;
        }
        Map map = this.getAttribs(element);
        ListDialog listDialog = this.createListDialog();
        if (listDialog == null) {
            return;
        }
        listDialog.setListType(n);
        listDialog.setListAttributes(map);
        listDialog.setLocationRelativeTo(listDialog.getParent());
        listDialog.setVisible(true);
        if (!listDialog.hasUserCancelled()) {
            map = listDialog.getListAttributes();
            String string = "";
            if (listDialog.getListType() != n) {
                HTML.Tag tag = HTML.Tag.UL;
                if (listDialog.getListType() == 1) {
                    tag = HTML.Tag.OL;
                }
                String string2 = HTMLUtils.getElementHTML(element, false);
                string = "<" + tag;
                for (Object k : map.keySet()) {
                    string = string + " " + k + "=" + map.get(k);
                }
                string = string + ">" + string2 + "</" + tag + ">";
            } else {
                string = this.getElementHTML(element, map);
            }
            this.replace(element, string);
        }
    }

    private void editStyleProps(Element element) {
        if (element.getName().equals("p-implied")) {
            element = element.getParentElement();
        }
        Map map = this.getAttribs(element);
        ElementStyleDialog elementStyleDialog = this.createStyleDialog();
        if (elementStyleDialog == null) {
            return;
        }
        elementStyleDialog.setLocationRelativeTo(elementStyleDialog.getParent());
        elementStyleDialog.setStyleAttributes(map);
        elementStyleDialog.setVisible(true);
        if (!elementStyleDialog.hasUserCancelled()) {
            System.err.println(element.getName());
            String string = this.getElementHTML(element, elementStyleDialog.getStyleAttributes());
            System.err.println(string);
            this.replace(element, string);
        }
    }

    protected HyperlinkDialog createLinkDialog() {
        JEditorPane jEditorPane = this.getCurrentEditor();
        HyperlinkDialog hyperlinkDialog = null;
        if (jEditorPane != null) {
            Window window = SwingUtilities.getWindowAncestor(jEditorPane);
            if (window != null && window instanceof Frame) {
                hyperlinkDialog = new HyperlinkDialog((Frame)window);
            } else if (window != null && window instanceof Dialog) {
                hyperlinkDialog = new HyperlinkDialog((Dialog)window);
            }
        }
        return hyperlinkDialog;
    }

    protected ImageDialog createImageDialog() {
        JEditorPane jEditorPane = this.getCurrentEditor();
        ImageDialog imageDialog = null;
        if (jEditorPane != null) {
            Window window = SwingUtilities.getWindowAncestor(jEditorPane);
            if (window != null && window instanceof Frame) {
                imageDialog = new ImageDialog((Frame)window);
            } else if (window != null && window instanceof Dialog) {
                imageDialog = new ImageDialog((Dialog)window);
            }
        }
        return imageDialog;
    }

    protected TablePropertiesDialog createTablePropertiesDialog() {
        JEditorPane jEditorPane = this.getCurrentEditor();
        TablePropertiesDialog tablePropertiesDialog = null;
        if (jEditorPane != null) {
            Window window = SwingUtilities.getWindowAncestor(jEditorPane);
            if (window != null && window instanceof Frame) {
                tablePropertiesDialog = new TablePropertiesDialog((Frame)window);
            } else if (window != null && window instanceof Dialog) {
                tablePropertiesDialog = new TablePropertiesDialog((Dialog)window);
            }
        }
        return tablePropertiesDialog;
    }

    protected ListDialog createListDialog() {
        JEditorPane jEditorPane = this.getCurrentEditor();
        ListDialog listDialog = null;
        if (jEditorPane != null) {
            Window window = SwingUtilities.getWindowAncestor(jEditorPane);
            if (window != null && window instanceof Frame) {
                listDialog = new ListDialog((Frame)window);
            } else if (window != null && window instanceof Dialog) {
                listDialog = new ListDialog((Dialog)window);
            }
        }
        return listDialog;
    }

    protected ElementStyleDialog createStyleDialog() {
        JEditorPane jEditorPane = this.getCurrentEditor();
        ElementStyleDialog elementStyleDialog = null;
        if (jEditorPane != null) {
            Window window = SwingUtilities.getWindowAncestor(jEditorPane);
            if (window != null && window instanceof Frame) {
                elementStyleDialog = new ElementStyleDialog((Frame)window);
            } else if (window != null && window instanceof Dialog) {
                elementStyleDialog = new ElementStyleDialog((Dialog)window);
            }
        }
        return elementStyleDialog;
    }

    private void replace(Element element, String string) {
        HTMLDocument hTMLDocument = null;
        try {
            hTMLDocument = (HTMLDocument)element.getDocument();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        CompoundUndoManager.beginCompoundEdit(hTMLDocument);
        try {
            hTMLDocument.setOuterHTML(element, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        CompoundUndoManager.endCompoundEdit(hTMLDocument);
    }

    @Override
    protected void updateWysiwygContextState(JEditorPane jEditorPane) {
        int n = 4;
        Element element = this.elementAtCaretPosition(jEditorPane);
        if (element != null) {
            n = this.getElementType(element);
        }
        this.putValue("Name", PROPS[n]);
    }

    private int getElementType(Element element) {
        AttributeSet attributeSet = element.getAttributes();
        String string = attributeSet.getAttribute(StyleConstants.NameAttribute).toString();
        if (string.equals("img")) {
            return 2;
        }
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().toString().equals("a")) continue;
            return 3;
        }
        if (HTMLUtils.getParent(element, HTML.Tag.UL) != null) {
            return 1;
        }
        if (HTMLUtils.getParent(element, HTML.Tag.OL) != null) {
            return 1;
        }
        if (HTMLUtils.getParent(element, HTML.Tag.TD) != null) {
            return 0;
        }
        return 4;
    }

    private Element elementAtCaretPosition(JEditorPane jEditorPane) {
        if (jEditorPane == null) {
            return null;
        }
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        int n = jEditorPane.getCaretPosition();
        Element element = hTMLDocument.getParagraphElement(n);
        HTMLDocument.BlockElement blockElement = (HTMLDocument.BlockElement)element;
        return blockElement.positionToElement(n);
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
    }
}

