/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JColorChooser;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledEditorKit;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;

public class HTMLFontColorAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public HTMLFontColorAction() {
        super(i18n.str("color_"));
        this.putValue("MnemonicKey", new Integer(i18n.mnem("color_")));
        this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "color.png"));
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        Color color = this.getColorFromUser(jEditorPane);
        if (color == null) {
            return;
        }
        String string = "<font color=" + HTMLUtils.colorToHex(color) + ">";
        String string2 = "</font>";
        String string3 = jEditorPane.getSelectedText();
        if (string3 == null) {
            jEditorPane.replaceSelection(string + string2);
            int n = jEditorPane.getCaretPosition() - string2.length();
            if (n >= 0) {
                jEditorPane.setCaretPosition(n);
            }
        } else {
            string3 = string + string3 + string2;
            jEditorPane.replaceSelection(string3);
        }
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        Color color = this.getColorFromUser(jEditorPane);
        if (color != null) {
            StyledEditorKit.ForegroundAction foregroundAction = new StyledEditorKit.ForegroundAction("Color", color);
            foregroundAction.actionPerformed(actionEvent);
        }
    }

    private Color getColorFromUser(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window != null) {
            component = window;
        }
        Color color = JColorChooser.showDialog(component, "Color", Color.black);
        return color;
    }
}

