/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTML;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;
import net.atlanticbb.tantlinger.ui.text.dialogs.ImageDialog;

public class HTMLImageAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public HTMLImageAction() {
        super(i18n.str("image_"));
        this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "image.png"));
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        ImageDialog imageDialog = this.createDialog(jEditorPane);
        imageDialog.setLocationRelativeTo(imageDialog.getParent());
        imageDialog.setVisible(true);
        if (imageDialog.hasUserCancelled()) {
            return;
        }
        jEditorPane.requestFocusInWindow();
        jEditorPane.replaceSelection(imageDialog.getHTML());
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        ImageDialog imageDialog = this.createDialog(jEditorPane);
        imageDialog.setLocationRelativeTo(imageDialog.getParent());
        imageDialog.setVisible(true);
        if (imageDialog.hasUserCancelled()) {
            return;
        }
        String string = imageDialog.getHTML();
        if (jEditorPane.getCaretPosition() == jEditorPane.getDocument().getLength()) {
            string = string + "&nbsp;";
        }
        jEditorPane.replaceSelection("");
        HTML.Tag tag = HTML.Tag.IMG;
        if (string.startsWith("<a")) {
            tag = HTML.Tag.A;
        }
        HTMLUtils.insertHTML(string, tag, jEditorPane);
    }

    protected ImageDialog createDialog(JTextComponent jTextComponent) {
        Window window = SwingUtilities.getWindowAncestor(jTextComponent);
        ImageDialog imageDialog = null;
        if (window != null && window instanceof Frame) {
            imageDialog = new ImageDialog((Frame)window);
        } else if (window != null && window instanceof Dialog) {
            imageDialog = new ImageDialog((Dialog)window);
        }
        return imageDialog;
    }
}

