/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.TextEditPopupManager;
import net.atlanticbb.tantlinger.ui.text.dialogs.HTMLAttributeEditorPanel;
import net.atlanticbb.tantlinger.ui.text.dialogs.ImageAttributesPanel;
import net.atlanticbb.tantlinger.ui.text.dialogs.LinkAttributesPanel;

public class ImagePanel
extends HTMLAttributeEditorPanel {
    private static final long serialVersionUID = 1L;
    private ImageAttributesPanel imageAttrPanel;
    private LinkAttributesPanel linkAttrPanel;
    private JTextField linkUrlField;
    private JCheckBox linkCB;

    public ImagePanel() {
        this(new Hashtable());
    }

    public ImagePanel(Hashtable hashtable) {
        this.initialize();
        this.setAttributes(hashtable);
        this.updateComponentsFromAttribs();
    }

    private String createAttribs(Map map) {
        String string = "";
        for (Object k : map.keySet()) {
            string = string + " " + k + "=\"" + map.get(k) + "\"";
        }
        return string;
    }

    @Override
    public void updateComponentsFromAttribs() {
        this.imageAttrPanel.setAttributes(this.attribs);
        if (this.attribs.containsKey("a")) {
            this.linkCB.setSelected(true);
            this.linkAttrPanel.setEnabled(true);
            this.linkUrlField.setEditable(true);
            Map map = HTMLUtils.tagAttribsToMap(this.attribs.get("a").toString());
            if (map.containsKey("href")) {
                this.linkUrlField.setText(map.get("href").toString());
            } else {
                this.linkUrlField.setText("");
            }
            this.linkAttrPanel.setAttributes(map);
        } else {
            this.linkCB.setSelected(false);
            this.linkAttrPanel.setEnabled(false);
            this.linkUrlField.setEditable(false);
            this.linkAttrPanel.setAttributes(new HashMap());
        }
    }

    @Override
    public void updateAttribsFromComponents() {
        this.imageAttrPanel.updateAttribsFromComponents();
        this.linkAttrPanel.updateAttribsFromComponents();
        if (this.linkCB.isSelected()) {
            Map map = this.linkAttrPanel.getAttributes();
            map.put("href", this.linkUrlField.getText());
            this.attribs.put("a", this.createAttribs(map));
        } else {
            this.attribs.remove("a");
        }
    }

    private void initialize() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.linkAttrPanel = new LinkAttributesPanel();
        this.linkCB = new JCheckBox(i18n.str("link"));
        this.linkUrlField = new JTextField();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.linkCB, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.linkUrlField, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.linkAttrPanel, "Center");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.imageAttrPanel = new ImageAttributesPanel();
        this.imageAttrPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jTabbedPane.addTab(i18n.str("image"), this.imageAttrPanel);
        jTabbedPane.addTab(i18n.str("link"), jPanel2);
        this.setLayout(new BorderLayout());
        this.add(jTabbedPane);
        this.linkAttrPanel.setEnabled(this.linkCB.isSelected());
        this.linkUrlField.setEditable(this.linkCB.isSelected());
        this.linkCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ImagePanel.this.linkAttrPanel.setEnabled(ImagePanel.this.linkCB.isSelected());
                ImagePanel.this.linkUrlField.setEditable(ImagePanel.this.linkCB.isSelected());
            }
        });
        TextEditPopupManager.getInstance().registerJTextComponent(this.linkUrlField);
    }
}

