/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateConstant;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexAttrib;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComplexEnergyConsumptionAttrib
extends ComplexAttrib<EnergyConsumptionValue> {
    private static final long serialVersionUID = -4731415243592796754L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ComplexEnergyConsumptionAttrib.class);
    private static final String XML_ATTRIB_UNIT = "Unit";
    private EnergyConsumptionValue value = null;

    public ComplexEnergyConsumptionAttrib(OpenEstateAttrib openEstateAttrib, String[] stringArray) {
        super(openEstateAttrib, stringArray);
    }

    @Override
    public EnergyConsumptionValue getDefaultValue() {
        return new EnergyConsumptionValue(BigDecimal.ZERO, null);
    }

    protected static EnergyConsumptionValue get(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        return ComplexEnergyConsumptionAttrib.get(estateImpl, openEstateAttrib, EnergyConsumptionValue.Unit.getBaseUnit());
    }

    protected static EnergyConsumptionValue get(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, EnergyConsumptionValue.Unit unit) {
        try {
            ComplexEnergyConsumptionAttrib complexEnergyConsumptionAttrib = (ComplexEnergyConsumptionAttrib)estateImpl.getAttribute(openEstateAttrib);
            if (complexEnergyConsumptionAttrib == null) {
                return null;
            }
            EnergyConsumptionValue energyConsumptionValue = complexEnergyConsumptionAttrib.getValue();
            return unit == null || unit == energyConsumptionValue.getUnit() ? energyConsumptionValue : new EnergyConsumptionValue(EnergyConsumptionValue.convert(energyConsumptionValue, unit), unit);
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as EnergyConsumptionValue!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    protected static BigDecimal getAsBigDecimal(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, EnergyConsumptionValue.Unit unit) {
        EnergyConsumptionValue energyConsumptionValue = ComplexEnergyConsumptionAttrib.get(estateImpl, openEstateAttrib, unit);
        return energyConsumptionValue != null ? energyConsumptionValue.getValue() : null;
    }

    protected static BigInteger getAsBigInteger(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, EnergyConsumptionValue.Unit unit) {
        EnergyConsumptionValue energyConsumptionValue = ComplexEnergyConsumptionAttrib.get(estateImpl, openEstateAttrib, unit);
        return energyConsumptionValue != null ? energyConsumptionValue.getValue().toBigInteger() : null;
    }

    protected static Double getAsDouble(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, EnergyConsumptionValue.Unit unit) {
        EnergyConsumptionValue energyConsumptionValue = ComplexEnergyConsumptionAttrib.get(estateImpl, openEstateAttrib, unit);
        return energyConsumptionValue != null ? Double.valueOf(energyConsumptionValue.doubleValue()) : null;
    }

    protected static Float getAsFloat(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, EnergyConsumptionValue.Unit unit) {
        EnergyConsumptionValue energyConsumptionValue = ComplexEnergyConsumptionAttrib.get(estateImpl, openEstateAttrib, unit);
        return energyConsumptionValue != null ? Float.valueOf(energyConsumptionValue.floatValue()) : null;
    }

    protected static Integer getAsInteger(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, EnergyConsumptionValue.Unit unit) {
        EnergyConsumptionValue energyConsumptionValue = ComplexEnergyConsumptionAttrib.get(estateImpl, openEstateAttrib, unit);
        return energyConsumptionValue != null ? Integer.valueOf(energyConsumptionValue.intValue()) : null;
    }

    protected static Long getAsLong(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, EnergyConsumptionValue.Unit unit) {
        EnergyConsumptionValue energyConsumptionValue = ComplexEnergyConsumptionAttrib.get(estateImpl, openEstateAttrib, unit);
        return energyConsumptionValue != null ? Long.valueOf(energyConsumptionValue.longValue()) : null;
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, EnergyConsumptionValue.Unit unit) {
        return ComplexEnergyConsumptionAttrib.getAsString(estateImpl, openEstateAttrib, unit, null);
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, EnergyConsumptionValue.Unit unit, Locale locale) {
        try {
            EnergyConsumptionValue energyConsumptionValue = ComplexEnergyConsumptionAttrib.get(estateImpl, openEstateAttrib, unit);
            AbstractAttribImpl abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib);
            return energyConsumptionValue != null && abstractAttribImpl != null ? abstractAttribImpl.getFormattedValue(energyConsumptionValue, locale) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as String!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public final NumberFormat getFormat() {
        return this.getFormat(null);
    }

    public final NumberFormat getFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(0);
        return numberFormat;
    }

    @Override
    public String getFormattedValue(EnergyConsumptionValue energyConsumptionValue, Locale locale, String string) {
        if (energyConsumptionValue == null) {
            return "";
        }
        String string2 = OpenEstateUtils.isApproximatedAttributes() ? OpenEstateConstant.APPROX.getTranslation(locale) + " " : "";
        return string2 + this.getFormat(locale).format(energyConsumptionValue.getValue()) + " " + energyConsumptionValue.getUnit().write();
    }

    @Override
    public EnergyConsumptionValue getValue() {
        return this.value;
    }

    @Override
    protected EnergyConsumptionValue parseNode(Element element) {
        EnergyConsumptionValue.Unit unit;
        if (element == null) {
            return null;
        }
        Number number = OpenEstateUtils.parseNumber(element.getStringValue(), this.getFormat());
        Node node = element.selectSingleNode("@Unit");
        String string = StringUtils.trimToNull((String)(node != null ? node.getStringValue() : null));
        try {
            unit = string != null ? EnergyConsumptionValue.Unit.valueOf(string.toUpperCase()) : EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't parse length unit \"" + string + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
        return number != null ? EnergyConsumptionValue.parse(number, unit) : null;
    }

    @Override
    public EnergyConsumptionValue parseValue(Object object) {
        return EnergyConsumptionValue.parse(object);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, String string, EnergyConsumptionValue.Unit unit) {
        ComplexEnergyConsumptionAttrib.put(estateImpl, openEstateAttrib, string != null ? EnergyConsumptionValue.parse(string, unit) : null);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Number number, EnergyConsumptionValue.Unit unit) {
        ComplexEnergyConsumptionAttrib.put(estateImpl, openEstateAttrib, number != null ? EnergyConsumptionValue.parse(number, unit) : null);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, EnergyConsumptionValue energyConsumptionValue) {
        try {
            if (energyConsumptionValue == null) {
                estateImpl.removeAttribute(openEstateAttrib);
            } else {
                ComplexEnergyConsumptionAttrib complexEnergyConsumptionAttrib = (ComplexEnergyConsumptionAttrib)openEstateAttrib.createImpl();
                complexEnergyConsumptionAttrib.setValue(energyConsumptionValue);
                estateImpl.putAttribute(complexEnergyConsumptionAttrib);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't put length attribute \"" + openEstateAttrib + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    @Override
    public void setValue(EnergyConsumptionValue energyConsumptionValue) {
        this.value = energyConsumptionValue;
    }

    @Override
    protected void writeNode(Element element, EnergyConsumptionValue energyConsumptionValue) {
        if (element == null || energyConsumptionValue == null || energyConsumptionValue.getValue() == null) {
            return;
        }
        try {
            element.setText(energyConsumptionValue.getValue().toString());
            element.addAttribute(XML_ATTRIB_UNIT, energyConsumptionValue.getUnit() != null ? energyConsumptionValue.getUnit().name() : EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR.name());
        }
        catch (Exception exception) {
            LOGGER.warn("Can't write length attribute!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }
}

