/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.values;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.values.UnitValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnergyConsumptionValue
extends Number
implements UnitValue<Unit>,
Comparable<EnergyConsumptionValue> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnergyConsumptionValue.class);
    private BigDecimal value;
    private Unit unit;

    public EnergyConsumptionValue() {
        this(null, null);
    }

    public EnergyConsumptionValue(BigDecimal bigDecimal, Unit unit) {
        this.value = bigDecimal;
        this.unit = unit != null ? unit : Unit.getBaseUnit();
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="Comparison does not use equals() - possibly a bug in FindBugs.")
    public int compareTo(EnergyConsumptionValue energyConsumptionValue) {
        Unit unit;
        if (energyConsumptionValue == null) {
            return -1;
        }
        BigDecimal bigDecimal = this.getValue();
        BigDecimal bigDecimal2 = energyConsumptionValue.getValue();
        if (bigDecimal == null && bigDecimal2 == null) {
            return 0;
        }
        if (bigDecimal == null) {
            return 1;
        }
        if (bigDecimal2 == null) {
            return -1;
        }
        Unit unit2 = this.getUnit();
        if (unit2 == null) {
            unit2 = Unit.getBaseUnit();
        }
        if ((unit = energyConsumptionValue.getUnit()) == null) {
            unit = Unit.getBaseUnit();
        }
        if (unit2 != unit) {
            bigDecimal2 = EnergyConsumptionValue.convert(bigDecimal2, unit, unit2);
        }
        return bigDecimal.compareTo(bigDecimal2);
    }

    public static BigDecimal convert(EnergyConsumptionValue energyConsumptionValue, Unit unit) {
        return EnergyConsumptionValue.convert(energyConsumptionValue.getValue(), energyConsumptionValue.getUnit(), unit);
    }

    public static BigDecimal convert(BigDecimal bigDecimal, Unit unit, Unit unit2) {
        if (unit == null) {
            throw new IllegalArgumentException("Invalid source unit!");
        }
        if (unit2 == null) {
            throw new IllegalArgumentException("Invalid target unit!");
        }
        if (unit == unit2) {
            return bigDecimal;
        }
        MathContext mathContext = new MathContext(10, RoundingMode.HALF_UP);
        BigDecimal bigDecimal2 = unit.getBaseUnitFactor();
        if (bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
            throw new IllegalArgumentException("An invalid source unit was provided!");
        }
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2, mathContext);
        if (Unit.getBaseUnit() == unit2) {
            return bigDecimal3;
        }
        BigDecimal bigDecimal4 = unit2.getBaseUnitFactor();
        if (bigDecimal4.compareTo(BigDecimal.ZERO) < 1) {
            throw new IllegalArgumentException("An invalid target unit was provided!");
        }
        return bigDecimal3.divide(bigDecimal4, mathContext);
    }

    @Override
    public double doubleValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.floatValue();
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.longValue();
    }

    public static EnergyConsumptionValue parse(Object object) {
        return EnergyConsumptionValue.parse(object, null);
    }

    public static EnergyConsumptionValue parse(Object object, Unit unit) {
        if (object instanceof EnergyConsumptionValue) {
            return (EnergyConsumptionValue)object;
        }
        if (unit == null) {
            unit = Unit.getBaseUnit();
        }
        if (object instanceof String) {
            object = OpenEstateUtils.parseNumber((String)object);
        }
        if (object instanceof BigDecimal) {
            return new EnergyConsumptionValue((BigDecimal)object, unit);
        }
        if (object instanceof BigInteger) {
            return new EnergyConsumptionValue(BigDecimal.valueOf(((Number)object).longValue()), unit);
        }
        if (object instanceof Long) {
            return new EnergyConsumptionValue(BigDecimal.valueOf(((Number)object).longValue()), unit);
        }
        if (object instanceof Integer) {
            return new EnergyConsumptionValue(BigDecimal.valueOf(((Number)object).longValue()), unit);
        }
        if (object instanceof Number) {
            return new EnergyConsumptionValue(BigDecimal.valueOf(((Number)object).doubleValue()), unit);
        }
        return null;
    }

    @Override
    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public void setValue(BigDecimal bigDecimal) {
        this.value = bigDecimal;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : "null";
    }

    public static enum Unit {
        KWH_PER_SQM_AND_YEAR;


        public static Unit getBaseUnit() {
            return KWH_PER_SQM_AND_YEAR;
        }

        public BigDecimal getBaseUnitFactor() {
            switch (this) {
                case KWH_PER_SQM_AND_YEAR: {
                    return BigDecimal.ONE;
                }
            }
            return BigDecimal.ZERO;
        }

        public String toString() {
            return this.write();
        }

        public String write() {
            switch (this) {
                case KWH_PER_SQM_AND_YEAR: {
                    return "kWh/(m\u00b2a)";
                }
            }
            return null;
        }
    }
}

