/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.common.CalendarViewConfig;
import bizcal.swing.CalendarListener;
import bizcal.swing.PopupMenuCallback;
import bizcal.swing.util.ErrorHandler;
import bizcal.swing.util.GradientArea;
import bizcal.swing.util.ResourceIcon;
import bizcal.swing.util.TrueGridLayout;
import bizcal.util.BizcalException;
import bizcal.util.DateUtil;
import bizcal.util.TextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ColumnHeaderPanel {
    public static final Color GRADIENT_COLOR = new Color(230, 230, 230);
    private PopupMenuCallback popupMenuCallback;
    private JPanel panel;
    private List calHeaders = new ArrayList();
    private List dateHeaders = new ArrayList();
    private List dateHeaders2 = new ArrayList();
    private List dateList = new ArrayList();
    private List dateLines = new ArrayList();
    private GradientArea gradientArea;
    private JLabel referenceLabel = new JLabel("AAA");
    private int rowCount;
    private int dayCount;
    private CalendarModel model;
    private Color lineColor = Color.LIGHT_GRAY;
    private int fixedDayCount = -1;
    private CalendarListener listener;
    private boolean showExtraDateHeaders = false;
    private CalendarViewConfig config;
    private boolean isMonthView = false;
    private static Font headerFont = new Font("Arial", 0, 12);
    private static Color todayColor = new Color(111, 236, 82);
    private static Color sundayColor = new Color(255, 106, 106);

    public ColumnHeaderPanel(CalendarViewConfig calendarViewConfig) {
        this.config = calendarViewConfig;
        this.panel = new JPanel();
        this.panel.setLayout(new Layout());
        this.gradientArea = new GradientArea("TOP_BOTTOM", Color.WHITE, GRADIENT_COLOR);
        this.gradientArea.setBorder(false);
    }

    public ColumnHeaderPanel(CalendarViewConfig calendarViewConfig, int n) {
        this(calendarViewConfig);
        this.fixedDayCount = n;
    }

    public void refresh() throws Exception {
        this.calHeaders.clear();
        this.dateHeaders.clear();
        this.dateHeaders2.clear();
        this.dateList.clear();
        this.dateLines.clear();
        this.panel.removeAll();
        java.util.Calendar calendar = DateUtil.newCalendar();
        this.dayCount = DateUtil.getDateDiff(this.model.getInterval().getEndDate(), this.model.getInterval().getStartDate());
        if (this.fixedDayCount > 0) {
            this.dayCount = this.fixedDayCount;
        }
        int n = this.model.getSelectedCalendars().size();
        if (this.dayCount >= 1 || n > 1) {
            this.rowCount = this.dayCount > 1 && n > 1 ? 2 : 1;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE d MMMM", Locale.getDefault());
            for (int i = 0; i < n; ++i) {
                Object object;
                Serializable serializable;
                JComponent jComponent;
                Calendar calendar2 = (Calendar)this.model.getSelectedCalendars().get(i);
                if (n >= 1) {
                    jComponent = new JLabel(calendar2.getSummary(), 0);
                    jComponent.addMouseListener(new CalHeaderMouseListener(calendar2.getId()));
                    jComponent.setCursor(new Cursor(12));
                    serializable = jComponent;
                    if (calendar2.isCloseable()) {
                        JPanel jPanel = new JPanel();
                        jPanel.setOpaque(false);
                        jPanel.setLayout(new BorderLayout());
                        jPanel.add((Component)jComponent, "Center");
                        object = new JLabel(new ResourceIcon("/bizcal/res/cancel.gif"));
                        ((Component)object).addMouseListener(new CloseListener(calendar2.getId()));
                        jPanel.add((Component)object, "East");
                        serializable = jPanel;
                    }
                    this.calHeaders.add(serializable);
                    this.panel.add((Component)serializable);
                }
                jComponent = new JPanel();
                jComponent.setLayout(new TrueGridLayout(1, this.dayCount));
                jComponent.setOpaque(false);
                serializable = this.model.getInterval().getStartDate();
                if (this.fixedDayCount > 0) {
                    serializable = DateUtil.round2Week(serializable);
                }
                for (int j = 0; j < this.dayCount; ++j) {
                    JLabel jLabel;
                    object = "";
                    object = this.dayCount == 1 ? TextUtil.formatCase(this.config.getDayFormat().format((Date)serializable)) : (this.isMonthView ? this.config.getMonthDateFormat().format((Date)serializable) : this.config.getWeekDateFormat().format((Date)serializable));
                    JLabel jLabel2 = new JLabel((String)object, 0);
                    jLabel2.setAlignmentY(2.0f);
                    jLabel2.setToolTipText(simpleDateFormat.format((Date)serializable));
                    jLabel2.setFont(headerFont);
                    if (this.model.isRedDay((Date)serializable)) {
                        jLabel2.setBackground(sundayColor);
                        jLabel2.setBorder(BorderFactory.createLineBorder(sundayColor.darker()));
                        jLabel2.setOpaque(true);
                    }
                    this.dateHeaders.add(jLabel2);
                    this.panel.add(jLabel2);
                    if (this.showExtraDateHeaders) {
                        jLabel = new JLabel(this.model.getDateHeader(calendar2.getId(), (Date)serializable), 0);
                        this.dateHeaders2.add(jLabel);
                        this.panel.add(jLabel);
                    }
                    this.dateList.add(serializable);
                    if (j > 0 || i > 0) {
                        jLabel = new JLabel();
                        jLabel.setBackground(this.lineColor);
                        jLabel.setOpaque(true);
                        jLabel.setBackground(this.lineColor);
                        if (DateUtil.getDayOfWeek(serializable) == calendar.getFirstDayOfWeek()) {
                            jLabel.setBackground(this.config.getLineColor2());
                        }
                        if (this.model.getSelectedCalendars().size() > 1 && j == 0) {
                            jLabel.setBackground(this.config.getLineColor3());
                        }
                        this.panel.add(jLabel);
                        this.dateLines.add(jLabel);
                    }
                    serializable = DateUtil.getDiffDay(serializable, 1);
                }
            }
        } else {
            this.rowCount = 0;
        }
        if (this.showExtraDateHeaders) {
            ++this.rowCount;
        }
        this.panel.add(this.gradientArea);
        this.panel.updateUI();
    }

    public JComponent getComponent() {
        return this.panel;
    }

    private void resizeDates(int n) throws Exception {
        Date date = DateUtil.round2Day(new Date());
        int n2 = 12;
        FontMetrics fontMetrics = this.referenceLabel.getFontMetrics(this.referenceLabel.getFont());
        if (this.maxWidth(n2, fontMetrics) > n && this.maxWidth(n2 = 3, fontMetrics) > n && this.maxWidth(n2 = 2, fontMetrics) > n) {
            n2 = 1;
        }
        for (int i = 0; i < this.dateHeaders.size(); ++i) {
            JLabel jLabel = (JLabel)this.dateHeaders.get(i);
            Date date2 = (Date)this.dateList.get(i);
            String string = "";
            string = this.isMonthView ? this.config.getMonthDateFormat().format(date2) : this.config.getWeekDateFormat().format(date2);
            if (string.length() > n2) {
                string = string.substring(0, n2);
            }
            string = TextUtil.formatCase(string);
            if (date.equals(DateUtil.round2Day(date2))) {
                string = "<html><b>" + string + "</b> </html>";
                jLabel.setBackground(todayColor);
                jLabel.setBorder(BorderFactory.createLineBorder(todayColor.darker()));
                jLabel.setOpaque(true);
            }
            jLabel.setText(string);
        }
    }

    private int maxWidth(int n, FontMetrics fontMetrics) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEEE", Locale.getDefault());
        java.util.Calendar calendar = DateUtil.newCalendar();
        calendar.set(7, 1);
        int n2 = 0;
        for (int i = 0; i < 7; ++i) {
            int n3;
            String string = simpleDateFormat.format(calendar.getTime());
            if (string.length() > n) {
                string = string.substring(0, n);
            }
            if ((n3 = fontMetrics.stringWidth(string)) > n2) {
                n2 = n3;
            }
            calendar.add(7, 1);
        }
        return n2;
    }

    public void setModel(CalendarModel calendarModel) {
        this.model = calendarModel;
    }

    public void setPopupMenuCallback(PopupMenuCallback popupMenuCallback) {
        this.popupMenuCallback = popupMenuCallback;
    }

    public void addCalendarListener(CalendarListener calendarListener) {
        this.listener = calendarListener;
    }

    public void setShowExtraDateHeaders(boolean bl) {
        this.showExtraDateHeaders = bl;
    }

    public boolean isMonthView() {
        return this.isMonthView;
    }

    public void setMonthView(boolean bl) {
        this.isMonthView = bl;
    }

    private class CloseListener
    extends MouseAdapter {
        private Object calId;

        public CloseListener(Object object) {
            this.calId = object;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                ColumnHeaderPanel.this.listener.closeCalendar(this.calId);
            }
            catch (Exception exception) {
                ErrorHandler.handleError(exception);
            }
        }
    }

    private class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            try {
                int n = ((ColumnHeaderPanel)ColumnHeaderPanel.this).referenceLabel.getPreferredSize().height;
                n = ColumnHeaderPanel.this.rowCount * n;
                int n2 = 1;
                if (ColumnHeaderPanel.this.model != null && ColumnHeaderPanel.this.model.getSelectedCalendars() != null) {
                    n2 = ColumnHeaderPanel.this.model.getSelectedCalendars().size();
                }
                int n3 = ColumnHeaderPanel.this.dayCount * n2 * 10;
                return new Dimension(n3, n);
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(50, 100);
        }

        @Override
        public void layoutContainer(Container container) {
            try {
                if (ColumnHeaderPanel.this.rowCount == 0) {
                    return;
                }
                double d = container.getWidth();
                double d2 = d / (double)ColumnHeaderPanel.this.dateHeaders.size();
                double d3 = d / (double)ColumnHeaderPanel.this.calHeaders.size();
                double d4 = container.getHeight() / ColumnHeaderPanel.this.rowCount;
                double d5 = 0.0;
                if (ColumnHeaderPanel.this.calHeaders.size() > 0) {
                    d5 = d4;
                }
                int n = 0;
                int n2 = 0;
                int n3 = ColumnHeaderPanel.this.showExtraDateHeaders ? 2 : 1;
                for (int i = 0; i < ColumnHeaderPanel.this.model.getSelectedCalendars().size(); ++i) {
                    if (ColumnHeaderPanel.this.calHeaders.size() > 0) {
                        JComponent jComponent = (JComponent)ColumnHeaderPanel.this.calHeaders.get(i);
                        jComponent.setBounds((int)((double)i * d3), 0, (int)d3, (int)d4);
                    }
                    if (ColumnHeaderPanel.this.dayCount < 1) continue;
                    for (int j = 0; j < ColumnHeaderPanel.this.dayCount; ++j) {
                        JLabel jLabel = (JLabel)ColumnHeaderPanel.this.dateHeaders.get(n);
                        int n4 = (int)((double)n * d2);
                        jLabel.setBounds(n4, (int)d5, (int)d2, (int)d4);
                        if (ColumnHeaderPanel.this.showExtraDateHeaders) {
                            jLabel = (JLabel)ColumnHeaderPanel.this.dateHeaders2.get(n);
                            jLabel.setBounds(n4, (int)(d5 + d4), (int)d2, (int)d4);
                        }
                        if (j > 0 || i > 0) {
                            JLabel jLabel2 = (JLabel)ColumnHeaderPanel.this.dateLines.get(n2);
                            int n5 = (int)d5;
                            int n6 = (int)d4 * n3;
                            if (j == 0) {
                                n5 = 0;
                                n6 = (int)(d4 * (double)(n3 + 1));
                            }
                            jLabel2.setBounds(n4, n5, 1, n6);
                            ++n2;
                        }
                        ++n;
                    }
                }
                ColumnHeaderPanel.this.gradientArea.setBounds(0, 0, container.getWidth(), container.getHeight());
                ColumnHeaderPanel.this.resizeDates((int)d2);
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }
    }

    protected class CalHeaderMouseListener
    extends MouseAdapter {
        private Object calId;

        public CalHeaderMouseListener(Object object) {
            this.calId = object;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            try {
                if (mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = ColumnHeaderPanel.this.popupMenuCallback.getCalendarPopupMenu(this.calId);
                    if (jPopupMenu == null) {
                        return;
                    }
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

