/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.Calendar;
import bizcal.common.CalendarViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarView;
import bizcal.util.DateUtil;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class TabularView
extends CalendarView {
    private static final Logger LOGGER = LoggerFactory.getLogger(TabularView.class);
    private static final I18n I18N = I18nFactory.getI18n(TabularView.class);
    private JTable table = new JTable();
    private JScrollPane scroll = new JScrollPane(this.table);

    public TabularView(CalendarViewConfig calendarViewConfig) throws Exception {
        super(calendarViewConfig);
    }

    @Override
    public JComponent getComponent() {
        return this.scroll;
    }

    public long getTimeInterval() throws Exception {
        return 0L;
    }

    @Override
    public void refresh0() throws Exception {
        Object object2;
        DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.getDefault());
        DateFormat dateFormat2 = DateFormat.getTimeInstance(3, Locale.getDefault());
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn(I18N.tr("date"));
        HashMap<Object, Map<Date, List<Event>>> hashMap = new HashMap<Object, Map<Date, List<Event>>>();
        for (Object object2 : this.getSelectedCalendars()) {
            defaultTableModel.addColumn(((Calendar)object2).getSummary());
            hashMap.put(((Calendar)object2).getId(), this.createEventsPerDay(((Calendar)object2).getId()));
        }
        object2 = this.getInterval().getStartDate();
        while (((Date)object2).before(this.getInterval().getEndDate())) {
            Vector<CharSequence> vector = new Vector<CharSequence>();
            vector.add(dateFormat.format((Date)object2));
            for (Calendar calendar : this.getSelectedCalendars()) {
                Map map = (Map)hashMap.get(calendar.getId());
                List list = (List)map.get(object2);
                StringBuffer stringBuffer = new StringBuffer();
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Event event = (Event)iterator.next();
                        stringBuffer.append(dateFormat2.format(event.getStart()) + "-");
                        stringBuffer.append(dateFormat2.format(event.getEnd()));
                        if (!iterator.hasNext()) continue;
                        stringBuffer.append(", ");
                    }
                }
                vector.add(stringBuffer);
            }
            defaultTableModel.addRow(vector);
            object2 = DateUtil.getDiffDay((Date)object2, 1);
        }
        this.table.setModel(defaultTableModel);
        defaultTableModel.fireTableDataChanged();
        this.setColumnWidths();
    }

    private void setColumnWidths() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (i == 0) {
                tableColumn.setWidth(50);
                continue;
            }
            tableColumn.setWidth(100);
        }
    }

    @Override
    public Date getDate(int n, int n2) {
        return null;
    }
}

