/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.CalendarViewConfig;
import bizcal.swing.ColumnHeaderPanel;
import bizcal.swing.DayView;
import bizcal.swing.util.GradientArea;
import bizcal.util.TimeOfDay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeLabelPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeLabelPanel.class);
    private JPanel panel;
    private List<JLabel> hourLabels = new ArrayList<JLabel>();
    private List<JLabel> minuteLabels = new ArrayList<JLabel>();
    private List<JLabel> hourLines = new ArrayList<JLabel>();
    private List<JLabel> minuteLines = new ArrayList<JLabel>();
    private Font font = new Font("Verdana", 0, 11);
    private GradientArea gradientArea;
    private int width = 40;
    private int hourCount;
    private int footerHeight = 0;
    private CalendarViewConfig config;
    private TimeOfDay start;
    private TimeOfDay end;
    private SimpleDateFormat hourFormat;
    private Font hourFont;
    private int timeslots;

    public TimeLabelPanel(CalendarViewConfig calendarViewConfig, TimeOfDay timeOfDay, TimeOfDay timeOfDay2, int n) throws Exception {
        this.config = calendarViewConfig;
        this.start = timeOfDay;
        this.end = timeOfDay2;
        this.timeslots = n;
        this.panel = new JPanel();
        this.panel.setLayout(new Layout());
        this.hourFormat = new SimpleDateFormat("HH");
        this.hourFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.hourFont = this.font.deriveFont(12.0f);
        this.hourFont = this.hourFont.deriveFont(1);
        this.refresh();
    }

    public void refresh() {
        try {
            this.hourCount = Math.abs(this.end.getHour() - this.start.getHour());
            if (this.hourCount == 0) {
                this.hourCount = 24;
            }
            this.hourLabels.clear();
            this.minuteLabels.clear();
            this.hourLines.clear();
            this.minuteLines.clear();
            this.panel.removeAll();
            block9: for (long i = this.start.getValue(); i < this.end.getValue(); i += 3600000L) {
                Date date = new Date(i);
                String string = this.hourFormat.format(date);
                JLabel jLabel = new JLabel(string);
                jLabel.setVerticalTextPosition(0);
                jLabel.setFont(this.hourFont);
                this.panel.add(jLabel);
                this.hourLabels.add(jLabel);
                JLabel jLabel2 = new JLabel();
                jLabel2.setBackground(this.config.getLineColor());
                jLabel2.setOpaque(true);
                this.panel.add(jLabel2);
                this.hourLines.add(jLabel2);
                switch (this.timeslots) {
                    case 1: {
                        continue block9;
                    }
                    case 2: {
                        this.createTimeLabel("30");
                        this.createMinuteLine();
                        continue block9;
                    }
                    case 3: {
                        this.createTimeLabel("20");
                        this.createTimeLabel("40");
                        this.createMinuteLine();
                        this.createMinuteLine();
                        continue block9;
                    }
                    case 4: {
                        this.createTimeLabel("30");
                        this.createMinuteLine();
                        this.createMinuteLine();
                        this.createMinuteLine();
                        continue block9;
                    }
                    case 6: {
                        this.createTimeLabel("20");
                        this.createTimeLabel("40");
                        this.createMinuteLine();
                        this.createMinuteLine();
                        this.createMinuteLine();
                        this.createMinuteLine();
                        this.createMinuteLine();
                        continue block9;
                    }
                }
            }
            this.gradientArea = new GradientArea("LEFT_RIGHT", Color.WHITE, ColumnHeaderPanel.GRADIENT_COLOR);
            this.gradientArea.setOpaque(true);
            this.gradientArea.setBorder(false);
            this.panel.add(this.gradientArea);
            this.panel.validate();
            this.panel.updateUI();
        }
        catch (Exception exception) {
            LOGGER.error("Can't refresh component.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private JLabel createTimeLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(this.font);
        this.panel.add(jLabel);
        this.minuteLabels.add(jLabel);
        return jLabel;
    }

    private void createMinuteLine() {
        JLabel jLabel = new JLabel();
        jLabel.setBackground(this.config.getLineColor());
        jLabel.setOpaque(true);
        this.minuteLines.add(jLabel);
        this.panel.add(jLabel);
    }

    public void setStartEnd(TimeOfDay timeOfDay, TimeOfDay timeOfDay2, int n) {
        this.start = timeOfDay;
        this.end = timeOfDay2;
        this.timeslots = n;
        this.refresh();
    }

    private int getPreferredHeight() {
        return DayView.PIXELS_PER_HOUR * this.hourCount + this.footerHeight;
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void setFooterHeight(int n) {
        this.footerHeight = n;
    }

    private class Layout
    implements LayoutManager {
        private int colWidth;
        private double rowHeight;

        private Layout() {
            this.colWidth = TimeLabelPanel.this.width / 2;
            this.rowHeight = 0.0;
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(TimeLabelPanel.this.width, TimeLabelPanel.this.getPreferredHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(50, 50);
        }

        @Override
        public void layoutContainer(Container container) {
            try {
                double d = container.getHeight() - TimeLabelPanel.this.footerHeight;
                this.rowHeight = d / (double)TimeLabelPanel.this.hourCount;
                double d2 = this.rowHeight / 2.0;
                this.colWidth = TimeLabelPanel.this.width / 2;
                Integer n = 0;
                int n2 = 0;
                block9: for (int i = 0; i < TimeLabelPanel.this.hourLabels.size(); ++i) {
                    JLabel jLabel = (JLabel)TimeLabelPanel.this.hourLabels.get(i);
                    jLabel.setBounds(0, (int)((double)i * this.rowHeight) - 7, this.colWidth, 15);
                    JLabel jLabel2 = (JLabel)TimeLabelPanel.this.hourLines.get(i);
                    jLabel2.setBounds(this.colWidth, (int)((double)(i + 1) * this.rowHeight), TimeLabelPanel.this.width, 1);
                    switch (TimeLabelPanel.this.timeslots) {
                        case 1: {
                            continue block9;
                        }
                        case 2: {
                            n = this.layoutMinuteLabel(i, n);
                            n2 = this.layoutMinuteLine(i, n2);
                            continue block9;
                        }
                        case 3: {
                            n = this.layoutMinuteLabel(i, n, (int)(this.rowHeight / 6.0), (int)(this.rowHeight / 6.0 * 2.0));
                            n = this.layoutMinuteLabel(i, n, (int)(this.rowHeight / 6.0 * 3.0), (int)(this.rowHeight / 6.0 * 2.0));
                            n2 = this.layoutMinuteLine(i, n2, (int)(this.rowHeight / 3.0), 10);
                            n2 = this.layoutMinuteLine(i, n2, (int)(this.rowHeight / 3.0 * 2.0), 10);
                            continue block9;
                        }
                        case 4: {
                            n = this.layoutMinuteLabel(i, n);
                            n2 = this.layoutMinuteLine(i, n2, (int)(this.rowHeight / 4.0), 10);
                            n2 = this.layoutMinuteLine(i, n2);
                            n2 = this.layoutMinuteLine(i, n2, (int)(this.rowHeight / 4.0 * 3.0), 10);
                            continue block9;
                        }
                        case 6: {
                            n = this.layoutMinuteLabel(i, n, (int)(this.rowHeight / 6.0), (int)(this.rowHeight / 6.0 * 2.0));
                            n = this.layoutMinuteLabel(i, n, (int)(this.rowHeight / 6.0 * 3.0), (int)(this.rowHeight / 6.0 * 2.0));
                            n2 = this.layoutMinuteLine(i, n2, (int)(this.rowHeight / 6.0), 10);
                            n2 = this.layoutMinuteLine(i, n2, (int)(this.rowHeight / 6.0 * 2.0), 5);
                            n2 = this.layoutMinuteLine(i, n2, (int)(this.rowHeight / 6.0 * 3.0), 10);
                            n2 = this.layoutMinuteLine(i, n2, (int)(this.rowHeight / 6.0 * 4.0), 5);
                            n2 = this.layoutMinuteLine(i, n2, (int)(this.rowHeight / 6.0 * 5.0), 10);
                            continue block9;
                        }
                    }
                }
                TimeLabelPanel.this.gradientArea.setBounds(0, 0, container.getWidth(), container.getHeight());
            }
            catch (Exception exception) {
                LOGGER.error("Can't layout component.");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }

        private int layoutMinuteLabel(int n, int n2) {
            return this.layoutMinuteLabel(n, n2, 0, (int)this.rowHeight);
        }

        private int layoutMinuteLabel(int n, int n2, int n3, int n4) {
            JLabel jLabel = (JLabel)TimeLabelPanel.this.minuteLabels.get(n2);
            jLabel.setBounds(this.colWidth - 15, (int)((double)n * this.rowHeight) + n3, this.colWidth, n4);
            return ++n2;
        }

        private int layoutMinuteLine(int n, int n2) {
            return this.layoutMinuteLine(n, n2, (int)(this.rowHeight / 2.0), 5);
        }

        private int layoutMinuteLine(int n, int n2, int n3, int n4) {
            JLabel jLabel = (JLabel)TimeLabelPanel.this.minuteLines.get(n2);
            jLabel.setBounds(this.colWidth + n4, (int)((double)n * this.rowHeight + (double)n3), this.colWidth, 1);
            return ++n2;
        }
    }
}

