/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.atlanticbb.tantlinger.ui.text.TextEditPopupManager;
import net.atlanticbb.tantlinger.ui.text.dialogs.HTMLAttributeEditorPanel;

public class LinkAttributesPanel
extends HTMLAttributeEditorPanel {
    private static final long serialVersionUID = 1L;
    private static final String NEW_WIN = i18n.str("new_window");
    private static final String SAME_WIN = i18n.str("same_window");
    private static final String SAME_FRAME = i18n.str("same_frame");
    private static final String[] TARGET_LABELS = new String[]{NEW_WIN, SAME_WIN, SAME_FRAME};
    private static final String[] TARGETS = new String[]{"_blank", "_top", "_self"};
    private JCheckBox nameCB = null;
    private JCheckBox titleCB = null;
    private JCheckBox openInCB = null;
    private JTextField nameField = null;
    private JTextField titleField = null;
    private JComboBox openInCombo = null;
    private JPanel spacerPanel = null;

    public LinkAttributesPanel() {
        this.initialize();
        this.updateComponentsFromAttribs();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.nameCB.setEnabled(bl);
        this.titleCB.setEnabled(bl);
        this.openInCB.setEnabled(bl);
        this.nameField.setEditable(this.nameCB.isSelected() && bl);
        this.titleField.setEditable(this.titleCB.isSelected() && bl);
        this.openInCombo.setEnabled(this.openInCB.isSelected() && bl);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 3;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridx = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridx = 1;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints5.gridy = 2;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints6.gridy = 1;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints7.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(320, 118));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, i18n.str("attributes"), 0, 0, null, null), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.add((Component)this.getNameCB(), gridBagConstraints7);
        this.add((Component)this.getTitleCB(), gridBagConstraints6);
        this.add((Component)this.getOpenInCB(), gridBagConstraints5);
        this.add((Component)this.getNameField(), gridBagConstraints4);
        this.add((Component)this.getTitleField(), gridBagConstraints3);
        this.add((Component)this.getOpenInCombo(), gridBagConstraints2);
        this.add((Component)this.getSpacerPanel(), gridBagConstraints);
        TextEditPopupManager.getInstance().registerJTextComponent(this.nameField);
        TextEditPopupManager.getInstance().registerJTextComponent(this.titleField);
    }

    @Override
    public void updateComponentsFromAttribs() {
        boolean bl;
        if (this.attribs.containsKey("name")) {
            this.nameCB.setSelected(true);
            this.nameField.setEditable(true);
            this.nameField.setText(this.attribs.get("name").toString());
        } else {
            this.nameCB.setSelected(false);
            this.nameField.setEditable(false);
        }
        if (this.attribs.containsKey("title")) {
            this.titleCB.setSelected(true);
            this.titleField.setEditable(true);
            this.titleField.setText(this.attribs.get("title").toString());
        } else {
            this.titleCB.setSelected(false);
            this.titleField.setEditable(false);
        }
        if (this.attribs.containsKey("target")) {
            this.openInCB.setSelected(true);
            String string = this.attribs.get("target").toString();
            this.openInCombo.setEnabled(true);
            for (bl = false; bl < TARGETS.length; bl += 1) {
                if (!string.equals(TARGETS[bl])) continue;
                this.openInCombo.setSelectedIndex(bl ? 1 : 0);
                break;
            }
        } else {
            this.openInCB.setSelected(false);
            this.openInCombo.setEnabled(false);
        }
        boolean bl2 = !this.hiddenAttribs.contains("target");
        bl = !this.hiddenAttribs.contains("title");
        boolean bl3 = !this.hiddenAttribs.contains("name");
        this.openInCB.setVisible(bl2);
        this.openInCombo.setVisible(bl2);
        this.titleCB.setVisible(bl);
        this.titleField.setVisible(bl);
        this.nameCB.setVisible(bl3);
        this.nameField.setVisible(bl3);
        this.setVisible(bl2 || bl || bl3);
    }

    @Override
    public void updateAttribsFromComponents() {
        if (!this.hiddenAttribs.contains("target")) {
            if (this.openInCB.isSelected()) {
                this.attribs.put("target", TARGETS[this.openInCombo.getSelectedIndex()]);
            } else {
                this.attribs.remove("target");
            }
        }
        if (!this.hiddenAttribs.contains("title")) {
            if (this.titleCB.isSelected()) {
                this.attribs.put("title", this.titleField.getText());
            } else {
                this.attribs.remove("title");
            }
        }
        if (!this.hiddenAttribs.contains("name")) {
            if (this.nameCB.isSelected()) {
                this.attribs.put("name", this.nameField.getText());
            } else {
                this.attribs.remove("name");
            }
        }
    }

    private JCheckBox getNameCB() {
        if (this.nameCB == null) {
            this.nameCB = new JCheckBox();
            this.nameCB.setText(i18n.str("name"));
            this.nameCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    LinkAttributesPanel.this.nameField.setEditable(LinkAttributesPanel.this.nameCB.isSelected());
                }
            });
        }
        return this.nameCB;
    }

    private JCheckBox getTitleCB() {
        if (this.titleCB == null) {
            this.titleCB = new JCheckBox();
            this.titleCB.setText(i18n.str("title"));
            this.titleCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    LinkAttributesPanel.this.titleField.setEditable(LinkAttributesPanel.this.titleCB.isSelected());
                }
            });
        }
        return this.titleCB;
    }

    private JCheckBox getOpenInCB() {
        if (this.openInCB == null) {
            this.openInCB = new JCheckBox();
            this.openInCB.setText(i18n.str("open_in"));
            this.openInCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    LinkAttributesPanel.this.openInCombo.setEnabled(LinkAttributesPanel.this.openInCB.isSelected());
                }
            });
        }
        return this.openInCB;
    }

    private JTextField getNameField() {
        if (this.nameField == null) {
            this.nameField = new JTextField();
        }
        return this.nameField;
    }

    private JTextField getTitleField() {
        if (this.titleField == null) {
            this.titleField = new JTextField();
        }
        return this.titleField;
    }

    private JComboBox getOpenInCombo() {
        if (this.openInCombo == null) {
            this.openInCombo = new JComboBox<String>(TARGET_LABELS);
        }
        return this.openInCombo;
    }

    private JPanel getSpacerPanel() {
        if (this.spacerPanel == null) {
            this.spacerPanel = new JPanel();
        }
        return this.spacerPanel;
    }
}

