/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.PersonAddressImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompanyAddressImpl
extends PersonAddressImpl {
    private static final long serialVersionUID = -7484011413736955936L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CompanyAddressImpl.class);
    public static final String XML_ATTRIB_COMPANY_NAME = "CompanyName";
    public static final String XML_ATTRIB_COMPANY_NAME_ADDITION = "CompanyNameAddition";
    public static final String XML_ATTRIB_COMPANY_LEGAL_FORM = "CompanyLegalForm";
    public static final String XML_ATTRIB_COMPANY_DEPARTMENT = "CompanyDepartment";
    public static final String XML_ATTRIB_COMPANY_BUSINESS = "CompanyBusiness";
    public static final String XML_ATTRIB_COMPANY_POSITION = "CompanyPosition";
    public static final String XML_ATTRIB_COMPANY_WEBSITE = "CompanyWebsite";
    public static final String XML_ATTRIB_COMPANY_MAIL = "CompanyMail";
    public static final String XML_ATTRIB_COMPANY_PHONE = "CompanyPhone";
    public static final String XML_ATTRIB_COMPANY_MOBILE_PHONE = "CompanyMobilePhone";
    public static final String XML_ATTRIB_COMPANY_FAX = "CompanyFax";
    private static final String OLD_XML_ATTRIB_COMPANY_TYPE = "CompanyType";
    public static final String COMPANYADDRESS_XML_ELEMENT = "CompanyAddress";
    private static final String OLD_COMPANYADRESS_XML_ELEMENT = "CompanyAdress";

    public String getCompanyBusiness() {
        return (String)this.getValue(XML_ATTRIB_COMPANY_BUSINESS);
    }

    public String getCompanyDepartment() {
        return (String)this.getValue(XML_ATTRIB_COMPANY_DEPARTMENT);
    }

    public String getCompanyFax() {
        return (String)this.getValue(XML_ATTRIB_COMPANY_FAX);
    }

    public String getCompanyLegalForm() {
        return (String)this.getValue(XML_ATTRIB_COMPANY_LEGAL_FORM);
    }

    public String getCompanyMail() {
        return (String)this.getValue(XML_ATTRIB_COMPANY_MAIL);
    }

    public String getCompanyMobilePhone() {
        return (String)this.getValue(XML_ATTRIB_COMPANY_MOBILE_PHONE);
    }

    public String getCompanyName() {
        return (String)this.getValue(XML_ATTRIB_COMPANY_NAME);
    }

    public String getCompanyNameAddition() {
        return (String)this.getValue(XML_ATTRIB_COMPANY_NAME_ADDITION);
    }

    public String getCompanyPhone() {
        return (String)this.getValue(XML_ATTRIB_COMPANY_PHONE);
    }

    public String getCompanyPosition() {
        return (String)this.getValue(XML_ATTRIB_COMPANY_POSITION);
    }

    @Deprecated
    public String getCompanyType() {
        return this.getCompanyLegalForm();
    }

    public URI getCompanyWebsite() {
        return (URI)this.getValue(XML_ATTRIB_COMPANY_WEBSITE);
    }

    public static boolean isCompanyRootElement(Element element) {
        if (element == null) {
            return false;
        }
        String string = element.getName();
        return COMPANYADDRESS_XML_ELEMENT.equals(string) || OLD_COMPANYADRESS_XML_ELEMENT.equals(string);
    }

    public static CompanyAddressImpl parseCompanyAddress(Document document) throws DocumentException {
        CompanyAddressImpl companyAddressImpl = new CompanyAddressImpl();
        companyAddressImpl.readFromXml(document);
        return companyAddressImpl;
    }

    @Override
    public void readFromMap(Map<String, String> map, String string) {
        super.readFromMap(map, string);
        String string2 = string != null && string.length() > 0 ? string + "company." : "company.";
        this.setCompanyBusiness(map.get(string2 + "business"));
        this.setCompanyDepartment(map.get(string2 + "department"));
        this.setCompanyFax(map.get(string2 + "fax"));
        this.setCompanyLegalForm(map.get(string2 + "legalForm"));
        this.setCompanyMail(map.get(string2 + "mail"));
        this.setCompanyMobilePhone(map.get(string2 + "mobilePhone"));
        this.setCompanyName(map.get(string2 + "name"));
        this.setCompanyNameAddition(map.get(string2 + "nameAddition"));
        this.setCompanyPhone(map.get(string2 + "phone"));
        this.setCompanyPosition(map.get(string2 + "position"));
        String string3 = StringUtils.trimToNull((String)map.get(string2 + "website"));
        if (string3 != null && StringUtils.isNotBlank((CharSequence)StringUtils.substringAfter((String)string3, (String)":"))) {
            try {
                this.setCompanyWebsite(new URI(string3));
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Can't read company website (" + string3 + ")!");
                LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                this.setCompanyWebsite(null);
            }
        }
    }

    @Override
    public void readFromXml(Document document) throws DocumentException {
        Element element = (Element)document.selectSingleNode(COMPANYADDRESS_XML_ELEMENT);
        if (element == null) {
            element = (Element)document.selectSingleNode(OLD_COMPANYADRESS_XML_ELEMENT);
        }
        this.readFromXml(element);
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        super.readFromXml(element);
        this.setCompanyBusiness(CompanyAddressImpl.selectAttribute(element, XML_ATTRIB_COMPANY_BUSINESS));
        this.setCompanyDepartment(CompanyAddressImpl.selectAttribute(element, XML_ATTRIB_COMPANY_DEPARTMENT));
        this.setCompanyFax(CompanyAddressImpl.selectAttribute(element, XML_ATTRIB_COMPANY_FAX));
        this.setCompanyMail(CompanyAddressImpl.selectAttribute(element, XML_ATTRIB_COMPANY_MAIL));
        this.setCompanyMobilePhone(CompanyAddressImpl.selectAttribute(element, XML_ATTRIB_COMPANY_MOBILE_PHONE));
        this.setCompanyName(CompanyAddressImpl.selectAttribute(element, XML_ATTRIB_COMPANY_NAME));
        this.setCompanyNameAddition(CompanyAddressImpl.selectAttribute(element, XML_ATTRIB_COMPANY_NAME_ADDITION));
        this.setCompanyPhone(CompanyAddressImpl.selectAttribute(element, XML_ATTRIB_COMPANY_PHONE));
        this.setCompanyPosition(CompanyAddressImpl.selectAttribute(element, XML_ATTRIB_COMPANY_POSITION));
        this.setCompanyWebsite(CompanyAddressImpl.selectAttributeAsURI(element, XML_ATTRIB_COMPANY_WEBSITE));
        String string = CompanyAddressImpl.selectAttribute(element, XML_ATTRIB_COMPANY_LEGAL_FORM);
        if (string == null) {
            string = CompanyAddressImpl.selectAttribute(element, OLD_XML_ATTRIB_COMPANY_TYPE);
        }
        this.setCompanyLegalForm(string);
    }

    @Override
    public void serializeToMap(Map<String, String> map, String string) {
        String string2;
        super.serializeToMap(map, string);
        String string3 = string2 = string != null && string.length() > 0 ? string + "company." : "company.";
        if (this.getCompanyBusiness() != null) {
            map.put(string2 + "business", this.getCompanyBusiness());
        }
        if (this.getCompanyDepartment() != null) {
            map.put(string2 + "department", this.getCompanyDepartment());
        }
        if (this.getCompanyFax() != null) {
            map.put(string2 + "fax", this.getCompanyFax());
        }
        if (this.getCompanyLegalForm() != null) {
            map.put(string2 + "legalForm", this.getCompanyLegalForm());
        }
        if (this.getCompanyMail() != null) {
            map.put(string2 + "mail", this.getCompanyMail());
        }
        if (this.getCompanyMobilePhone() != null) {
            map.put(string2 + "mobilePhone", this.getCompanyMobilePhone());
        }
        if (this.getCompanyName() != null) {
            map.put(string2 + "name", this.getCompanyName());
        }
        if (this.getCompanyNameAddition() != null) {
            map.put(string2 + "nameAddition", this.getCompanyNameAddition());
        }
        if (this.getCompanyPhone() != null) {
            map.put(string2 + "phone", this.getCompanyPhone());
        }
        if (this.getCompanyPosition() != null) {
            map.put(string2 + "position", this.getCompanyPosition());
        }
        if (this.getCompanyWebsite() != null) {
            map.put(string2 + "website", this.getCompanyWebsite().toString());
        }
    }

    @Override
    public void serializeToXml(Document document) throws DocumentException {
        Element element = DocumentFactory.getInstance().createElement(COMPANYADDRESS_XML_ELEMENT, "http://www.openestate.org/1.0/");
        this.serializeToXml(element);
        document.add(element);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        super.serializeToXml(element);
        if (this.getCompanyBusiness() != null) {
            element.addAttribute(XML_ATTRIB_COMPANY_BUSINESS, this.getCompanyBusiness());
        }
        if (this.getCompanyDepartment() != null) {
            element.addAttribute(XML_ATTRIB_COMPANY_DEPARTMENT, this.getCompanyDepartment());
        }
        if (this.getCompanyFax() != null) {
            element.addAttribute(XML_ATTRIB_COMPANY_FAX, this.getCompanyFax());
        }
        if (this.getCompanyMail() != null) {
            element.addAttribute(XML_ATTRIB_COMPANY_MAIL, this.getCompanyMail());
        }
        if (this.getCompanyMobilePhone() != null) {
            element.addAttribute(XML_ATTRIB_COMPANY_MOBILE_PHONE, this.getCompanyMobilePhone());
        }
        if (this.getCompanyName() != null) {
            element.addAttribute(XML_ATTRIB_COMPANY_NAME, this.getCompanyName());
        }
        if (this.getCompanyNameAddition() != null) {
            element.addAttribute(XML_ATTRIB_COMPANY_NAME_ADDITION, this.getCompanyNameAddition());
        }
        if (this.getCompanyPhone() != null) {
            element.addAttribute(XML_ATTRIB_COMPANY_PHONE, this.getCompanyPhone());
        }
        if (this.getCompanyPosition() != null) {
            element.addAttribute(XML_ATTRIB_COMPANY_POSITION, this.getCompanyPosition());
        }
        if (this.getCompanyLegalForm() != null) {
            element.addAttribute(XML_ATTRIB_COMPANY_LEGAL_FORM, this.getCompanyLegalForm());
        }
        if (this.getCompanyWebsite() != null) {
            element.addAttribute(XML_ATTRIB_COMPANY_WEBSITE, this.getCompanyWebsite().toString());
        }
    }

    public void setCompanyBusiness(String string) {
        this.putValue(XML_ATTRIB_COMPANY_BUSINESS, string);
    }

    public void setCompanyDepartment(String string) {
        this.putValue(XML_ATTRIB_COMPANY_DEPARTMENT, string);
    }

    public void setCompanyFax(String string) {
        this.putValue(XML_ATTRIB_COMPANY_FAX, string);
    }

    public void setCompanyLegalForm(String string) {
        this.putValue(XML_ATTRIB_COMPANY_LEGAL_FORM, string);
    }

    public void setCompanyMail(String string) {
        this.putValue(XML_ATTRIB_COMPANY_MAIL, string);
    }

    public void setCompanyMobilePhone(String string) {
        this.putValue(XML_ATTRIB_COMPANY_MOBILE_PHONE, string);
    }

    public void setCompanyName(String string) {
        this.putValue(XML_ATTRIB_COMPANY_NAME, string);
    }

    public void setCompanyNameAddition(String string) {
        this.putValue(XML_ATTRIB_COMPANY_NAME_ADDITION, string);
    }

    public void setCompanyPhone(String string) {
        this.putValue(XML_ATTRIB_COMPANY_PHONE, string);
    }

    public void setCompanyPosition(String string) {
        this.putValue(XML_ATTRIB_COMPANY_POSITION, string);
    }

    @Deprecated
    public void setCompanyType(String string) {
        this.setCompanyLegalForm(string);
    }

    public void setCompanyWebsite(URI uRI) {
        this.putValue(XML_ATTRIB_COMPANY_WEBSITE, uRI);
    }
}

