/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlType;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EstateAttachmentImpl
extends AbstractImplItem
implements SerializableXmlType {
    private static final long serialVersionUID = 6606828386569065643L;
    private static final Logger LOGGER = LoggerFactory.getLogger(EstateAttachmentImpl.class);
    private static final Base64 BASE64 = new Base64();
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final String MIME_BMP = "image/bmp";
    public static final String MIME_GIF = "image/gif";
    public static final String MIME_JPG = "image/jpeg";
    public static final String MIME_PDF = "application/pdf";
    public static final String MIME_PNG = "image/png";
    private static final String XML_ATTRIB_MIME_TYPE = "MimeType";
    private static final String XML_ATTRIB_PUBLISHED = "Published";
    private static final String XML_ATTRIB_TYPE = "Type";
    private static final String XML_ATTRIB_HASH = "Hash";
    private static final String XML_ELEMENT_TITLE = "Title";
    private static final String XML_ELEMENT_TITLE_TEXT = "Text";
    private static final String XML_ELEMENT_TITLE_LANGUAGE = "Language";
    private static final String XML_ELEMENT_BASE64 = "Base64";
    private static final String XML_ELEMENT_NAME = "Name";
    private static final String XML_ELEMENT_URL = "URL";
    private final Map<String, String> titles = new HashMap<String, String>();

    public URI getAbsoluteUrl(String string) {
        if (this.isUrl()) {
            return this.getFileAsUrl();
        }
        if (this.isName()) {
            if (!(string = StringUtils.trimToNull((String)string)).endsWith("/")) {
                string = string + "/";
            }
            try {
                return new URI(string + FilenameUtils.separatorsToUnix((String)this.getFileAsName()));
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Can't build attachment URL!");
                LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                return null;
            }
        }
        return null;
    }

    public byte[] getFileAsBase64() {
        return (byte[])this.getValue(XML_ELEMENT_BASE64);
    }

    public String getFileAsName() {
        return (String)this.getValue(XML_ELEMENT_NAME);
    }

    public URI getFileAsUrl() {
        return (URI)this.getValue(XML_ELEMENT_URL);
    }

    public String getHash() {
        return (String)this.getValue(XML_ATTRIB_HASH);
    }

    public String getMimeType() {
        return (String)this.getValue(XML_ATTRIB_MIME_TYPE);
    }

    public String getTitle() {
        return this.getTitle(OpenEstateUtils.DEFAULT_LOCALE);
    }

    public String getTitle(Locale locale) {
        return this.getTitle(locale.getLanguage());
    }

    public String getTitle(String string) {
        if (string != null && this.titles.containsKey(string)) {
            return this.titles.get(string);
        }
        return null;
    }

    public String[] getTitleLanguages() {
        return this.titles.keySet().toArray(new String[0]);
    }

    public EstateAttachmentType getType() {
        String string = (String)this.getValue(XML_ATTRIB_TYPE);
        try {
            return string != null ? EstateAttachmentType.valueOf(string) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attachment type: " + string);
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public boolean isAudioType() {
        return StringUtils.startsWithIgnoreCase((CharSequence)StringUtils.trimToNull((String)this.getMimeType()), (CharSequence)"audio/");
    }

    public boolean isBase64() {
        return this.getValue(XML_ELEMENT_BASE64) != null;
    }

    public boolean isImageType() {
        return StringUtils.startsWithIgnoreCase((CharSequence)StringUtils.trimToNull((String)this.getMimeType()), (CharSequence)"image/");
    }

    public boolean isMimeType(String string) {
        return StringUtils.equalsIgnoreCase((CharSequence)StringUtils.trimToNull((String)string), (CharSequence)StringUtils.trimToNull((String)this.getMimeType()));
    }

    public boolean isName() {
        return this.getValue(XML_ELEMENT_NAME) != null;
    }

    public boolean isPublished() {
        Object object = this.getValue(XML_ATTRIB_PUBLISHED);
        return object == null || Boolean.TRUE.equals(object);
    }

    public boolean isTextType() {
        return StringUtils.startsWithIgnoreCase((CharSequence)StringUtils.trimToNull((String)this.getMimeType()), (CharSequence)"text/");
    }

    public boolean isUrl() {
        return this.getValue(XML_ELEMENT_URL) != null;
    }

    public boolean isVideoType() {
        return StringUtils.startsWithIgnoreCase((CharSequence)StringUtils.trimToNull((String)this.getMimeType()), (CharSequence)"video/");
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        this.setHash(EstateAttachmentImpl.selectAttribute(element, XML_ATTRIB_HASH));
        this.setMimeType(EstateAttachmentImpl.selectAttribute(element, XML_ATTRIB_MIME_TYPE));
        this.setPublished(EstateAttachmentImpl.selectAttributeAsBoolean(element, XML_ATTRIB_PUBLISHED));
        String string = EstateAttachmentImpl.selectAttribute(element, XML_ATTRIB_TYPE);
        try {
            this.setType(string != null ? EstateAttachmentType.valueOf(string) : null);
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attachment type: " + string);
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        for (Node node : EstateAttachmentImpl.selectChildElements(element)) {
            String string2 = StringUtils.trimToNull((String)node.getStringValue());
            if (XML_ELEMENT_TITLE.equals(node.getName()) && string2 != null) {
                for (Node node2 : EstateAttachmentImpl.selectChildElements((Element)node)) {
                    if (!XML_ELEMENT_TITLE_TEXT.equals(node2.getName())) continue;
                    String string3 = StringUtils.trimToNull((String)EstateAttachmentImpl.selectAttribute((Element)node2, XML_ELEMENT_TITLE_LANGUAGE));
                    String string4 = StringUtils.trimToNull((String)node2.getStringValue());
                    if (string3 == null || string3.length() != 2) continue;
                    if (string4 != null) {
                        this.setTitle(StringEscapeUtils.unescapeHtml4((String)string4), string3);
                        continue;
                    }
                    this.setTitle(null, string3);
                }
                continue;
            }
            if (XML_ELEMENT_BASE64.equals(node.getName()) && string2 != null) {
                try {
                    this.setFile(BASE64.decode(string2.getBytes(US_ASCII.name())));
                    continue;
                }
                catch (Exception exception) {
                    throw new DocumentException("could not encode base64: " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            if (XML_ELEMENT_NAME.equals(node.getName()) && string2 != null) {
                this.setFile(string2);
                continue;
            }
            if (!XML_ELEMENT_URL.equals(node.getName()) || string2 == null) continue;
            try {
                this.setFile(new URI(string2));
            }
            catch (URISyntaxException uRISyntaxException) {
                this.setFile((String)null);
                LOGGER.warn("invalid attachment-url!");
                LOGGER.warn("> " + string2);
                LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage());
            }
        }
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        String string;
        Object object;
        if (element == null) {
            return;
        }
        if (this.isBase64()) {
            object = BASE64.encode(this.getFileAsBase64());
            string = US_ASCII.decode(ByteBuffer.wrap((byte[])object)).toString();
            element.addElement(XML_ELEMENT_BASE64).setText(string);
        } else if (this.isName()) {
            element.addElement(XML_ELEMENT_NAME).setText(this.getFileAsName());
        } else if (this.isUrl()) {
            element.addElement(XML_ELEMENT_URL).setText(this.getFileAsUrl().toString());
        } else {
            LOGGER.warn("Unknown attachment-type: " + this.getFileAsName());
            return;
        }
        element.addAttribute(XML_ATTRIB_HASH, this.getHash());
        element.addAttribute(XML_ATTRIB_MIME_TYPE, this.getMimeType());
        element.addAttribute(XML_ATTRIB_PUBLISHED, String.valueOf(this.isPublished()));
        object = this.getType();
        if (object != null) {
            element.addAttribute(XML_ATTRIB_TYPE, ((Enum)object).name());
        }
        string = element.addElement(XML_ELEMENT_TITLE);
        for (Map.Entry<String, String> entry : this.titles.entrySet()) {
            String string2 = entry.getKey();
            String string3 = StringUtils.trimToNull((String)entry.getValue());
            Element element2 = string.addElement(XML_ELEMENT_TITLE_TEXT);
            element2.addAttribute(XML_ELEMENT_TITLE_LANGUAGE, string2);
            element2.setText(OpenEstateUtils.serializeString(StringEscapeUtils.unescapeHtml4((String)string3)));
        }
    }

    public void setFile(byte[] byArray) {
        this.putValue(XML_ELEMENT_NAME, null);
        this.putValue(XML_ELEMENT_URL, null);
        this.putValue(XML_ELEMENT_BASE64, byArray);
    }

    public void setFile(String string) {
        this.putValue(XML_ELEMENT_BASE64, null);
        this.putValue(XML_ELEMENT_URL, null);
        this.putValue(XML_ELEMENT_NAME, string);
    }

    public void setFile(URI uRI) {
        this.putValue(XML_ELEMENT_BASE64, null);
        this.putValue(XML_ELEMENT_NAME, null);
        this.putValue(XML_ELEMENT_URL, uRI);
    }

    public void setHash(String string) {
        this.putValue(XML_ATTRIB_HASH, string);
    }

    public void setMimeType(String string) {
        this.putValue(XML_ATTRIB_MIME_TYPE, string);
    }

    public void setPublished(Boolean bl) {
        this.putValue(XML_ATTRIB_PUBLISHED, bl != null ? bl : Boolean.TRUE);
    }

    public void setTitle(String string) {
        this.setTitle(string, OpenEstateUtils.DEFAULT_LOCALE);
    }

    public void setTitle(String string, Locale locale) {
        this.setTitle(string, locale.getLanguage());
    }

    public void setTitle(String string, String string2) {
        if ((string2 = StringUtils.trimToNull((String)string2)) == null || string2.length() != 2) {
            throw new IllegalArgumentException("Invalid language (" + string2 + ")!");
        }
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.titles.remove(string2);
        } else {
            this.titles.put(string2, string);
        }
    }

    public void setType(EstateAttachmentType estateAttachmentType) {
        if (estateAttachmentType == null) {
            this.putValue(XML_ATTRIB_TYPE, null);
        } else {
            this.putValue(XML_ATTRIB_TYPE, estateAttachmentType.name());
        }
    }
}

