/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.utils.Translatable;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public enum EstateAttachmentType implements Translatable
{
    IMAGE(I18n.marktr((String)"photo")),
    IMAGE_INNER_VIEW(I18n.marktr((String)"interior view")),
    IMAGE_OUTER_VIEW(I18n.marktr((String)"exterior view")),
    IMAGE_GROUNDPLAN(I18n.marktr((String)"floorplan")),
    IMAGE_MAP(I18n.marktr((String)"map")),
    IMAGE_PANORAMA(I18n.marktr((String)"panorama"));

    private static final Logger LOGGER;
    private final String i18nKey;

    private EstateAttachmentType(String string2) {
        this.i18nKey = string2;
    }

    @Override
    public final String getTranslation() {
        return this.getTranslation(null);
    }

    @Override
    public final String getTranslation(Locale locale) {
        return OpenEstateUtils.getI18nString(this.i18nKey, locale);
    }

    @Deprecated
    public String write() {
        return this.getTranslation();
    }

    @Deprecated
    public String write(Locale locale) {
        return this.getTranslation(locale);
    }

    static {
        LOGGER = LoggerFactory.getLogger(EstateAttachmentType.class);
    }
}

