/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AddressImpl;
import com.openindex.openestate.impl.Gender;
import com.openindex.openestate.impl.OpenEstateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonAddressImpl
extends AddressImpl {
    private static final long serialVersionUID = -1996125958119033045L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonAddressImpl.class);
    public static final String XML_ATTRIB_PERSON_FIRST_NAME = "PersonFirstName";
    public static final String XML_ATTRIB_PERSON_MIDDLE_NAME = "PersonMiddleName";
    public static final String XML_ATTRIB_PERSON_LAST_NAME = "PersonLastName";
    public static final String XML_ATTRIB_PERSON_TITLE = "PersonTitle";
    public static final String XML_ATTRIB_PERSON_GENDER = "PersonGender";
    public static final String XML_ATTRIB_PERSON_MAIL = "PersonMail";
    public static final String XML_ATTRIB_PERSON_PHONE = "PersonPhone";
    public static final String XML_ATTRIB_PERSON_MOBILE_PHONE = "PersonMobilePhone";
    public static final String XML_ATTRIB_PERSON_FAX = "PersonFax";
    public static final String XML_ATTRIB_PERSON_DATE_OF_BIRTH = "PersonDateOfBirth";
    public static final String PERSONADDRESS_XML_ELEMENT = "PersonAddress";
    private static final String OLD_PERSONADRESS_XML_ELEMENT = "PersonAdress";
    @Deprecated
    public static final String GENDER_FEMALE = Gender.FEMALE.name();
    @Deprecated
    public static final String GENDER_MALE = Gender.MALE.name();

    public Date getPersonDateOfBirth() {
        return (Date)this.getValue(XML_ATTRIB_PERSON_DATE_OF_BIRTH);
    }

    public String getPersonFax() {
        return (String)this.getValue(XML_ATTRIB_PERSON_FAX);
    }

    public String getPersonFirstName() {
        return (String)this.getValue(XML_ATTRIB_PERSON_FIRST_NAME);
    }

    public Gender getPersonGender() {
        String string = (String)this.getValue(XML_ATTRIB_PERSON_GENDER);
        if (string == null) {
            return null;
        }
        try {
            if ("herr".equalsIgnoreCase(string) || "male".equalsIgnoreCase(string)) {
                return Gender.MALE;
            }
            if ("frau".equalsIgnoreCase(string) || "female".equalsIgnoreCase(string)) {
                return Gender.FEMALE;
            }
            if (string.trim().length() > 0) {
                return Gender.valueOf(string);
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load gender: " + string);
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public String getPersonLastName() {
        return (String)this.getValue(XML_ATTRIB_PERSON_LAST_NAME);
    }

    public String getPersonMail() {
        return (String)this.getValue(XML_ATTRIB_PERSON_MAIL);
    }

    public String getPersonMiddleName() {
        return (String)this.getValue(XML_ATTRIB_PERSON_MIDDLE_NAME);
    }

    public String getPersonMobilePhone() {
        return (String)this.getValue(XML_ATTRIB_PERSON_MOBILE_PHONE);
    }

    public String getPersonPhone() {
        return (String)this.getValue(XML_ATTRIB_PERSON_PHONE);
    }

    public String getPersonTitle() {
        return (String)this.getValue(XML_ATTRIB_PERSON_TITLE);
    }

    public boolean isFemale() {
        return Gender.FEMALE.equals(this.getPersonGender());
    }

    public boolean isMale() {
        return Gender.MALE.equals(this.getPersonGender());
    }

    public static boolean isPersonRootElement(Element element) {
        if (element == null) {
            return false;
        }
        String string = element.getName();
        return PERSONADDRESS_XML_ELEMENT.equals(string) || OLD_PERSONADRESS_XML_ELEMENT.equals(string);
    }

    public static PersonAddressImpl parsePersonAddress(Document document) throws DocumentException {
        PersonAddressImpl personAddressImpl = new PersonAddressImpl();
        personAddressImpl.readFromXml(document);
        return personAddressImpl;
    }

    @Override
    public void readFromMap(Map<String, String> map, String string) {
        super.readFromMap(map, string);
        String string2 = string != null && string.length() > 0 ? string + "person." : "person.";
        this.setPersonFax(map.get(string2 + "fax"));
        this.setPersonFirstName(map.get(string2 + "firstName"));
        this.setPersonLastName(map.get(string2 + "lastName"));
        this.setPersonGender(map.get(string2 + "gender"));
        this.setPersonMail(map.get(string2 + "mail"));
        this.setPersonMiddleName(map.get(string2 + "middleName"));
        this.setPersonMobilePhone(map.get(string2 + "mobilePhone"));
        this.setPersonPhone(map.get(string2 + "phone"));
        this.setPersonTitle(map.get(string2 + "title"));
        if (map.containsKey(string2 + "dateOfBirth")) {
            try {
                this.setPersonDateOfBirth(OpenEstateUtils.getXsdDateFormat().parse(map.get(string2 + "dateOfBirth")));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read day of birth!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.setPersonDateOfBirth(null);
            }
        }
    }

    @Override
    public void readFromXml(Document document) throws DocumentException {
        Element element = (Element)document.selectSingleNode(PERSONADDRESS_XML_ELEMENT);
        if (element == null) {
            element = (Element)document.selectSingleNode(OLD_PERSONADRESS_XML_ELEMENT);
        }
        this.readFromXml(element);
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        super.readFromXml(element);
        this.setPersonDateOfBirth(PersonAddressImpl.selectAttributeAsDate(element, XML_ATTRIB_PERSON_DATE_OF_BIRTH));
        this.setPersonFax(PersonAddressImpl.selectAttribute(element, XML_ATTRIB_PERSON_FAX));
        this.setPersonFirstName(PersonAddressImpl.selectAttribute(element, XML_ATTRIB_PERSON_FIRST_NAME));
        this.setPersonGender(PersonAddressImpl.selectAttribute(element, XML_ATTRIB_PERSON_GENDER));
        this.setPersonLastName(PersonAddressImpl.selectAttribute(element, XML_ATTRIB_PERSON_LAST_NAME));
        this.setPersonMail(PersonAddressImpl.selectAttribute(element, XML_ATTRIB_PERSON_MAIL));
        this.setPersonMiddleName(PersonAddressImpl.selectAttribute(element, XML_ATTRIB_PERSON_MIDDLE_NAME));
        this.setPersonMobilePhone(PersonAddressImpl.selectAttribute(element, XML_ATTRIB_PERSON_MOBILE_PHONE));
        this.setPersonPhone(PersonAddressImpl.selectAttribute(element, XML_ATTRIB_PERSON_PHONE));
        this.setPersonTitle(PersonAddressImpl.selectAttribute(element, XML_ATTRIB_PERSON_TITLE));
    }

    @Override
    public void serializeToMap(Map<String, String> map, String string) {
        String string2;
        super.serializeToMap(map, string);
        String string3 = string2 = string != null && string.length() > 0 ? string + "person." : "person.";
        if (this.getPersonFax() != null) {
            map.put(string2 + "fax", this.getPersonFax());
        }
        if (this.getPersonFirstName() != null) {
            map.put(string2 + "firstName", this.getPersonFirstName());
        }
        if (this.getPersonGender() != null) {
            map.put(string2 + "gender", this.getPersonGender().name());
        }
        if (this.getPersonLastName() != null) {
            map.put(string2 + "lastName", this.getPersonLastName());
        }
        if (this.getPersonMail() != null) {
            map.put(string2 + "mail", this.getPersonMail());
        }
        if (this.getPersonMiddleName() != null) {
            map.put(string2 + "middleName", this.getPersonMiddleName());
        }
        if (this.getPersonMobilePhone() != null) {
            map.put(string2 + "mobilePhone", this.getPersonMobilePhone());
        }
        if (this.getPersonPhone() != null) {
            map.put(string2 + "phone", this.getPersonPhone());
        }
        if (this.getPersonTitle() != null) {
            map.put(string2 + "title", this.getPersonTitle());
        }
        if (this.getPersonDateOfBirth() != null) {
            map.put(string2 + "dateOfBirth", OpenEstateUtils.getXsdDateFormat().format(this.getPersonDateOfBirth()));
        }
    }

    @Override
    public void serializeToXml(Document document) throws DocumentException {
        Element element = DocumentFactory.getInstance().createElement(PERSONADDRESS_XML_ELEMENT, "http://www.openestate.org/1.0/");
        this.serializeToXml(element);
        document.add(element);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        super.serializeToXml(element);
        if (this.getPersonDateOfBirth() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_DATE_OF_BIRTH, OpenEstateUtils.getXsdDateFormat().format(this.getPersonDateOfBirth()));
        }
        if (this.getPersonFax() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_FAX, this.getPersonFax());
        }
        if (this.getPersonFirstName() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_FIRST_NAME, this.getPersonFirstName());
        }
        if (this.getPersonGender() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_GENDER, this.getPersonGender().name());
        }
        if (this.getPersonLastName() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_LAST_NAME, this.getPersonLastName());
        }
        if (this.getPersonMail() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_MAIL, this.getPersonMail());
        }
        if (this.getPersonMiddleName() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_MIDDLE_NAME, this.getPersonMiddleName());
        }
        if (this.getPersonMobilePhone() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_MOBILE_PHONE, this.getPersonMobilePhone());
        }
        if (this.getPersonPhone() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_PHONE, this.getPersonPhone());
        }
        if (this.getPersonTitle() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_TITLE, this.getPersonTitle());
        }
    }

    public void setPersonDateOfBirth(Date date) {
        this.putValue(XML_ATTRIB_PERSON_DATE_OF_BIRTH, date);
    }

    public void setPersonFax(String string) {
        this.putValue(XML_ATTRIB_PERSON_FAX, string);
    }

    public void setPersonFirstName(String string) {
        this.putValue(XML_ATTRIB_PERSON_FIRST_NAME, string);
    }

    public void setPersonGender(String string) {
        String string2 = StringUtils.trimToNull((String)string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            this.setPersonGender((Gender)null);
        } else if ("herr".equalsIgnoreCase(string2) || "hr".equalsIgnoreCase(string2) || "hr.".equalsIgnoreCase(string2) || "mr".equalsIgnoreCase(string2) || "mr.".equalsIgnoreCase(string2) || "male".equalsIgnoreCase(string2)) {
            this.setPersonGender(Gender.MALE);
        } else if ("frau".equalsIgnoreCase(string2) || "fr".equalsIgnoreCase(string2) || "fr.".equalsIgnoreCase(string2) || "ms".equalsIgnoreCase(string2) || "ms.".equalsIgnoreCase(string2) || "female".equalsIgnoreCase(string2)) {
            this.setPersonGender(Gender.FEMALE);
        } else {
            try {
                this.setPersonGender(Gender.valueOf(string2));
            }
            catch (Exception exception) {
                this.setPersonGender((Gender)null);
                LOGGER.warn("Unsupported gender '" + string2 + "'!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    public void setPersonGender(Gender gender) {
        this.putValue(XML_ATTRIB_PERSON_GENDER, gender != null ? gender.name() : null);
    }

    public void setPersonLastName(String string) {
        this.putValue(XML_ATTRIB_PERSON_LAST_NAME, string);
    }

    public void setPersonMail(String string) {
        this.putValue(XML_ATTRIB_PERSON_MAIL, string);
    }

    public void setPersonMiddleName(String string) {
        this.putValue(XML_ATTRIB_PERSON_MIDDLE_NAME, string);
    }

    public void setPersonMobilePhone(String string) {
        this.putValue(XML_ATTRIB_PERSON_MOBILE_PHONE, string);
    }

    public void setPersonPhone(String string) {
        this.putValue(XML_ATTRIB_PERSON_PHONE, string);
    }

    public void setPersonTitle(String string) {
        this.putValue(XML_ATTRIB_PERSON_TITLE, string);
    }

    public String writePersonFullName() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = StringUtils.trimToNull((String)this.getPersonTitle());
        if (string != null) {
            arrayList.add(string);
        }
        if ((string = StringUtils.trimToNull((String)this.getPersonFirstName())) != null) {
            arrayList.add(string);
        }
        if ((string = StringUtils.trimToNull((String)this.getPersonMiddleName())) != null) {
            arrayList.add(string);
        }
        if ((string = StringUtils.trimToNull((String)this.getPersonLastName())) != null) {
            arrayList.add(string);
        }
        return StringUtils.join(arrayList, (String)" ");
    }
}

