/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateConstant;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexAttrib;
import com.openindex.openestate.impl.values.CurrencyValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComplexCurrencyAttrib
extends ComplexAttrib<CurrencyValue> {
    private static final long serialVersionUID = 2585163323720887343L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ComplexCurrencyAttrib.class);
    private CurrencyValue value = null;

    public ComplexCurrencyAttrib(OpenEstateAttrib openEstateAttrib, String[] stringArray) {
        super(openEstateAttrib, stringArray);
    }

    @Override
    public CurrencyValue getDefaultValue() {
        return new CurrencyValue(BigDecimal.ZERO, null);
    }

    protected static CurrencyValue get(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        try {
            ComplexCurrencyAttrib complexCurrencyAttrib = (ComplexCurrencyAttrib)estateImpl.getAttribute(openEstateAttrib);
            return complexCurrencyAttrib != null ? complexCurrencyAttrib.getValue() : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as CurrencyValue!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    protected static BigDecimal getAsBigDecimal(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        CurrencyValue currencyValue = ComplexCurrencyAttrib.get(estateImpl, openEstateAttrib);
        return currencyValue != null ? currencyValue.getValue() : null;
    }

    protected static BigInteger getAsBigInteger(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        CurrencyValue currencyValue = ComplexCurrencyAttrib.get(estateImpl, openEstateAttrib);
        return currencyValue != null ? currencyValue.getValue().toBigInteger() : null;
    }

    protected static Double getAsDouble(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        CurrencyValue currencyValue = ComplexCurrencyAttrib.get(estateImpl, openEstateAttrib);
        return currencyValue != null ? Double.valueOf(currencyValue.doubleValue()) : null;
    }

    protected static Float getAsFloat(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        CurrencyValue currencyValue = ComplexCurrencyAttrib.get(estateImpl, openEstateAttrib);
        return currencyValue != null ? Float.valueOf(currencyValue.floatValue()) : null;
    }

    protected static Integer getAsInteger(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        CurrencyValue currencyValue = ComplexCurrencyAttrib.get(estateImpl, openEstateAttrib);
        return currencyValue != null ? Integer.valueOf(currencyValue.intValue()) : null;
    }

    protected static Long getAsLong(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        CurrencyValue currencyValue = ComplexCurrencyAttrib.get(estateImpl, openEstateAttrib);
        return currencyValue != null ? Long.valueOf(currencyValue.longValue()) : null;
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        return ComplexCurrencyAttrib.getAsString(estateImpl, openEstateAttrib, null);
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Locale locale) {
        try {
            AbstractAttribImpl abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib);
            return abstractAttribImpl != null ? abstractAttribImpl.getFormattedValue(locale) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as String!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public final NumberFormat getFormat() {
        return this.getFormat(null);
    }

    public final NumberFormat getFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        return numberFormat;
    }

    @Override
    public String getFormattedValue(CurrencyValue currencyValue, Locale locale, String string) {
        if (currencyValue == null) {
            return "";
        }
        NumberFormat numberFormat = this.getFormat(locale);
        BigDecimal bigDecimal = currencyValue.getValue();
        if (bigDecimal == null) {
            return "";
        }
        Currency currency = currencyValue.getUnit();
        if (currency == null) {
            currency = Currency.getInstance("EUR");
        }
        String string2 = "";
        if (OpenEstateUtils.isApproximatedAttributes() && OpenEstateAttrib.PRICES_COMMON_CHARGE.equals(this.getAttrib())) {
            string2 = OpenEstateConstant.APPROX.getTranslation(locale) + " ";
        }
        String string3 = currency.getCurrencyCode();
        return string2 + numberFormat.format(bigDecimal) + " " + string3;
    }

    @Override
    public CurrencyValue getValue() {
        return this.value;
    }

    @Override
    protected CurrencyValue parseNode(Element element) {
        if (element == null) {
            return null;
        }
        Number number = OpenEstateUtils.parseNumber(element.getStringValue(), this.getFormat());
        Currency currency = null;
        return number != null ? CurrencyValue.parse(number, currency) : null;
    }

    @Override
    public CurrencyValue parseValue(Object object) {
        return CurrencyValue.parse(object);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, String string) {
        ComplexCurrencyAttrib.put(estateImpl, openEstateAttrib, string != null ? CurrencyValue.parse(string) : null);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Number number) {
        ComplexCurrencyAttrib.put(estateImpl, openEstateAttrib, number != null ? CurrencyValue.parse(number) : null);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, CurrencyValue currencyValue) {
        try {
            if (currencyValue == null) {
                estateImpl.removeAttribute(openEstateAttrib);
            } else {
                ComplexCurrencyAttrib complexCurrencyAttrib = (ComplexCurrencyAttrib)openEstateAttrib.createImpl();
                complexCurrencyAttrib.setValue(currencyValue);
                estateImpl.putAttribute(complexCurrencyAttrib);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't put currency attribute \"" + openEstateAttrib + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    @Override
    public void setValue(CurrencyValue currencyValue) {
        this.value = currencyValue;
    }

    @Override
    protected void writeNode(Element element, CurrencyValue currencyValue) {
        if (element == null || currencyValue == null || currencyValue.getValue() == null) {
            return;
        }
        try {
            element.setText(currencyValue.getValue().toString());
        }
        catch (Exception exception) {
            LOGGER.warn("Can't write currency attribute!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }
}

