/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs.features;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.utils.Translatable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.xnap.commons.i18n.I18n;

public final class Equipment
extends SimpleEnumAttrib<Option> {
    public Equipment() {
        super(OpenEstateAttrib.FEATURES_EQUIPMENT, null);
    }

    public Equipment(Option option) {
        this();
        if (option != null) {
            this.setValue(option);
        }
    }

    public static Option get(EstateImpl estateImpl) {
        return (Option)Equipment.get(estateImpl, OpenEstateAttrib.FEATURES_EQUIPMENT);
    }

    public static List<Option> getAsList(EstateImpl estateImpl) {
        ArrayList<Option> arrayList = new ArrayList<Option>();
        Option option = Equipment.get(estateImpl);
        if (option != null) {
            arrayList.add(option);
        }
        return arrayList;
    }

    public static String getAsString(EstateImpl estateImpl) {
        return Equipment.getAsString(estateImpl, OpenEstateAttrib.FEATURES_EQUIPMENT);
    }

    public static String getAsString(EstateImpl estateImpl, Locale locale) {
        return Equipment.getAsString(estateImpl, OpenEstateAttrib.FEATURES_EQUIPMENT, locale);
    }

    @Override
    public Option getOption(String string) {
        try {
            return Option.valueOf(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Option[] getOptions() {
        return Option.values();
    }

    public static void put(EstateImpl estateImpl, Option option) {
        Equipment.put(estateImpl, OpenEstateAttrib.FEATURES_EQUIPMENT, option);
    }

    public static void put(EstateImpl estateImpl, String string) {
        Equipment.put(estateImpl, OpenEstateAttrib.FEATURES_EQUIPMENT, string);
    }

    public static enum Option implements Translatable
    {
        BASIC(I18n.marktr((String)"basic")),
        STANDARD(I18n.marktr((String)"standard")),
        EXCLUSIVE(I18n.marktr((String)"exclusive")),
        LUXURY(I18n.marktr((String)"luxury"));

        private final String i18nKey;

        private Option(String string2) {
            this.i18nKey = string2;
        }

        @Override
        public String getTranslation() {
            return this.getTranslation(null);
        }

        @Override
        public String getTranslation(Locale locale) {
            return OpenEstateUtils.getI18nString(this.i18nKey, locale);
        }
    }
}

