/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs.features;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.utils.Translatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.xnap.commons.i18n.I18n;

public final class Kitchen
extends ComplexEnumAttrib<Option> {
    public Kitchen() {
        super(OpenEstateAttrib.FEATURES_KITCHEN, null);
    }

    public Kitchen(Option option) {
        Option[] optionArray;
        if (option != null) {
            Option[] optionArray2 = new Option[1];
            optionArray = optionArray2;
            optionArray2[0] = option;
        } else {
            optionArray = null;
        }
        this(optionArray);
    }

    public Kitchen(Option[] optionArray) {
        this();
        if (optionArray != null) {
            ((AbstractAttribImpl)this).setValue(optionArray);
        }
    }

    public static Option[] get(EstateImpl estateImpl) {
        return (Option[])Kitchen.get(estateImpl, OpenEstateAttrib.FEATURES_KITCHEN);
    }

    public static List<Option> getAsList(EstateImpl estateImpl) {
        ArrayList<Option> arrayList = new ArrayList<Option>();
        Option[] optionArray = Kitchen.get(estateImpl);
        if (optionArray != null) {
            arrayList.addAll(Arrays.asList(optionArray));
        }
        return arrayList;
    }

    public static String getAsString(EstateImpl estateImpl, String string) {
        return Kitchen.getAsString(estateImpl, OpenEstateAttrib.FEATURES_KITCHEN, string);
    }

    public static String getAsString(EstateImpl estateImpl, String string, Locale locale) {
        return Kitchen.getAsString(estateImpl, OpenEstateAttrib.FEATURES_KITCHEN, string, locale);
    }

    @Override
    public Option getOption(String string) {
        try {
            return Option.valueOf(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Option[] getOptions() {
        return Option.values();
    }

    public Option[] getOptionsArray(Collection<Option> collection) {
        return collection != null && !collection.isEmpty() ? collection.toArray(new Option[collection.size()]) : new Option[]{};
    }

    public static boolean hasOption(EstateImpl estateImpl, Option option) {
        return Kitchen.hasOption(estateImpl, OpenEstateAttrib.FEATURES_KITCHEN, option);
    }

    public static void put(EstateImpl estateImpl, Option[] optionArray) {
        Kitchen.put(estateImpl, OpenEstateAttrib.FEATURES_KITCHEN, optionArray);
    }

    public static void put(EstateImpl estateImpl, String[] stringArray) {
        Kitchen.put(estateImpl, OpenEstateAttrib.FEATURES_KITCHEN, stringArray);
    }

    public static void putOption(EstateImpl estateImpl, Option option) {
        Kitchen.putOption(estateImpl, OpenEstateAttrib.FEATURES_KITCHEN, option);
    }

    public static void putOption(EstateImpl estateImpl, String string) {
        Kitchen.putOption(estateImpl, OpenEstateAttrib.FEATURES_KITCHEN, string);
    }

    public static void removeOption(EstateImpl estateImpl, Option option) {
        Kitchen.removeOption(estateImpl, OpenEstateAttrib.FEATURES_KITCHEN, option);
    }

    public static void removeOption(EstateImpl estateImpl, String string) {
        Kitchen.removeOption(estateImpl, OpenEstateAttrib.FEATURES_KITCHEN, string);
    }

    public static enum Option implements Translatable
    {
        FITTED_KITCHEN(I18n.marktr((String)"fitted kitchen")),
        OPEN_KITCHEN(I18n.marktr((String)"american style kitchen")),
        OPEN_PLAN_KITCHEN(I18n.marktr((String)"open-plan kitchen")),
        KITCHEN_NOOK(I18n.marktr((String)"kitchen nook")),
        SMALL_KITCHEN(I18n.marktr((String)"small kitchen")),
        KITCHENETTE(I18n.marktr((String)"kitchenette")),
        DISHWASHER(I18n.marktr((String)"with dishwasher"));

        private final String i18nKey;

        private Option(String string2) {
            this.i18nKey = string2;
        }

        @Override
        public String getTranslation() {
            return this.getTranslation(null);
        }

        @Override
        public String getTranslation(Locale locale) {
            return OpenEstateUtils.getI18nString(this.i18nKey, locale);
        }
    }
}

