/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db;

import com.openindex.openestate.impl.db.DbFile;
import com.openindex.openestate.impl.db.DbFilesHandler;
import com.openindex.openestate.impl.db.DbHandlerImpl;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbFilesHandlerImpl
extends DbHandlerImpl
implements DbFilesHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbFilesHandlerImpl.class);

    protected DbFilesHandlerImpl() {
        super(null);
    }

    protected DbFilesHandlerImpl(String string) {
        super(string);
    }

    protected DbFile createFile() {
        return new DbFile();
    }

    @Override
    public abstract boolean downloadContent(Connection var1, long var2, OutputStream var4) throws SQLException, IOException;

    @Override
    public abstract boolean downloadPreview(Connection var1, long var2, OutputStream var4) throws SQLException, IOException;

    @Override
    public final DbFile getFile(Connection connection, long l) throws SQLException {
        DbFile[] dbFileArray = this.getFiles(connection, new long[]{l});
        return dbFileArray != null && dbFileArray.length > 0 ? dbFileArray[0] : null;
    }

    @Override
    public final DbFile getFile(Connection connection, String string) throws SQLException {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        DbFile[] dbFileArray = this.getFiles(connection, new String[]{string});
        return dbFileArray != null && dbFileArray.length > 0 ? dbFileArray[0] : null;
    }

    @Override
    public final DbFile[] getFiles(Connection connection) throws SQLException {
        return this.getFiles(connection, (long[])null);
    }

    @Override
    public abstract DbFile[] getFiles(Connection var1, long[] var2) throws SQLException;

    @Override
    public abstract DbFile[] getFiles(Connection var1, String[] var2) throws SQLException;

    @Override
    public abstract DbFile[] getFiles(Connection var1, long var2, Boolean var4, String var5) throws SQLException;

    @Override
    public final long[] getFileIds(Connection connection) throws SQLException {
        return this.getFileIds(connection, 0L, null, null);
    }

    @Override
    public abstract long[] getFileIds(Connection var1, long var2, Boolean var4, String var5) throws SQLException;

    @Override
    public final void loadFileTranslations(Connection connection, DbFile dbFile, DbLanguagesHandler dbLanguagesHandler) throws SQLException {
        if (dbFile != null) {
            this.loadFileTranslations(connection, new DbFile[]{dbFile}, dbLanguagesHandler.getLanguageMap(connection, true));
        }
    }

    @Override
    public final void loadFileTranslations(Connection connection, DbFile dbFile, Map<Long, String> map) throws SQLException {
        if (dbFile != null) {
            this.loadFileTranslations(connection, new DbFile[]{dbFile}, map);
        }
    }

    @Override
    public final void loadFileTranslations(Connection connection, DbFile[] dbFileArray, DbLanguagesHandler dbLanguagesHandler) throws SQLException {
        this.loadFileTranslations(connection, dbFileArray, dbLanguagesHandler.getLanguageMap(connection, true));
    }

    @Override
    public abstract void loadFileTranslations(Connection var1, DbFile[] var2, Map<Long, String> var3) throws SQLException;

    @Override
    public final void removeFile(Connection connection, long l) throws SQLException {
        this.removeFiles(connection, new long[]{l});
    }

    @Override
    public abstract void removeFiles(Connection var1, long[] var2) throws SQLException;

    @Override
    public final void saveFile(Connection connection, DbFile dbFile, File file) throws SQLException, IOException {
        this.saveFile(connection, dbFile, null, null, (Map<Long, String>)null);
    }

    @Override
    public final void saveFile(Connection connection, DbFile dbFile, File file, File file2, DbLanguagesHandler dbLanguagesHandler) throws SQLException, IOException {
        Map<Long, String> map = dbLanguagesHandler != null && dbFile.translations != null ? dbLanguagesHandler.getLanguageMap(connection, true) : null;
        this.saveFile(connection, dbFile, file, file2, map);
    }

    @Override
    public abstract void saveFile(Connection var1, DbFile var2, File var3, File var4, Map<Long, String> var5) throws SQLException, IOException;

    @Override
    public abstract void setFileContent(Connection var1, long var2, File var4, File var5) throws SQLException, IOException;
}

