/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedPreparedStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedPreparedStatement.class);
    private final Map<String, int[]> indexMap = new HashMap<String, int[]>();
    private final PreparedStatement statement;

    public NamedPreparedStatement(Connection connection, String string) throws SQLException {
        String string2 = NamedPreparedStatement.parse(string, this.indexMap);
        this.statement = connection.prepareStatement(string2);
    }

    private static String parse(String string, Map<String, int[]> map) {
        Object object;
        HashMap<Object, LinkedList<Integer>> hashMap = new HashMap<Object, LinkedList<Integer>>();
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            int n3 = string.charAt(i);
            if (bl) {
                if (n3 == 39) {
                    bl = false;
                }
            } else if (bl2) {
                if (n3 == 34) {
                    bl2 = false;
                }
            } else if (n3 == 39) {
                bl = true;
            } else if (n3 == 34) {
                bl2 = true;
            } else if (n3 == 58 && i + 1 < n && Character.isJavaIdentifierStart(string.charAt(i + 1))) {
                int n4;
                for (n4 = i + 2; n4 < n && Character.isJavaIdentifierPart(string.charAt(n4)); ++n4) {
                }
                object = string.substring(i + 1, n4);
                n3 = 63;
                i += ((String)object).length();
                LinkedList<Integer> linkedList = (LinkedList<Integer>)hashMap.get(object);
                if (linkedList == null) {
                    linkedList = new LinkedList<Integer>();
                    hashMap.put(object, linkedList);
                }
                linkedList.add(n2);
                ++n2;
            }
            stringBuilder.append((char)n3);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            List list = (List)entry.getValue();
            object = new int[list.size()];
            int n5 = 0;
            for (Integer n6 : list) {
                object[n5++] = n6;
            }
            map.put((String)entry.getKey(), (int[])object);
        }
        return stringBuilder.toString();
    }

    private int[] getIndexes(String string) {
        int[] nArray = this.indexMap.get(string);
        if (nArray == null) {
            throw new IllegalArgumentException("Parameter not found: " + string);
        }
        return nArray;
    }

    public void clearParameters() throws SQLException {
        this.statement.clearParameters();
    }

    public void setObject(String string, Object object) throws SQLException {
        for (int n : this.getIndexes(string)) {
            this.statement.setObject(n, object);
        }
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        for (int n2 : this.getIndexes(string)) {
            this.statement.setObject(n2, object, n);
        }
    }

    public void setString(String string, String string2) throws SQLException {
        for (int n : this.getIndexes(string)) {
            this.statement.setString(n, string2);
        }
    }

    public void setInt(String string, int n) throws SQLException {
        for (int n2 : this.getIndexes(string)) {
            this.statement.setInt(n2, n);
        }
    }

    public void setLong(String string, long l) throws SQLException {
        for (int n : this.getIndexes(string)) {
            this.statement.setLong(n, l);
        }
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        for (int n : this.getIndexes(string)) {
            this.statement.setTimestamp(n, timestamp);
        }
    }

    public void setTime(String string, Time time) throws SQLException {
        for (int n : this.getIndexes(string)) {
            this.statement.setTime(n, time);
        }
    }

    public void setDate(String string, Date date) throws SQLException {
        for (int n : this.getIndexes(string)) {
            this.statement.setDate(n, date);
        }
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        for (int n : this.getIndexes(string)) {
            this.statement.setBoolean(n, bl);
        }
    }

    public void setDouble(String string, double d) throws SQLException {
        for (int n : this.getIndexes(string)) {
            this.statement.setDouble(n, d);
        }
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        for (int n : this.getIndexes(string)) {
            this.statement.setBigDecimal(n, bigDecimal);
        }
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        for (int n2 : this.getIndexes(string)) {
            this.statement.setBinaryStream(n2, inputStream, n);
        }
    }

    public void setNull(String string, int n) throws SQLException {
        for (int n2 : this.getIndexes(string)) {
            this.statement.setNull(n2, n);
        }
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        for (int n2 : this.getIndexes(string)) {
            this.statement.setNull(n2, n, string2);
        }
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public boolean execute() throws SQLException {
        return this.statement.execute();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.statement.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        return this.statement.executeUpdate();
    }

    public void close() throws SQLException {
        this.statement.close();
    }

    public void addBatch() throws SQLException {
        this.statement.addBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }
}

