/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConverter.class);
    private Map<String, List<String>> errorMap = new TreeMap<String, List<String>>();
    private Locale openEstateLanguage = OpenEstateUtils.DEFAULT_LOCALE;

    protected AbstractConverter() {
    }

    protected AgencyImpl createEmptyAgency() {
        return new AgencyImpl();
    }

    protected AgentImpl createEmptyAgent() {
        return new AgentImpl();
    }

    protected EstateAttachmentImpl createEmptyAttachment() {
        return new EstateAttachmentImpl();
    }

    protected AgentContactImpl createEmptyContact() {
        return new AgentContactImpl();
    }

    protected EstateImpl createEmptyEstate() {
        EstateImpl estateImpl = new EstateImpl();
        Locale locale = this.getOpenEstateLanguage();
        if (locale != null) {
            estateImpl.getLanguages().add(locale.toString());
        }
        return estateImpl;
    }

    protected EstateLinkImpl createEmptyLink() {
        return new EstateLinkImpl();
    }

    protected TransferImpl createEmptyTransfer() {
        return new TransferImpl();
    }

    protected TransferAgencyImpl createEmptyTransferAgency() {
        return new TransferAgencyImpl();
    }

    public List<String> getErrors(String string) {
        return this.errorMap.get(string);
    }

    public String getErrorMessages(String string) {
        List<String> list = this.errorMap.get(string);
        return list != null && !list.isEmpty() ? "[" + StringUtils.join(list, (String)"]; [") + "]" : null;
    }

    public Map<String, List<String>> getErrorMap() {
        return this.errorMap;
    }

    public Locale getOpenEstateLanguage() {
        return this.openEstateLanguage;
    }

    public void putError(String string, String string2) {
        if (!StringUtils.isBlank((CharSequence)string2)) {
            if (!this.errorMap.containsKey(string)) {
                this.errorMap.put(string, new ArrayList());
            }
            this.errorMap.get(string).add(string2);
        }
    }

    public void putErrors(String string, List<String> list) {
        if (list != null && !list.isEmpty()) {
            if (!this.errorMap.containsKey(string)) {
                this.errorMap.put(string, new ArrayList());
            }
            this.errorMap.get(string).addAll(list);
        }
    }

    public final void setOpenEstateLanguage(Locale locale) {
        this.openEstateLanguage = locale;
    }
}

