/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.openindex.openestate.impl.values.VolumeValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.NumberFormat;
import java.util.Arrays;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVolumeValueField
extends JPanel {
    private static final long serialVersionUID = -5594691269352831379L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JVolumeValueField.class);
    private JFormattedTextField valueField;
    private JSpinner unitSpinner;
    private VolumeValue.Unit currentUnit = null;

    public JVolumeValueField() {
        super(new BorderLayout(5, 0));
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMaximumFractionDigits(2);
        this.valueField = new JFormattedTextField(numberFormat);
        this.valueField.setFocusLostBehavior(0);
        this.add((Component)this.valueField, "Center");
        SpinnerListModel spinnerListModel = new SpinnerListModel(Arrays.asList(VolumeValue.Unit.values()));
        this.unitSpinner = new JSpinner(spinnerListModel);
        this.unitSpinner.setValue((Object)VolumeValue.Unit.getBaseUnit());
        this.unitSpinner.setPreferredSize(new Dimension(60, this.unitSpinner.getPreferredSize().height));
        this.unitSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                VolumeValue volumeValue = JVolumeValueField.this.getValue();
                if (volumeValue == null) {
                    return;
                }
                if (JVolumeValueField.this.currentUnit != null) {
                    JVolumeValueField.this.valueField.setValue(VolumeValue.convert(volumeValue.getValue(), JVolumeValueField.this.currentUnit, volumeValue.getUnit()));
                }
                JVolumeValueField.this.currentUnit = volumeValue.getUnit();
            }
        });
        this.add((Component)this.unitSpinner, "East");
        this.revalidate();
        this.repaint();
    }

    public JSpinner getUnitSpinner() {
        return this.unitSpinner;
    }

    public VolumeValue getValue() {
        try {
            this.valueField.commitEdit();
            return !this.valueField.isEditValid() ? null : VolumeValue.parse(this.valueField.getValue(), (VolumeValue.Unit)((Object)this.unitSpinner.getValue()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JFormattedTextField getValueField() {
        return this.valueField;
    }

    public void setValue(VolumeValue volumeValue) {
        this.currentUnit = volumeValue != null ? volumeValue.getUnit() : VolumeValue.Unit.getBaseUnit();
        this.unitSpinner.setValue((Object)this.currentUnit);
        this.valueField.setValue(volumeValue != null ? Double.valueOf(volumeValue.doubleValue()) : null);
    }
}

