/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.parser.FinalText;
import com.lowagie.text.pdf.parser.ParsedText;
import com.lowagie.text.pdf.parser.ParsedTextImpl;
import com.lowagie.text.pdf.parser.TextAssembler;
import com.lowagie.text.pdf.parser.TextAssemblyBuffer;
import com.lowagie.text.pdf.parser.Vector;
import com.lowagie.text.pdf.parser.Word;
import java.util.ArrayList;
import java.util.Collection;

public class MarkedUpTextAssembler
implements TextAssembler {
    private PdfReader _reader;
    private ParsedTextImpl _inProgress = null;
    int _page;
    private int word_id_counter = 1;
    private boolean _usePdfMarkupElements = false;
    Collection<FinalText> result = new ArrayList<FinalText>();
    Collection<TextAssemblyBuffer> partialWords = new ArrayList<TextAssemblyBuffer>();

    MarkedUpTextAssembler(PdfReader reader) {
        this._reader = reader;
    }

    MarkedUpTextAssembler(PdfReader reader, boolean usePdfMarkupElements) {
        this._reader = reader;
        this._usePdfMarkupElements = usePdfMarkupElements;
    }

    @Override
    public void process(ParsedText unassembled, String contextName) {
        this.partialWords.addAll(unassembled.getAsPartialWords());
    }

    @Override
    public void process(FinalText completed, String contextName) {
        this.clearAccumulator();
        this.result.add(completed);
    }

    @Override
    public void process(Word completed, String contextName) {
        this.partialWords.add(completed);
    }

    private void clearAccumulator() {
        for (TextAssemblyBuffer partialWord : this.partialWords) {
            partialWord.assemble(this);
        }
        this.partialWords.clear();
        if (this._inProgress != null) {
            this.result.add(this._inProgress.getFinalText(this._reader, this._page, this, this._usePdfMarkupElements));
            this._inProgress = null;
        }
    }

    private FinalText concatenateResult(String containingElementName) {
        if (containingElementName == null) {
            return null;
        }
        StringBuffer res = new StringBuffer();
        if (this._usePdfMarkupElements && !containingElementName.isEmpty()) {
            res.append('<').append(containingElementName).append('>');
        }
        for (FinalText item : this.result) {
            res.append(item.getText());
        }
        this.result.clear();
        if (this._usePdfMarkupElements && !containingElementName.isEmpty()) {
            res.append("</");
            int spacePos = containingElementName.indexOf(32);
            if (spacePos >= 0) {
                containingElementName = containingElementName.substring(0, spacePos);
            }
            res.append(containingElementName).append('>');
        }
        return new FinalText(res.toString());
    }

    private FinalText accumulate(Collection<TextAssemblyBuffer> textInfo) {
        StringBuffer res = new StringBuffer();
        for (TextAssemblyBuffer info : textInfo) {
            res.append(info.getText());
        }
        return new FinalText(res.toString());
    }

    @Override
    public FinalText endParsingContext(String containingElementName) {
        this.clearAccumulator();
        return this.concatenateResult(containingElementName);
    }

    @Override
    public void reset() {
        this.result.clear();
        this.partialWords.clear();
        this._inProgress = null;
    }

    @Override
    public void renderText(FinalText finalText) {
        this.result.add(finalText);
    }

    @Override
    public void renderText(ParsedTextImpl partialWord) {
        float sameLineThreshold;
        boolean firstRender = this._inProgress == null;
        boolean hardReturn = false;
        if (firstRender) {
            this._inProgress = partialWord;
            return;
        }
        Vector start = partialWord.getStartPoint();
        Vector lastStart = this._inProgress.getStartPoint();
        Vector lastEnd = this._inProgress.getEndPoint();
        float dist = this._inProgress.getBaseline().subtract(lastStart).cross(lastStart.subtract(start)).lengthSquared() / this._inProgress.getBaseline().subtract(lastStart).lengthSquared();
        if (dist > (sameLineThreshold = partialWord.getAscent() * 0.5f) || Float.isNaN(dist)) {
            hardReturn = true;
        }
        float spacing = lastEnd.subtract(start).length();
        if (hardReturn || partialWord.breakBefore()) {
            this.result.add(this._inProgress.getFinalText(this._reader, this._page, this, this._usePdfMarkupElements));
            if (hardReturn) {
                this.result.add(new FinalText("\n"));
                if (this._usePdfMarkupElements) {
                    this.result.add(new FinalText("<br class='t-pdf' />"));
                }
            }
            this._inProgress = partialWord;
        } else if ((double)spacing < (double)partialWord.getSingleSpaceWidth() / 2.3 || this._inProgress.shouldNotSplit()) {
            this._inProgress = new Word(this._inProgress.getText() + partialWord.getText().trim(), partialWord.getAscent(), partialWord.getDescent(), lastStart, partialWord.getEndPoint(), this._inProgress.getBaseline(), partialWord.getSingleSpaceWidth(), this._inProgress.shouldNotSplit(), this._inProgress.breakBefore());
        } else {
            this.result.add(this._inProgress.getFinalText(this._reader, this._page, this, this._usePdfMarkupElements));
            this._inProgress = partialWord;
        }
    }

    protected PdfReader getReader() {
        return this._reader;
    }

    @Override
    public void setPage(int page) {
        this._page = page;
    }

    @Override
    public String getWordId() {
        return "word" + this.word_id_counter++;
    }
}

