/*
 * Decompiled with CFR 0.152.
 */
package bizcal.common;

import bizcal.util.DateUtil;
import java.awt.Color;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.ImageIcon;

public class Event
implements Comparable {
    public static final String LINE_DISTANCE = "linedistance";
    public static final String CALENDAR_ID = "calendarId";
    public static final String CALENDAR_IS_BACKGROUND = "calendarIsBackground";
    public static final String EVENT_PROPOSAL_STATE = "eventProposalState";
    private Object id;
    private String summary;
    private String description;
    private Date start;
    private Date end;
    private int level = 0;
    private Color color = Color.LIGHT_GRAY;
    private boolean frame = true;
    private boolean roundedCorner = true;
    private boolean editable = true;
    private boolean showTime = true;
    private boolean showHeader = true;
    private String toolTip = null;
    private Map props = new HashMap();
    private boolean background = false;
    private boolean selectable = true;
    private ImageIcon icon = null;
    private Object orgEvent;
    private ImageIcon upperRightIcon;
    private Color bordercolor = Color.DARK_GRAY;

    public Object getId() {
        return this.id;
    }

    public void setId(Object object) {
        this.id = object;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date date) {
        this.end = date;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date date) {
        this.start = date;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String string) {
        this.summary = string;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isFrame() {
        return this.frame;
    }

    public void setFrame(boolean bl) {
        this.frame = bl;
    }

    public Color getBordercolor() {
        return this.bordercolor;
    }

    public void setBordercolor(Color color) {
        this.bordercolor = color;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public boolean isRoundedCorner() {
        return this.roundedCorner;
    }

    public void setRoundedCorner(boolean bl) {
        this.roundedCorner = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean equals(Object object) {
        if (object instanceof Event && this.getId() != null) {
            return this.getId().equals(((Event)object).getId());
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = 17;
        n = (int)((long)(37 * n) + this.getStart().getTime() + this.getEnd().getTime());
        return n;
    }

    public void set(String string, Object object) {
        this.props.put(string, object);
    }

    public Object get(String string) {
        return this.props.get(string);
    }

    public boolean isShowTime() {
        return this.showTime;
    }

    public void setShowTime(boolean bl) {
        this.showTime = bl;
    }

    public boolean showHeader() {
        return this.showHeader;
    }

    public void setShowHeader(boolean bl) {
        this.showHeader = bl;
    }

    public String getToolTip() {
        if (this.toolTip != null) {
            return this.toolTip;
        }
        DateFormat dateFormat = DateFormat.getTimeInstance(3, Locale.getDefault());
        String string = null;
        if (this.description != null) {
            string = this.description.replaceAll("<", "&#60;");
            string = string.replaceAll(">", "&#62;");
            string = string.replaceAll("\n", "<br>");
        }
        return "<html>[" + dateFormat.format(this.getStart()) + "-" + dateFormat.format(this.getEnd()) + "] <b>" + this.summary + "</b><br><hr><table width=\"300\"><tr><td>" + string + "</td></tr></table>";
    }

    public void setToolTip(String string) {
        this.toolTip = string;
    }

    public boolean isBackground() {
        return this.background;
    }

    public void setBackground(boolean bl) {
        this.background = bl;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean bl) {
        this.selectable = bl;
    }

    public String toString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, new Locale("sv"));
        dateFormat.setTimeZone(TimeZone.getTimeZone("CET"));
        return dateFormat.format(this.start) + " - " + dateFormat.format(this.end) + " : " + this.summary;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.icon = imageIcon;
    }

    public ImageIcon getUpperRightIcon() {
        return this.upperRightIcon;
    }

    public void setUpperRightIcon(ImageIcon imageIcon) {
        this.upperRightIcon = imageIcon;
    }

    public Object getOrgEvent() {
        return this.orgEvent;
    }

    public void setOrgEvent(Object object) {
        this.orgEvent = object;
    }

    public int compareTo(Object object) {
        Event event = (Event)object;
        return this.start.compareTo(event.start);
    }

    public void move(Date date) {
        if (date != null) {
            this.setEnd(new Date(this.getEnd().getTime() + DateUtil.getDiffDay(this.getStart(), date)));
            this.setStart(date);
        }
    }

    public Event copy() {
        Event event = new Event();
        event.setBackground(this.isBackground());
        event.setColor(this.getColor());
        event.setDescription(this.getDescription());
        event.setEditable(this.isEditable());
        event.setEnd(this.getEnd());
        event.setFrame(this.isFrame());
        event.setIcon(this.getIcon());
        event.setId(this.getId());
        event.setLevel(this.getLevel());
        event.setOrgEvent(this.getOrgEvent());
        event.setRoundedCorner(this.isRoundedCorner());
        event.setSelectable(this.isSelectable());
        event.setShowTime(this.isShowTime());
        event.setStart(this.getStart());
        event.setSummary(this.getSummary());
        event.setToolTip(this.getToolTip());
        return event;
    }
}

