/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.common.CalendarViewConfig;
import bizcal.swing.ColumnHeaderPanel;
import bizcal.swing.util.GradientArea;
import bizcal.util.BizcalException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;

public class CalendarRowHeader {
    private JLayeredPane panel;
    private List<JLabel> calLabels = new ArrayList<JLabel>();
    private List<JLabel> calLines = new ArrayList<JLabel>();
    private GradientArea gradientArea;
    private int width = 100;
    private int footerHeight = 0;
    private CalendarModel model;
    private CalendarViewConfig config;

    public CalendarRowHeader(CalendarModel calendarModel, CalendarViewConfig calendarViewConfig) throws Exception {
        this.model = calendarModel;
        this.config = calendarViewConfig;
        this.panel = new JLayeredPane();
        this.panel.setLayout(new Layout());
    }

    public void refresh() throws Exception {
        this.panel.removeAll();
        this.calLabels.clear();
        this.calLines.clear();
        JLabel jLabel = new JLabel();
        jLabel.setBackground(this.config.getLineColor());
        jLabel.setOpaque(true);
        this.calLines.add(jLabel);
        this.panel.add((Component)jLabel, (Object)2);
        for (Calendar calendar : this.model.getSelectedCalendars()) {
            JLabel jLabel2 = new JLabel(calendar.getSummary());
            jLabel2.setVerticalTextPosition(0);
            this.panel.add((Component)jLabel2, (Object)2);
            this.calLabels.add(jLabel2);
            jLabel = new JLabel();
            jLabel.setBackground(this.config.getLineColor());
            jLabel.setOpaque(true);
            this.calLines.add(jLabel);
            this.panel.add((Component)jLabel, (Object)2);
        }
        this.gradientArea = new GradientArea("LEFT_RIGHT", Color.WHITE, ColumnHeaderPanel.GRADIENT_COLOR);
        this.gradientArea.setOpaque(true);
        this.gradientArea.setBorder(false);
        this.panel.add((Component)this.gradientArea, (Object)1);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void setFooterHeight(int n) {
        this.footerHeight = n;
    }

    private class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            try {
                return new Dimension(CalendarRowHeader.this.width, 40 * CalendarRowHeader.this.model.getSelectedCalendars().size() + CalendarRowHeader.this.footerHeight);
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(50, 50);
        }

        @Override
        public void layoutContainer(Container container) {
            try {
                double d = 40.0;
                JLabel jLabel = (JLabel)CalendarRowHeader.this.calLines.get(0);
                jLabel.setBounds(0, 0, CalendarRowHeader.this.width, 1);
                for (int i = 0; i < CalendarRowHeader.this.calLabels.size(); ++i) {
                    JLabel jLabel2 = (JLabel)CalendarRowHeader.this.calLabels.get(i);
                    jLabel2.setBounds(5, (int)((double)i * d), CalendarRowHeader.this.width - 5, (int)d);
                    jLabel = (JLabel)CalendarRowHeader.this.calLines.get(i + 1);
                    jLabel.setBounds(0, (int)((double)(i + 1) * d), CalendarRowHeader.this.width, 1);
                }
                CalendarRowHeader.this.gradientArea.setBounds(0, 0, container.getWidth(), container.getHeight());
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }
    }
}

