/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.common.CalendarViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarRowHeader;
import bizcal.swing.CalendarView;
import bizcal.swing.DaysHoursHeaderPanel;
import bizcal.swing.StringLengthFormater;
import bizcal.swing.util.FrameArea;
import bizcal.util.BizcalException;
import bizcal.util.DateInterval;
import bizcal.util.DateUtil;
import bizcal.util.TextUtil;
import bizcal.util.TimeOfDay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GroupView
extends CalendarView {
    private static final int LABEL_COL_WIDTH = 70;
    public static final int HOUR_RESOLUTION = 2;
    public static final int PREFERRED_HOUR_WIDTH = 10;
    public static final int PREFERRED_ROW_HEIGHT = 40;
    private List<List<FrameArea>> frameAreaRows = new ArrayList<List<FrameArea>>();
    private List eventRows = new ArrayList();
    private Map vLines = new HashMap();
    private List hLines = new ArrayList();
    private JLayeredPane calPanel;
    private JScrollPane scrollPane;
    private DaysHoursHeaderPanel columnHeader;
    private CalendarRowHeader rowHeader;
    private List calBackgrounds = new ArrayList();
    private int dayCount;

    public GroupView(CalendarViewConfig calendarViewConfig, CalendarModel calendarModel) throws Exception {
        super(calendarViewConfig);
        this.setModel(calendarModel);
        this.font = new Font("Verdana", 0, 10);
        this.calPanel = new JLayeredPane();
        this.calPanel.setLayout(new Layout());
        CalendarView.ThisMouseListener thisMouseListener = new CalendarView.ThisMouseListener();
        this.calPanel.addMouseListener(thisMouseListener);
        this.calPanel.addMouseMotionListener(thisMouseListener);
        this.scrollPane = new JScrollPane(this.calPanel, 20, 30);
        this.scrollPane.setCursor(Cursor.getDefaultCursor());
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(15);
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", this.createCorner(true, true));
        this.scrollPane.setCorner("LOWER_LEFT_CORNER", this.createCorner(true, false));
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", this.createCorner(false, true));
        this.columnHeader = new DaysHoursHeaderPanel(calendarViewConfig, calendarModel);
        this.scrollPane.setColumnHeaderView(this.columnHeader.getComponent());
        this.rowHeader = new CalendarRowHeader(calendarModel, calendarViewConfig);
        this.rowHeader.setFooterHeight(0);
        this.scrollPane.setRowHeaderView(this.rowHeader.getComponent());
    }

    @Override
    public void refresh0() throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        Object object62;
        this.calPanel.removeAll();
        this.calPanel.setBackground(Color.WHITE);
        this.frameAreaRows.clear();
        this.eventRows.clear();
        this.hLines.clear();
        this.vLines.clear();
        this.calBackgrounds.clear();
        this.dayCount = DateUtil.getDateDiff(this.getModel().getInterval().getEndDate(), this.getModel().getInterval().getStartDate());
        this.addDraggingComponents(this.calPanel);
        JLabel jLabel = new JLabel();
        jLabel.setBackground(this.getDescriptor().getLineColor());
        jLabel.setOpaque(true);
        this.calPanel.add((Component)jLabel, (Object)1);
        this.hLines.add(jLabel);
        for (Object object62 : this.getModel().getSelectedCalendars()) {
            object52 = ((Calendar)object62).getId();
            object4 = ((Calendar)object62).getSummary();
            object4 = StringLengthFormater.formatNameString((String)object4, this.font, 65);
            jLabel = new JLabel();
            jLabel.setBackground(this.getDescriptor().getLineColor());
            jLabel.setOpaque(true);
            this.calPanel.add((Component)jLabel, (Object)1);
            this.hLines.add(jLabel);
            object3 = new ArrayList();
            this.frameAreaRows.add((List<FrameArea>)object3);
            object2 = this.getModel().getEvents(object52);
            Collections.sort(object2);
            this.eventRows.add(object2);
            object = object2.iterator();
            while (object.hasNext()) {
                Event event = object.next();
                FrameArea frameArea = this.createFrameArea(object52, event);
                object3.add(frameArea);
                this.calPanel.add((Component)frameArea, (Object)event.getLevel());
            }
        }
        object62 = java.util.Calendar.getInstance(Locale.getDefault());
        ((java.util.Calendar)object62).setTime(this.getInterval().getStartDate());
        while (((java.util.Calendar)object62).getTime().getTime() < this.getInterval().getEndDate().getTime()) {
            object52 = ((java.util.Calendar)object62).getTime();
            object4 = new JLabel();
            ((JComponent)object4).setBackground(this.getDescriptor().getLineColor2());
            ((JComponent)object4).setOpaque(true);
            this.calPanel.add((Component)object4, (Object)2);
            this.vLines.put(object52, object4);
            if (this.dayCount <= 7) {
                object3 = this.getDescriptor().getStartView();
                ((java.util.Calendar)object62).set(11, ((TimeOfDay)object3).getHour());
                ((java.util.Calendar)object62).set(12, ((TimeOfDay)object3).getMinute());
                ((java.util.Calendar)object62).set(13, 0);
                ((java.util.Calendar)object62).set(14, 0);
                object2 = this.getDescriptor().getEndView();
                while (((TimeOfDay)(object = new TimeOfDay(((java.util.Calendar)object62).getTime()))).getValue() < ((TimeOfDay)object2).getValue()) {
                    object4 = new JLabel();
                    ((JComponent)object4).setBackground(this.getDescriptor().getLineColor());
                    ((JComponent)object4).setOpaque(true);
                    this.calPanel.add((Component)object4, (Object)2);
                    this.vLines.put(((java.util.Calendar)object62).getTime(), object4);
                    ((java.util.Calendar)object62).add(10, 2);
                }
            }
            ((java.util.Calendar)object62).add(6, 1);
            ((java.util.Calendar)object62).set(11, 0);
            ((java.util.Calendar)object62).set(12, 0);
            ((java.util.Calendar)object62).set(13, 0);
            ((java.util.Calendar)object62).set(14, 0);
        }
        for (Object object52 : this.getSelectedCalendars()) {
            object4 = new JPanel();
            ((JComponent)object4).setBackground(((Calendar)object52).getColor());
            this.calBackgrounds.add(object4);
            this.calPanel.add((Component)object4, (Object)1);
        }
        this.calPanel.validate();
        this.calPanel.repaint();
        this.columnHeader.setModel(this.getModel());
        this.columnHeader.refresh();
        this.rowHeader.refresh();
    }

    private int getWidth() {
        return this.calPanel.getWidth();
    }

    private int getHeight() {
        return this.calPanel.getHeight();
    }

    @Override
    protected int getCaptionRowHeight() {
        return 0;
    }

    @Override
    protected int getXOffset() {
        return 0;
    }

    private int getTimeHeight() {
        return this.getHeight() - this.getCaptionRowHeight();
    }

    private int getTimeWidth() {
        return this.getWidth() - this.getXOffset();
    }

    private int getRowHeight() throws Exception {
        return 40;
    }

    private int getXPos(Date date) throws Exception {
        TimeOfDay timeOfDay = new TimeOfDay(date);
        long l = timeOfDay.getValue() - this.getDescriptor().getStartView().getValue();
        if (l < 0L) {
            l = 0L;
        }
        long l2 = this.getDescriptor().getEndView().getValue() - this.getDescriptor().getStartView().getValue();
        double d = (double)l / (double)l2;
        double d2 = this.getDayWidth();
        int n = DateUtil.getDateDiff(date, this.getInterval().getStartDate());
        return (int)((double)this.getXOffset() + (double)n * d2 + d * d2);
    }

    private double getDayWidth() throws Exception {
        long l = this.getInterval().getDuration();
        l = l / 24L / 3600L / 1000L;
        return (double)this.getTimeWidth() / (double)l;
    }

    @Override
    protected LayoutManager getLayout() {
        return new Layout();
    }

    @Override
    public JComponent getComponent() {
        return this.scrollPane;
    }

    @Override
    protected Date getDate(int n, int n2) throws Exception {
        double d = this.getDayWidth();
        int n3 = (int)((double)(n -= this.getXOffset()) / d);
        n = (int)((double)n - (double)n3 * d);
        double d2 = (double)n / d;
        Date date = this.getInterval().getStartDate();
        date = DateUtil.getDiffDay(date, n3);
        long l = this.getDescriptor().getEndView().getValue() - this.getDescriptor().getStartView().getValue();
        long l2 = this.getDescriptor().getStartView().getValue();
        long l3 = (long)(d2 * (double)l);
        TimeOfDay timeOfDay = new TimeOfDay(l2 + l3);
        date = timeOfDay.getDate(date);
        return date;
    }

    @Override
    protected Object getCalendarId(int n, int n2) throws Exception {
        int n3 = n2 / this.getRowHeight();
        if (n3 >= this.getSelectedCalendars().size()) {
            return null;
        }
        Calendar calendar = (Calendar)this.getSelectedCalendars().get(n3);
        return calendar.getId();
    }

    protected String getHeaderText() throws Exception {
        Date date = this.getInterval().getStartDate();
        java.util.Calendar calendar = java.util.Calendar.getInstance(Locale.getDefault());
        calendar.setTime(this.getInterval().getEndDate());
        calendar.add(5, -1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM yyyy", Locale.getDefault());
        return TextUtil.formatCase(simpleDateFormat.format(date));
    }

    private int getHourCount() throws Exception {
        return this.getDescriptor().getEndView().getHour() - this.getDescriptor().getStartView().getHour();
    }

    private class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            try {
                DateInterval dateInterval = GroupView.this.getModel().getInterval();
                int n = DateUtil.getDateDiff(dateInterval.getEndDate(), dateInterval.getStartDate());
                int n2 = n * GroupView.this.getHourCount() * 10;
                int n3 = 400;
                return new Dimension(n2, n3);
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(50, 100);
        }

        @Override
        public void layoutContainer(Container container) {
            try {
                Object object;
                Object object2;
                Object object3;
                int n;
                int n2 = GroupView.this.getWidth();
                int n3 = GroupView.this.getHeight();
                int n4 = GroupView.this.getCaptionRowHeight();
                int n5 = GroupView.this.getRowHeight();
                JLabel jLabel = (JLabel)GroupView.this.hLines.get(0);
                jLabel.setBounds(0, 0, n2, 1);
                int n6 = n4;
                for (n = 0; n < GroupView.this.eventRows.size(); ++n) {
                    Rectangle rectangle;
                    int n7;
                    Event event;
                    int n8;
                    object3 = (List)GroupView.this.frameAreaRows.get(n);
                    object2 = (List)GroupView.this.eventRows.get(n);
                    Component component = null;
                    int n9 = 0;
                    int n10 = 0;
                    object = new int[object2.size()];
                    for (n8 = 0; n8 < object3.size(); ++n8) {
                        FrameArea frameArea = (FrameArea)object3.get(n8);
                        event = (Event)object2.get(n8);
                        int n11 = GroupView.this.getXPos(event.getStart());
                        n7 = GroupView.this.getXPos(event.getEnd());
                        frameArea.setBounds(n11, n6, n7 - n11, n5);
                        if (!event.isBackground()) {
                            if (component != null) {
                                rectangle = component.getBounds();
                                int n12 = rectangle.x + rectangle.width;
                                if (n12 > n11) {
                                    ++n9;
                                    if (n12 < n7) {
                                        component = frameArea;
                                    }
                                } else {
                                    n9 = 0;
                                    component = frameArea;
                                }
                            } else {
                                component = frameArea;
                            }
                            object[n8] = n9;
                            if (n9 <= n10) continue;
                            n10 = n9;
                            continue;
                        }
                        object[n8] = 0;
                    }
                    if (n10 > 0) {
                        n8 = n5 / (n10 + 1);
                        for (int i = 0; i < object3.size(); ++i) {
                            event = (Event)object2.get(i);
                            if (event.isBackground()) continue;
                            FrameArea frameArea = (FrameArea)object3.get(i);
                            n7 = object[i];
                            rectangle = frameArea.getBounds();
                            frameArea.setBounds(rectangle.x, rectangle.y + n7 * n8, rectangle.width, n8);
                        }
                    }
                    jLabel = (JLabel)GroupView.this.hLines.get(n + 1);
                    jLabel.setBounds(0, n6 + n5, n2, 1);
                    n6 += n5;
                }
                n = GroupView.this.getCaptionRowHeight() / 2;
                object3 = java.util.Calendar.getInstance(Locale.getDefault());
                ((java.util.Calendar)object3).setTime(GroupView.this.getInterval().getStartDate());
                while (((java.util.Calendar)object3).getTime().getTime() < GroupView.this.getInterval().getEndDate().getTime()) {
                    object2 = ((java.util.Calendar)object3).getTime();
                    int n13 = GroupView.this.getXPos((Date)object2);
                    JLabel jLabel2 = (JLabel)GroupView.this.vLines.get(object2);
                    jLabel2.setBounds(n13, 0, 1, n3);
                    if (GroupView.this.dayCount <= 7) {
                        TimeOfDay timeOfDay;
                        TimeOfDay timeOfDay2 = GroupView.this.getDescriptor().getStartView();
                        ((java.util.Calendar)object3).set(11, timeOfDay2.getHour());
                        ((java.util.Calendar)object3).set(12, timeOfDay2.getMinute());
                        ((java.util.Calendar)object3).set(13, 0);
                        ((java.util.Calendar)object3).set(14, 0);
                        object = GroupView.this.getDescriptor().getEndView();
                        while ((timeOfDay = new TimeOfDay(((java.util.Calendar)object3).getTime())).getValue() < ((TimeOfDay)object).getValue()) {
                            n13 = GroupView.this.getXPos(((java.util.Calendar)object3).getTime());
                            jLabel2 = (JLabel)GroupView.this.vLines.get(((java.util.Calendar)object3).getTime());
                            jLabel2.setBounds(n13, n, 1, n3 - n);
                            ((java.util.Calendar)object3).add(10, 2);
                        }
                    }
                    ((java.util.Calendar)object3).add(5, 1);
                    ((java.util.Calendar)object3).set(11, 0);
                    ((java.util.Calendar)object3).set(12, 0);
                    ((java.util.Calendar)object3).set(13, 0);
                    ((java.util.Calendar)object3).set(14, 0);
                }
                n6 = n4;
                for (int i = 0; i < GroupView.this.calBackgrounds.size(); ++i) {
                    int n14 = GroupView.this.getXOffset();
                    int n15 = GroupView.this.getWidth();
                    JPanel jPanel = (JPanel)GroupView.this.calBackgrounds.get(i);
                    jPanel.setBounds(n14, n6, n15 - n14, n5);
                    n6 += n5;
                }
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }
    }
}

