/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.Calendar;
import bizcal.common.CalendarViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarListener;
import bizcal.swing.CalendarView;
import bizcal.swing.ColumnHeaderPanel;
import bizcal.swing.util.ErrorHandler;
import bizcal.swing.util.FrameArea;
import bizcal.swing.util.TableLayoutPanel;
import bizcal.util.BizcalException;
import bizcal.util.DateUtil;
import bizcal.util.TextUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonthView
extends CalendarView {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonthView.class);
    private ColumnHeaderPanel columnHeader;
    private List<List> cells = new ArrayList<List>();
    private List hLines = new ArrayList();
    private List vLines = new ArrayList();
    private JScrollPane scrollPane;
    private JPanel calPanel = new JPanel();

    public MonthView(CalendarViewConfig calendarViewConfig) throws Exception {
        super(calendarViewConfig);
        this.calPanel.setLayout(new Layout());
        this.scrollPane = new JScrollPane(this.calPanel, 20, 30);
        this.scrollPane.setCursor(Cursor.getDefaultCursor());
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(15);
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", this.createCorner(true, true));
        this.scrollPane.setCorner("LOWER_LEFT_CORNER", this.createCorner(true, false));
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", this.createCorner(false, true));
        this.columnHeader = new ColumnHeaderPanel(calendarViewConfig, 7);
        this.columnHeader.setShowExtraDateHeaders(true);
        this.columnHeader.setMonthView(true);
        this.scrollPane.setColumnHeaderView(this.columnHeader.getComponent());
    }

    @Override
    public void refresh0() throws Exception {
        int n;
        Object object;
        this.calPanel.removeAll();
        this.cells.clear();
        this.hLines.clear();
        this.vLines.clear();
        java.util.Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(this.getInterval().getStartDate());
        calendar.add(6, 15);
        int n2 = calendar.get(2);
        int n3 = calendar.getFirstDayOfWeek();
        if (--n3 < 1) {
            n3 += 7;
        }
        block0: for (Calendar calendar2 : this.getModel().getSelectedCalendars()) {
            calendar.setTime(this.getInterval().getStartDate());
            calendar.set(5, 1);
            calendar.set(7, calendar.getFirstDayOfWeek());
            Map<Date, List<Event>> map = this.createEventsPerDay(calendar2.getId());
            int n4 = 0;
            while (true) {
                if (this.cells.size() <= n4) {
                    object = new ArrayList();
                    this.cells.add((List)object);
                } else {
                    object = this.cells.get(n4);
                }
                JComponent jComponent = this.createDayCell(calendar, map, n2, calendar2.getId());
                this.calPanel.add(jComponent);
                object.add(jComponent);
                if (calendar.get(7) == n3) {
                    if (calendar.get(2) != n2) continue block0;
                    ++n4;
                }
                calendar.add(5, 1);
            }
        }
        int n5 = this.getModel().getSelectedCalendars().size() * 7;
        for (n = 0; n < n5 - 1; ++n) {
            JLabel jLabel = new JLabel();
            jLabel.setBackground(Color.LIGHT_GRAY);
            jLabel.setOpaque(true);
            if ((n + 1) % 7 == 0) {
                jLabel.setBackground(this.getDescriptor().getLineColor3());
            }
            this.calPanel.add(jLabel);
            this.vLines.add(jLabel);
        }
        n = this.cells.size() - 1;
        for (int i = 0; i < n; ++i) {
            object = new JLabel();
            ((JComponent)object).setBackground(Color.LIGHT_GRAY);
            ((JComponent)object).setOpaque(true);
            this.calPanel.add((Component)object);
            this.hLines.add(object);
        }
        this.columnHeader.setModel(this.getModel());
        this.columnHeader.setPopupMenuCallback(this.popupMenuCallback);
        this.columnHeader.refresh();
    }

    private JComponent createDayCell(java.util.Calendar calendar, Map<Date, List<Event>> map, int n, Object object) throws Exception {
        Font font = this.font;
        TableLayoutPanel tableLayoutPanel = new TableLayoutPanel();
        if (DateUtil.isSameDay(calendar.getTime(), new Date())) {
            tableLayoutPanel.setBackground(Color.GREEN);
        } else if (calendar.get(2) == n) {
            tableLayoutPanel.setBackground(Color.WHITE);
        } else {
            tableLayoutPanel.setBackground(new Color(230, 230, 230));
        }
        tableLayoutPanel.createColumn(-1.0);
        int n2 = calendar.get(5);
        String string = "" + n2;
        TableLayoutPanel.Row row = tableLayoutPanel.createRow();
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(this.font.deriveFont(1));
        row.createCell(jLabel);
        tableLayoutPanel.createRow(-1.0);
        List<Event> list = map.get(DateUtil.round2Day(calendar.getTime()));
        if (list != null) {
            for (Event event : list) {
                row = tableLayoutPanel.createRow();
                String string2 = "";
                if (event.getSummary() != null) {
                    string2 = event.getSummary();
                }
                JLabel jLabel2 = new JLabel(string2);
                jLabel2.setFont(font);
                jLabel2.setToolTipText(event.getToolTip());
                jLabel2.setOpaque(true);
                jLabel2.setBackground(event.getColor());
                jLabel2.setForeground(FrameArea.computeForeground(event.getColor()));
                if (event.getIcon() != null) {
                    jLabel2.setIcon(event.getIcon());
                }
                jLabel2.addMouseListener(new EventMouseListener(event, object));
                row.createCell(jLabel2, 0, 2);
            }
        }
        tableLayoutPanel.addMouseListener(new DayMouseListener(object, calendar.getTime()));
        JScrollPane jScrollPane = new JScrollPane(tableLayoutPanel, 20, 31);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        return tableLayoutPanel;
    }

    @Override
    protected Date getDate(int n, int n2) throws Exception {
        return null;
    }

    public long getTimeInterval() throws Exception {
        return -1702967296L;
    }

    protected String getHeaderText() throws Exception {
        java.util.Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(this.getInterval().getStartDate());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM yyyy", Locale.getDefault());
        return TextUtil.formatCase(simpleDateFormat.format(calendar.getTime()));
    }

    @Override
    protected boolean supportsDrag() {
        return false;
    }

    private int getPreferredHeight() {
        return this.cells.size() * 40;
    }

    @Override
    public JComponent getComponent() {
        return this.scrollPane;
    }

    @Override
    public void addListener(CalendarListener calendarListener) {
        super.addListener(calendarListener);
        this.columnHeader.addCalendarListener(calendarListener);
    }

    private class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            try {
                int n = 7 * MonthView.this.getModel().getSelectedCalendars().size() * 10;
                return new Dimension(n, MonthView.this.getPreferredHeight());
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(50, 100);
        }

        @Override
        public void layoutContainer(Container container) {
            try {
                int n;
                JComponent jComponent;
                int n2;
                double d = container.getWidth();
                d /= (double)MonthView.this.getModel().getSelectedCalendars().size();
                d /= 7.0;
                double d2 = container.getHeight();
                d2 /= (double)MonthView.this.cells.size();
                for (n2 = 0; n2 < MonthView.this.cells.size(); ++n2) {
                    List list = (List)MonthView.this.cells.get(n2);
                    for (int i = 0; i < list.size(); ++i) {
                        jComponent = (JComponent)list.get(i);
                        jComponent.setBounds((int)((double)i * d + 1.0), (int)((double)n2 * d2 + 1.0), (int)d - 1, (int)d2 - 1);
                    }
                }
                n2 = MonthView.this.getModel().getSelectedCalendars().size() * 7;
                for (n = 0; n < n2 - 1; ++n) {
                    try {
                        JLabel jLabel = (JLabel)MonthView.this.vLines.get(n);
                        jLabel.setBounds((int)((double)(n + 1) * d), 0, 1, container.getHeight());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                n = MonthView.this.cells.size() - 1;
                for (int i = 0; i < n; ++i) {
                    try {
                        jComponent = (JLabel)MonthView.this.hLines.get(i);
                        jComponent.setBounds(0, (int)((double)(i + 1) * d2), container.getWidth(), 1);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }
    }

    private class DayMouseListener
    extends MouseAdapter {
        private Object calId;
        private Date date;
        private boolean popupTriggered = false;

        public DayMouseListener(Object object, Date date) {
            this.calId = object;
            this.date = date;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            jComponent.setBackground(jComponent.getBackground().darker());
            jComponent.setForeground(Color.LIGHT_GRAY);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            jComponent.setBackground(jComponent.getBackground().brighter());
            jComponent.setForeground(Color.BLACK);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                if (MonthView.this.listener == null) {
                    return;
                }
                if (mouseEvent.getClickCount() < 2) {
                    MonthView.this.listener.dateSelected(this.date);
                    return;
                }
                if (!MonthView.this.getModel().isInsertable(this.calId, this.date)) {
                    return;
                }
                MonthView.this.listener.newEvent(this.calId, this.date);
            }
            catch (Exception exception) {
                ErrorHandler.handleError(exception);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupTriggered = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.popupTriggered || mouseEvent.isPopupTrigger()) {
                try {
                    if (MonthView.this.popupMenuCallback == null) {
                        return;
                    }
                    JPopupMenu jPopupMenu = MonthView.this.popupMenuCallback.getEmptyPopupMenu(this.calId, this.date);
                    if (jPopupMenu != null) {
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
                catch (Exception exception) {
                    ErrorHandler.handleError(exception);
                }
                finally {
                    this.popupTriggered = false;
                }
            }
        }
    }

    private class EventMouseListener
    extends MouseAdapter {
        private Event event;
        private Object calId;
        private boolean popupTriggered = false;

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            jComponent.setForeground(Color.WHITE);
            jComponent.setBackground(jComponent.getBackground().darker());
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            jComponent.setForeground(Color.BLACK);
            jComponent.setBackground(jComponent.getBackground().brighter());
        }

        public EventMouseListener(Event event, Object object) {
            this.calId = object;
            this.event = event;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                if (MonthView.this.listener == null) {
                    return;
                }
                if (mouseEvent.getClickCount() == 2) {
                    MonthView.this.listener.showEvent(this.calId, this.event);
                }
            }
            catch (Exception exception) {
                ErrorHandler.handleError(exception);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupTriggered = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.popupTriggered || mouseEvent.isPopupTrigger()) {
                try {
                    MonthView.this.showEventpopup(mouseEvent, this.calId, this.event);
                }
                catch (Exception exception) {
                    ErrorHandler.handleError(exception);
                }
                finally {
                    this.popupTriggered = false;
                }
            }
        }
    }
}

