/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal;

import bizcal.common.Event;
import bizcal.swing.DayView;
import bizcal.swing.PopupMenuCallback;
import bizcal.util.DateUtil;
import com.toedter.calendar.JCalendar;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lu.tudor.santec.bizcal.AbstractCalendarView;
import lu.tudor.santec.bizcal.CalendarIcons;
import lu.tudor.santec.bizcal.NamedCalendar;
import lu.tudor.santec.bizcal.listeners.CalendarManagementListener;
import lu.tudor.santec.bizcal.listeners.DateListener;
import lu.tudor.santec.bizcal.listeners.IZoomSliderListener;
import lu.tudor.santec.bizcal.listeners.NamedCalendarListener;
import lu.tudor.santec.bizcal.views.DayViewPanel;
import lu.tudor.santec.bizcal.views.ListViewPanel;
import lu.tudor.santec.bizcal.widgets.BubbleLabel;
import lu.tudor.santec.bizcal.widgets.ButtonPanel;
import lu.tudor.santec.bizcal.widgets.CheckBoxPanel;
import lu.tudor.santec.bizcal.widgets.NaviBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CalendarPanel
extends JPanel
implements MouseListener,
IZoomSliderListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarPanel.class);
    Vector<Action> functionsActionsVector = new Vector();
    LinkedHashMap<String, AbstractCalendarView> calendarViews = new LinkedHashMap();
    private NaviBar naviBar;
    public JCalendar dayChooser;
    private ButtonPanel viewsButtonPanel;
    private ButtonPanel calendarButtonPanel;
    private JPanel viewsPanel;
    private CardLayout viewsCardLayout;
    private transient ActionListener viewListener;
    private Vector<DateListener> dateListeners = new Vector();
    private Vector<NamedCalendarListener> calendarListeners = new Vector();
    private List<CalendarManagementListener> calendarManagementListeners = new ArrayList<CalendarManagementListener>();
    private Date date = new Date();
    private LinkedHashMap<NamedCalendar, CheckBoxPanel> namedCalendars = new LinkedHashMap();
    private JPopupMenu popup;
    private AbstractAction modifyCalendarAction;
    private AbstractAction newCalendarAction;
    private AbstractAction deleteCalendarAction;
    private ButtonPanel functionsButtonPanel;
    protected AbstractCalendarView currentView;
    private JSlider slider;
    private NamedCalendar lastShowingCalendarBeforeShowAll = null;
    private static Color headerColor = new Color(153, 204, 255);
    private ButtonGroup calendarButtonGroup = new ButtonGroup();
    private Vector<IZoomSliderListener> zoomSliderListeners = new Vector();
    private Thread dayViewUpdateThread;
    public final DateFormat timeFormat = new SimpleDateFormat("ss", Locale.getDefault());

    public CalendarPanel() {
        this.setLayout(new BorderLayout(3, 3));
        this.setBackground(Color.WHITE);
        this.createMainPanel();
        this.add((Component)this.viewsPanel, "Center");
        this.createNaviBar();
        this.add((Component)this.naviBar, "East");
        this.initPopup();
        this.dayViewUpdateThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        DayView dayView;
                        if (CalendarPanel.this.currentView != null && CalendarPanel.this.currentView.getView() instanceof DayView && !(dayView = (DayView)CalendarPanel.this.currentView.getView()).getIsCreating() && !dayView.getIsDragging() && !dayView.getIsResizeing()) {
                            dayView.setCurrentTimeLine();
                            CalendarPanel.this.repaint();
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Can't repaint day view.");
                        LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                    try {
                        Thread.sleep(6000L);
                        continue;
                    }
                    catch (Exception exception) {
                        LOGGER.error("Thread for repainting day view was interrupted.");
                        LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        continue;
                    }
                    break;
                }
            }
        });
        this.dayViewUpdateThread.setDaemon(true);
        this.dayViewUpdateThread.start();
    }

    private void createMainPanel() {
        this.viewsCardLayout = new CardLayout();
        this.viewsPanel = new JPanel(this.viewsCardLayout);
        this.viewsPanel.setOpaque(false);
    }

    private void createNaviBar() {
        this.naviBar = new NaviBar(110);
        this.viewsButtonPanel = new ButtonPanel(I18N.tr("views"), headerColor, 5, new Vector<AbstractButton>());
        this.naviBar.addButtonPanel(this.viewsButtonPanel, 1);
        this.viewListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarPanel.this.viewsCardLayout.show(CalendarPanel.this.viewsPanel, actionEvent.getActionCommand());
                CalendarPanel.this.currentView = CalendarPanel.this.calendarViews.get(actionEvent.getActionCommand());
            }
        };
        this.functionsButtonPanel = new ButtonPanel(I18N.tr("functions"), headerColor, 5, this.functionsActionsVector, false, true);
        this.naviBar.addButtonPanel(this.functionsButtonPanel, 1);
        this.calendarButtonPanel = new ButtonPanel(I18N.tr("calendars"), headerColor, 1, new Vector<AbstractButton>());
        this.naviBar.addButtonPanel(this.calendarButtonPanel, 4);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 2));
        jPanel.setOpaque(false);
        jPanel.setBackground(Color.WHITE);
        BubbleLabel bubbleLabel = new BubbleLabel(" " + I18N.tr("choose date") + ":");
        bubbleLabel.setBackground(Color.YELLOW);
        bubbleLabel.setPreferredSize(new Dimension(22, 22));
        jPanel.add((Component)bubbleLabel, "North");
        this.dayChooser = new JCalendar(this.date);
        for (int i = 0; i < this.dayChooser.getDayChooser().getComponents().length; ++i) {
            this.dayChooser.getDayChooser().getComponent(i).setBackground(Color.WHITE);
        }
        this.dayChooser.getDayChooser().setDayBordersVisible(false);
        this.dayChooser.getDayChooser().setDecorationBackgroundVisible(false);
        this.dayChooser.getDayChooser().setDecorationBordersVisible(false);
        this.dayChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("calendar".equals(propertyChangeEvent.getPropertyName()) || "date".equals(propertyChangeEvent.getPropertyName())) {
                    CalendarPanel.this.date = CalendarPanel.this.dayChooser.getDate();
                    for (DateListener dateListener : CalendarPanel.this.dateListeners) {
                        dateListener.dateChanged(CalendarPanel.this.date);
                    }
                }
            }
        });
        jPanel.add((Component)this.dayChooser, "Center");
        JButton jButton = new JButton(I18N.tr("goto today"), CalendarIcons.getMediumIcon("today.png"));
        jButton.setHorizontalAlignment(2);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarPanel.this.setDate(new Date());
            }
        });
        jPanel.add((Component)jButton, "South");
        this.naviBar.addButtonPanel(jPanel, 2);
        this.slider = new JSlider();
        try {
            this.slider.setMinimum(30);
            this.slider.setMaximum(500);
            this.slider.setValue(DayView.PIXELS_PER_HOUR);
        }
        catch (Exception exception) {
            LOGGER.error("Can't init zoom slider.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        this.slider.setOpaque(false);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = ((JSlider)changeEvent.getSource()).getValue();
                for (AbstractCalendarView abstractCalendarView : CalendarPanel.this.calendarViews.values()) {
                    if (!(abstractCalendarView instanceof DayViewPanel)) continue;
                    DayViewPanel dayViewPanel = (DayViewPanel)abstractCalendarView;
                    dayViewPanel.setZoomFactor(n);
                }
                CalendarPanel.this.informZoomSliderListener(n);
            }
        });
        this.addZoomSliderListener(this);
        this.slider.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                CalendarPanel.this.slider.setValue(CalendarPanel.this.slider.getValue() + mouseWheelEvent.getWheelRotation() * 6);
            }
        });
        this.naviBar.addButtonPanel(this.slider, 2);
    }

    public void showView(String string) {
        if (string == null) {
            return;
        }
        for (AbstractCalendarView abstractCalendarView : this.calendarViews.values()) {
            if (!string.equals(abstractCalendarView.getButton().getActionCommand())) continue;
            abstractCalendarView.getButton().doClick();
            return;
        }
    }

    public void addCalendarView(AbstractCalendarView abstractCalendarView) {
        this.viewsPanel.add((Component)abstractCalendarView, abstractCalendarView.getViewName());
        this.viewsButtonPanel.addToggleButton(abstractCalendarView.getButton());
        abstractCalendarView.getButton().setActionCommand(abstractCalendarView.getViewName());
        abstractCalendarView.getButton().addActionListener(this.viewListener);
        this.addDateListener(abstractCalendarView);
        this.addNamedCalendarListener(abstractCalendarView);
        this.calendarViews.put(abstractCalendarView.getViewName(), abstractCalendarView);
        if (this.calendarViews.size() == 1) {
            abstractCalendarView.getButton().doClick();
        }
    }

    public void setDate(Date date) {
        this.dayChooser.setDate(date);
    }

    public Date getDate() {
        return this.date;
    }

    public void addDateListener(DateListener dateListener) {
        this.dateListeners.add(dateListener);
    }

    public void removeDateListener(DateListener dateListener) {
        this.dateListeners.remove(dateListener);
    }

    public void addNamedCalendarListener(NamedCalendarListener namedCalendarListener) {
        this.calendarListeners.add(namedCalendarListener);
    }

    public void removeNamedCalendarListener(NamedCalendarListener namedCalendarListener) {
        this.calendarListeners.remove(namedCalendarListener);
    }

    public void addCalendarManagementListener(CalendarManagementListener calendarManagementListener) {
        this.calendarManagementListeners.add(calendarManagementListener);
    }

    public void removeCalendarManagementListener(CalendarManagementListener calendarManagementListener) {
        this.calendarManagementListeners.remove(calendarManagementListener);
    }

    private synchronized void informZoomSliderListener(final int n) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                for (IZoomSliderListener iZoomSliderListener : CalendarPanel.this.zoomSliderListeners) {
                    iZoomSliderListener.zoomPositionchanged(n);
                }
            }
        };
        thread.start();
    }

    public void removeNamedCalendar(NamedCalendar namedCalendar) {
        if (namedCalendar == null) {
            return;
        }
        this.namedCalendars.remove(namedCalendar);
        try {
            this.calendarButtonPanel.removeComponent(namedCalendar.getCheckBox());
            this.calendarButtonPanel.validate();
            this.calendarButtonPanel.updateUI();
        }
        catch (Exception exception) {
            LOGGER.error("Can't remove calendar.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void addZoomSliderListener(IZoomSliderListener iZoomSliderListener) {
        this.zoomSliderListeners.add(iZoomSliderListener);
    }

    public void removeZoomSliderListener(IZoomSliderListener iZoomSliderListener) {
        this.zoomSliderListeners.remove(iZoomSliderListener);
    }

    public void addNamedCalendar(final NamedCalendar namedCalendar) {
        if (!this.namedCalendars.containsKey(namedCalendar)) {
            final CheckBoxPanel checkBoxPanel = new CheckBoxPanel(namedCalendar.getName(), namedCalendar.getColor(), this.calendarButtonGroup);
            checkBoxPanel.setToolTipText(namedCalendar.getDescription());
            checkBoxPanel.setActiv(namedCalendar.isActive());
            namedCalendar.setCheckBox(checkBoxPanel);
            checkBoxPanel.addMouseListener(this);
            checkBoxPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    block5: {
                        block4: {
                            if (namedCalendar.isActive() == checkBoxPanel.isActiv()) break block4;
                            namedCalendar.setActive(checkBoxPanel.isActiv());
                            for (NamedCalendarListener namedCalendarListener : CalendarPanel.this.calendarListeners) {
                                namedCalendarListener.activeCalendarsChanged(CalendarPanel.this.namedCalendars.keySet());
                            }
                            for (NamedCalendarListener namedCalendarListener : CalendarPanel.this.calendarListeners) {
                                namedCalendarListener.selectedCalendarChanged(CalendarPanel.this.getSelectedCalendar());
                            }
                            break block5;
                        }
                        namedCalendar.setSelected(checkBoxPanel.isSelected());
                        namedCalendar.addBorder();
                        if (!checkBoxPanel.isSelected()) break block5;
                        for (Object object : CalendarPanel.this.namedCalendars.keySet()) {
                            if (((CheckBoxPanel)CalendarPanel.this.namedCalendars.get(object)).equals(checkBoxPanel)) continue;
                            ((NamedCalendar)object).setSelected(false);
                            ((NamedCalendar)object).removeBorder();
                        }
                        for (Object object : CalendarPanel.this.calendarListeners) {
                            object.selectedCalendarChanged(CalendarPanel.this.getSelectedCalendar());
                        }
                    }
                }
            });
            if (!namedCalendar.isBackground().booleanValue()) {
                this.calendarButtonPanel.addComponent(checkBoxPanel);
            }
            this.namedCalendars.put(namedCalendar, checkBoxPanel);
        }
        this.callAllCalenderListeners();
    }

    public void triggerUpdate() {
        for (NamedCalendarListener namedCalendarListener : this.calendarListeners) {
            namedCalendarListener.activeCalendarsChanged(this.namedCalendars.keySet());
        }
        this.calendarButtonPanel.validate();
        this.calendarButtonPanel.updateUI();
    }

    public void next() {
        this.stepDate(true);
    }

    public void pevious() {
        this.stepDate(false);
    }

    private void stepDate(boolean bl) {
        String string = this.getCurrentView().getViewName();
        int n = 0;
        if ("MONTH_VIEW".equals(string)) {
            n = 31;
        } else if ("DAY_VIEW".equals(string)) {
            n = 1;
        } else if ("WEEK_VIEW".equals(string)) {
            n = 7;
        } else if ("DAY_THREE_VIEW".equals(string)) {
            n = 3;
        } else if ("LIST_VIEW".equals(string)) {
            try {
                ListViewPanel listViewPanel = (ListViewPanel)this.calendarViews.get("LIST_VIEW");
                n = listViewPanel.listView.getShowDays();
            }
            catch (Exception exception) {
                LOGGER.error("Can't fetch step size.");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if (!bl) {
            n *= -1;
        }
        this.dayChooser.setDate(DateUtil.getDiffDay(this.dayChooser.getDate(), n));
    }

    public NamedCalendar getSelectedCalendar() {
        if (this.namedCalendars.keySet() != null) {
            for (NamedCalendar namedCalendar : this.namedCalendars.keySet()) {
                if (!namedCalendar.isSelected()) continue;
                return namedCalendar;
            }
        }
        if (this.getActiveCalendars() != null && this.getActiveCalendars().size() > 0) {
            NamedCalendar namedCalendar = (NamedCalendar)this.getActiveCalendars().toArray()[0];
            namedCalendar.setSelected(true);
            this.informListeners();
            return namedCalendar;
        }
        return null;
    }

    public void setSelectedCalendar(Integer n) {
        if (n == null) {
            return;
        }
        for (NamedCalendar namedCalendar : this.namedCalendars.keySet()) {
            if (!n.equals(namedCalendar.getId())) continue;
            this.setSelectedCalendar(namedCalendar);
            return;
        }
    }

    public void setSelectedCalendar(NamedCalendar namedCalendar) {
        if (namedCalendar.isSelected()) {
            return;
        }
        for (NamedCalendar namedCalendar2 : this.namedCalendars.keySet()) {
            if (!namedCalendar2.isSelected()) continue;
            namedCalendar2.setSelected(false);
            namedCalendar2.removeBorder();
            break;
        }
        namedCalendar.setSelected(true);
        namedCalendar.getCheckBox().setSelected(true);
        namedCalendar.addBorder();
        if (this.lastShowingCalendarBeforeShowAll != null) {
            this.lastShowingCalendarBeforeShowAll = null;
        }
    }

    public void selectNextCalendar() {
        NamedCalendar namedCalendar = this.getSelectedCalendar();
        if (namedCalendar == null) {
            return;
        }
        ArrayList<NamedCalendar> arrayList = new ArrayList<NamedCalendar>(this.namedCalendars.keySet());
        int n = arrayList.size();
        int n2 = arrayList.indexOf(namedCalendar);
        if (++n2 > n - 1) {
            n2 = 0;
        }
        NamedCalendar namedCalendar2 = arrayList.get(n2);
        namedCalendar2.setActive(true);
        this.namedCalendars.get(namedCalendar2).setActiv(true);
        this.setSelectedCalendar(arrayList.get(n2));
        this.informListeners();
    }

    public void selectPreviousCalendar() {
        NamedCalendar namedCalendar = this.getSelectedCalendar();
        if (namedCalendar == null) {
            return;
        }
        ArrayList<NamedCalendar> arrayList = new ArrayList<NamedCalendar>(this.namedCalendars.keySet());
        int n = arrayList.size();
        int n2 = arrayList.indexOf(namedCalendar);
        if (--n2 < 0) {
            n2 = n - 1;
        }
        NamedCalendar namedCalendar2 = arrayList.get(n2);
        namedCalendar2.setActive(true);
        this.namedCalendars.get(namedCalendar2).setActiv(true);
        this.setSelectedCalendar(arrayList.get(n2));
        this.informListeners();
    }

    public void toggleShowAllCalendars() {
        if (this.lastShowingCalendarBeforeShowAll == null) {
            this.lastShowingCalendarBeforeShowAll = this.getSelectedCalendar();
            ArrayList<NamedCalendar> arrayList = new ArrayList<NamedCalendar>(this.namedCalendars.keySet());
            for (NamedCalendar namedCalendar : arrayList) {
                namedCalendar.setActive(true);
                this.namedCalendars.get(namedCalendar).setActiv(true);
            }
        } else {
            NamedCalendar namedCalendar = this.lastShowingCalendarBeforeShowAll;
            namedCalendar.setSelected(true);
            namedCalendar.setActive(true);
            this.namedCalendars.get(namedCalendar).setActiv(true);
            ArrayList<NamedCalendar> arrayList = new ArrayList<NamedCalendar>(this.namedCalendars.keySet());
            for (NamedCalendar namedCalendar2 : arrayList) {
                if (namedCalendar.equals(namedCalendar2) || namedCalendar2.getName().equals("OFFICE")) continue;
                namedCalendar2.setActive(false);
                this.namedCalendars.get(namedCalendar2).setActiv(false);
            }
            this.lastShowingCalendarBeforeShowAll = null;
        }
        this.informListeners();
    }

    public Collection<NamedCalendar> getActiveCalendars() {
        ArrayList<NamedCalendar> arrayList = new ArrayList<NamedCalendar>(0);
        if (this.namedCalendars != null) {
            for (NamedCalendar namedCalendar : this.namedCalendars.keySet()) {
                if (!namedCalendar.isActive()) continue;
                arrayList.add(namedCalendar);
            }
        }
        return arrayList;
    }

    private void informListeners() {
        for (NamedCalendarListener namedCalendarListener : this.calendarListeners) {
            namedCalendarListener.activeCalendarsChanged(this.namedCalendars.keySet());
        }
    }

    public List<NamedCalendar> getCalendars() {
        return new ArrayList<NamedCalendar>(this.namedCalendars.keySet());
    }

    private void initPopup() {
        this.popup = new JPopupMenu();
        this.newCalendarAction = new AbstractAction(I18N.tr("new"), CalendarIcons.getMediumIcon(CalendarIcons.NEW)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (CalendarManagementListener calendarManagementListener : CalendarPanel.this.calendarManagementListeners) {
                    calendarManagementListener.newCalendar();
                }
            }
        };
        this.modifyCalendarAction = new AbstractAction(I18N.tr("modify"), CalendarIcons.getMediumIcon(CalendarIcons.EDIT)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (CalendarManagementListener calendarManagementListener : CalendarPanel.this.calendarManagementListeners) {
                    calendarManagementListener.modifyCalendar(CalendarPanel.this.getSelectedCalendar());
                }
            }
        };
        this.deleteCalendarAction = new AbstractAction(I18N.tr("delete"), CalendarIcons.getMediumIcon(CalendarIcons.DELETE)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (CalendarManagementListener calendarManagementListener : CalendarPanel.this.calendarManagementListeners) {
                    calendarManagementListener.deleteCalendar(CalendarPanel.this.getSelectedCalendar());
                }
            }
        };
        this.popup.add(this.newCalendarAction);
        this.popup.add(new JSeparator());
        this.popup.add(this.modifyCalendarAction);
        this.popup.add(new JSeparator());
        this.popup.add(this.deleteCalendarAction);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.showContextMenu(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.showContextMenu(mouseEvent);
    }

    private void showContextMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            try {
                ((CheckBoxPanel)((JToggleButton)mouseEvent.getSource()).getParent()).setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.popup.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public ButtonPanel getFunctionsButtonPanel() {
        return this.functionsButtonPanel;
    }

    public AbstractCalendarView getCurrentView() {
        return this.currentView;
    }

    @Override
    public void zoomPositionchanged(int n) {
    }

    public void setZoomPosition(Integer n) {
        if (n != null) {
            this.slider.setValue(n);
        }
    }

    public void callAllCalenderListeners() {
        for (NamedCalendarListener namedCalendarListener : this.calendarListeners) {
            namedCalendarListener.selectedCalendarChanged(this.getSelectedCalendar());
        }
        for (NamedCalendarListener namedCalendarListener : this.calendarListeners) {
            namedCalendarListener.activeCalendarsChanged(this.namedCalendars.keySet());
        }
    }

    public Thread getDayViewUpdateThread() {
        return this.dayViewUpdateThread;
    }

    class PopupCallBack
    implements PopupMenuCallback {
        PopupCallBack() {
        }

        @Override
        public JPopupMenu getCalendarPopupMenu(Object object) throws Exception {
            return null;
        }

        @Override
        public JPopupMenu getEmptyPopupMenu(Object object, Date date) throws Exception {
            return null;
        }

        @Override
        public JPopupMenu getEventPopupMenu(Object object, Event event) throws Exception {
            return CalendarPanel.this.popup;
        }

        @Override
        public JPopupMenu getProjectPopupMenu(Object object) throws Exception {
            return null;
        }
    }
}

