/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.views;

import bizcal.common.DayViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarListener;
import bizcal.swing.CalendarView;
import bizcal.swing.DayView;
import bizcal.util.DateInterval;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import lu.tudor.santec.bizcal.AbstractCalendarView;
import lu.tudor.santec.bizcal.CalendarIcons;
import lu.tudor.santec.bizcal.EventModel;
import lu.tudor.santec.bizcal.NamedCalendar;
import lu.tudor.santec.bizcal.print.PrintUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class DayViewPanel
extends AbstractCalendarView {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DayViewPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(DayViewPanel.class);
    private static final int STATE_FULL = 1;
    private static final int STATE_MORNING = 2;
    private static final int STATE_AFTERNOON = 3;
    private int state = 1;
    private JToggleButton button;
    private EventModel dayModel;
    private DayView dayView;
    public static final String VIEW_NAME_DAY = "DAY_VIEW";
    public static final String VIEW_NAME_WEEK = "WEEK_VIEW";
    public static final String VIEW_NAME_THREE_DAY = "DAY_THREE_VIEW";
    public String VIEW_NAME;
    private JButton switcherButton;
    private ImageIcon fullDayIcon;
    private ImageIcon morningDayIcon;
    private ImageIcon afternoonDayIcon;
    private DayViewConfig dayViewConfig;

    public DayViewPanel(EventModel eventModel) {
        this(eventModel, new DayViewConfig(), 0);
    }

    public DayViewPanel(EventModel eventModel, DayViewConfig dayViewConfig) {
        this(eventModel, dayViewConfig, 0);
    }

    public DayViewPanel(EventModel eventModel, Integer n) {
        this(eventModel, new DayViewConfig(), n);
    }

    public DayViewPanel(EventModel eventModel, DayViewConfig dayViewConfig, Integer n) {
        this.dayModel = eventModel;
        this.dayViewConfig = dayViewConfig;
        this.setLayout(new BorderLayout());
        if (this.dayModel.getType() == 1) {
            this.VIEW_NAME = VIEW_NAME_DAY;
            this.button = new JToggleButton(CalendarIcons.getMediumIcon("cal_day.png"));
            this.button.setToolTipText(I18N.tr("day view"));
            eventModel.setDate(new Date());
        } else if (this.dayModel.getType() == 2) {
            this.VIEW_NAME = VIEW_NAME_WEEK;
            this.button = new JToggleButton(CalendarIcons.getMediumIcon("cal_week.png"));
            this.button.setToolTipText(I18N.tr("week view"));
            this.dayModel.setWeekdayStartEnd(this.dayViewConfig.getWeekStart(), this.dayViewConfig.getWeekEnd());
        } else if (this.dayModel.getType() == 4) {
            this.VIEW_NAME = VIEW_NAME_THREE_DAY;
            this.button = new JToggleButton(CalendarIcons.getMediumIcon("cal_three_day.png"));
            this.button.setToolTipText(I18N.tr("three day view"));
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            int n2 = gregorianCalendar.get(7);
            ((Calendar)gregorianCalendar).add(7, 2);
            int n3 = gregorianCalendar.get(7);
            this.dayModel.setWeekdayStartEnd(n2, n3);
        }
        try {
            this.initDayViewSwitcherButton();
            this.dayView = new DayView(this.dayViewConfig, this.switcherButton, n);
            this.dayView.setModel(this.dayModel);
            this.dayModel.addCalendarView(this.dayView);
            this.dayView.refresh();
            this.add(this.dayView.getComponent());
            this.updateSwitcherButton();
        }
        catch (Exception exception) {
            LOGGER.error("Can't init day view.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void refresh() {
        try {
            this.updateSwitcherButton();
            this.refreshGrid();
        }
        catch (Exception exception) {
            LOGGER.error("Can't refresh day view.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private void refreshGrid() {
        try {
            this.dayView.resetHorizontalLines();
            this.dayView.refresh();
        }
        catch (Exception exception) {
            LOGGER.error("Can't refresh day view grid.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private void initDayViewSwitcherButton() {
        this.switcherButton = new JButton(CalendarIcons.getMediumIcon(CalendarIcons.DELETE));
        this.switcherButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DayViewPanel.this.switchState();
                DayViewPanel.this.updateSwitcherButton();
            }
        });
        this.switcherButton.setBorderPainted(false);
        this.switcherButton.setContentAreaFilled(false);
        this.switcherButton.setFocusPainted(false);
        this.fullDayIcon = CalendarIcons.getMediumIcon("cal_month.png");
        this.morningDayIcon = CalendarIcons.getMediumIcon("cal_day_morning.png");
        this.afternoonDayIcon = CalendarIcons.getMediumIcon("cal_day_afternoon.png");
    }

    private void updateSwitcherButton() {
        if (1 == this.state) {
            this.switcherButton.setIcon(this.fullDayIcon);
            this.switcherButton.setToolTipText(I18N.tr("switch to morning view"));
            this.dayViewConfig.setDayStartHour(this.dayViewConfig.getDefaultDayStartHour());
            this.dayViewConfig.setDayEndHour(this.dayViewConfig.getDefaultDayEndHour());
        } else if (2 == this.state) {
            this.switcherButton.setIcon(this.morningDayIcon);
            this.switcherButton.setToolTipText(I18N.tr("switch to afternoon view"));
            this.dayViewConfig.setDayStartHour(this.dayViewConfig.getDefaultDayStartHour());
            this.dayViewConfig.setDayEndHour(this.dayViewConfig.getDayBreak());
        } else if (3 == this.state) {
            this.switcherButton.setIcon(this.afternoonDayIcon);
            this.switcherButton.setToolTipText(I18N.tr("switch to full day view"));
            this.dayViewConfig.setDayStartHour(this.dayViewConfig.getDayBreak());
            this.dayViewConfig.setDayEndHour(this.dayViewConfig.getDefaultDayEndHour());
        }
        try {
            this.dayView.refresh();
            this.refreshGrid();
        }
        catch (Exception exception) {
            LOGGER.error("Can't update switcher button.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void addCalendarListener(CalendarListener calendarListener) {
        this.dayView.addListener(calendarListener);
    }

    @Override
    public JToggleButton getButton() {
        return this.button;
    }

    @Override
    public String getViewName() {
        return this.VIEW_NAME;
    }

    @Override
    public void dateChanged(Date date) {
        this.dayModel.setDate(date);
        try {
            this.dayView.refresh();
        }
        catch (Exception exception) {
            LOGGER.error("Can't refresh day view.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void moved(Event event, Object object, Date date, Object object2, Date date2) throws Exception {
        event.move(date2);
        this.dayModel.triggerUpdate();
    }

    public void resized(Event event, Object object, Date date, Date date2) throws Exception {
        event.setEnd(date2);
        this.dayModel.triggerUpdate();
    }

    @Override
    public void activeCalendarsChanged(Collection<NamedCalendar> collection) {
        this.dayView.setActiveCalendars(collection);
    }

    @Override
    public void selectedCalendarChanged(NamedCalendar namedCalendar) {
        this.dayView.setSelectedCalendar(namedCalendar);
    }

    @Override
    public List<Event> getEvents() {
        try {
            DateInterval dateInterval = this.dayModel.getInterval();
            Date date = (Date)dateInterval.getStart();
            Date date2 = (Date)dateInterval.getEnd();
            List<Event> list = this.dayModel.getEvents(null);
            ArrayList<Event> arrayList = new ArrayList<Event>();
            if (list != null) {
                for (Event event : list) {
                    if (!event.getStart().after(date) || !event.getStart().before(date2)) continue;
                    arrayList.add(event);
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void setZoomFactor(int n) {
        DayView.PIXELS_PER_HOUR = n;
        this.refresh();
    }

    private void switchState() {
        this.state = 1 == this.state ? 2 : (2 == this.state ? 3 : (3 == this.state ? 1 : 3));
    }

    @Override
    public void print(boolean bl) {
        int n = DayView.PIXELS_PER_HOUR;
        this.setZoomFactor(30);
        if (this.dayModel.getType() == 1) {
            PrintUtilities.printComponent(this, bl, false);
        } else {
            PrintUtilities.printComponent(this, bl, true);
        }
        this.setZoomFactor(n);
    }

    @Override
    public CalendarView getView() {
        return this.dayView;
    }
}

